/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.LcsClientId;
import net.java.slee.resource.diameter.ro.events.avp.LcsClientName;
import net.java.slee.resource.diameter.ro.events.avp.LcsRequestorId;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.LcsClientNameImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.LcsRequestorIdImpl;

public class LcsClientIdImpl
extends GroupedAvpImpl
implements LcsClientId {
    private static final Logger logger = Logger.getLogger(LcsClientIdImpl.class);

    public LcsClientIdImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getLcsApn() {
        if (this.hasLcsApn()) {
            Avp rawAvp = this.avpSet.getAvp(1231, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1231L);
                logger.error((Object)"Failure while trying to obtain LCS-APN AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getLcsClientDialedByMs() {
        if (this.hasLcsClientDialedByMs()) {
            Avp rawAvp = this.avpSet.getAvp(1233, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1233L);
                logger.error((Object)"Failure while trying to obtain LCS-Client-Dialed-By-MS AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getLcsClientExternalId() {
        if (this.hasLcsClientExternalId()) {
            Avp rawAvp = this.avpSet.getAvp(1234, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1234L);
                logger.error((Object)"Failure while trying to obtain LCS-Client-External-ID AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public LcsClientName getLcsClientName() {
        if (this.hasLcsClientName()) {
            Avp rawAvp = this.avpSet.getAvp(1235, 10415L);
            try {
                return new LcsClientNameImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1235L);
                logger.error((Object)"Failure while trying to obtain LCS-Client-Name AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getLcsClientType() {
        if (this.hasLcsClientType()) {
            Avp rawAvp = this.avpSet.getAvp(1241, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1241L);
                logger.error((Object)"Failure while trying to obtain LCS-Client-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public LcsRequestorId getLcsRequestorId() {
        if (this.hasLcsRequestorId()) {
            Avp rawAvp = this.avpSet.getAvp(1239, 10415L);
            try {
                return new LcsRequestorIdImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1239L);
                logger.error((Object)"Failure while trying to obtain LCS-Client-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasLcsApn() {
        return this.hasAvp(1231, 10415L);
    }

    public boolean hasLcsClientDialedByMs() {
        return this.hasAvp(1233, 10415L);
    }

    public boolean hasLcsClientExternalId() {
        return this.hasAvp(1234, 10415L);
    }

    public boolean hasLcsClientName() {
        return this.hasAvp(1235, 10415L);
    }

    public boolean hasLcsClientType() {
        return this.hasAvp(1241, 10415L);
    }

    public boolean hasLcsRequestorId() {
        return this.hasAvp(1239, 10415L);
    }

    public void setLcsApn(String lcsApn) {
        if (this.hasLcsApn()) {
            throw new IllegalStateException("AVP LCS-APN is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1231, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1231, lcsApn, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLcsClientDialedByMs(String lcsClientDialedByMs) {
        if (this.hasLcsClientDialedByMs()) {
            throw new IllegalStateException("AVP LCS-Client-Dialed-By-MS is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1233, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1233, lcsClientDialedByMs, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLcsClientExternalId(String lcsClientExternalId) {
        if (this.hasLcsClientExternalId()) {
            throw new IllegalStateException("AVP LCS-Client-External-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1234, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1234, lcsClientExternalId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLcsClientName(LcsClientName lcsClientName) {
        if (this.hasLcsClientName()) {
            throw new IllegalStateException("AVP LCS-Client-Name is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1235, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1235, lcsClientName.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setLcsClientType(String lcsClientType) {
        if (this.hasLcsClientType()) {
            throw new IllegalStateException("AVP LCS-Client-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1241, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1241, lcsClientType, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLcsRequestorId(LcsRequestorId lcsRequestorId) {
        if (this.hasLcsClientName()) {
            throw new IllegalStateException("AVP LCS-Requestor-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1239, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1239, lcsRequestorId.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }
}

