/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.LcsClientName;
import net.java.slee.resource.diameter.ro.events.avp.LcsFormatIndicator;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class LcsClientNameImpl
extends GroupedAvpImpl
implements LcsClientName {
    private static final Logger logger = Logger.getLogger(LcsClientNameImpl.class);

    public LcsClientNameImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getLcsDataCodingScheme() {
        if (this.hasLcsDataCodingScheme()) {
            Avp rawAvp = this.avpSet.getAvp(1236, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1236L);
                logger.error((Object)"Failure while trying to obtain LCS-Data-Coding-Scheme AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public LcsFormatIndicator getLcsFormatIndicator() {
        if (this.hasLcsFormatIndicator()) {
            Avp rawAvp = this.avpSet.getAvp(1237, 10415L);
            try {
                return LcsFormatIndicator.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1237L);
                logger.error((Object)"Failure while trying to obtain LCS-Format-Indicator AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getLcsNameString() {
        if (this.hasLcsDataCodingScheme()) {
            Avp rawAvp = this.avpSet.getAvp(1238, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1238L);
                logger.error((Object)"Failure while trying to obtain LCS-Name-String AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasLcsDataCodingScheme() {
        return this.hasAvp(1236, 10415L);
    }

    public boolean hasLcsFormatIndicator() {
        return this.hasAvp(1237, 10415L);
    }

    public boolean hasLcsNameString() {
        return this.hasAvp(1238, 10415L);
    }

    public void setLcsDataCodingScheme(String lcsDataCodingScheme) {
        if (this.hasLcsDataCodingScheme()) {
            throw new IllegalStateException("AVP LCS-Data-Coding-Scheme is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1236, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1236, lcsDataCodingScheme, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLcsFormatIndicator(LcsFormatIndicator lcsFormatIndicator) {
        if (this.hasLcsFormatIndicator()) {
            throw new IllegalStateException("AVP LCS-Format-Indicator is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1237, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1237, lcsFormatIndicator.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setLcsNameString(String lcsNameString) {
        if (this.hasLcsNameString()) {
            throw new IllegalStateException("AVP LCS-Name-String is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1238, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1238, lcsNameString, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

