/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.LcsClientId;
import net.java.slee.resource.diameter.ro.events.avp.LcsInformation;
import net.java.slee.resource.diameter.ro.events.avp.LocationType;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.LcsClientIdImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.LocationTypeImpl;

public class LcsInformationImpl
extends GroupedAvpImpl
implements LcsInformation {
    private static final Logger logger = Logger.getLogger(LcsInformationImpl.class);

    public LcsInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public LcsClientId getLcsClientId() {
        if (this.hasLcsClientId()) {
            Avp rawAvp = this.avpSet.getAvp(1232, 10415L);
            try {
                return new LcsClientIdImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1232L);
                logger.error((Object)"Failure while trying to obtain LCS-Client-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getLocationEstimate() {
        if (this.hasLocationEstimate()) {
            Avp rawAvp = this.avpSet.getAvp(1242, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1242L);
                logger.error((Object)"Failure while trying to obtain Location-Estimate AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public LocationType getLocationType() {
        if (this.hasLcsClientId()) {
            Avp rawAvp = this.avpSet.getAvp(1244, 10415L);
            try {
                return new LocationTypeImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1244L);
                logger.error((Object)"Failure while trying to obtain Location-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasLcsClientId() {
        return this.hasAvp(1232, 10415L);
    }

    public boolean hasLocationEstimate() {
        return this.hasAvp(1242, 10415L);
    }

    public boolean hasLocationType() {
        return this.hasAvp(1244, 10415L);
    }

    public void setLcsClientId(LcsClientId lcsClientId) {
        if (this.hasLcsClientId()) {
            throw new IllegalStateException("AVP LCS-Client-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1232, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1232, lcsClientId.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setLocationEstimate(String locationEstimate) {
        if (this.hasLocationEstimate()) {
            throw new IllegalStateException("AVP Location-Estimate is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1242, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1242, locationEstimate, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLocationType(LocationType locationType) {
        if (this.hasLocationType()) {
            throw new IllegalStateException("AVP Location-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1244, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1244, locationType.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }
}

