/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.LcsRequestorId;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class LcsRequestorIdImpl
extends GroupedAvpImpl
implements LcsRequestorId {
    private static final Logger logger = Logger.getLogger(LcsRequestorIdImpl.class);

    public LcsRequestorIdImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getLcsDataCodingScheme() {
        if (this.hasLcsDataCodingScheme()) {
            Avp rawAvp = this.avpSet.getAvp(1236, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1236L);
                logger.error((Object)"Failure while trying to obtain LCS-Data-Coding-Scheme AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getLcsRequestorIdString() {
        if (this.hasLcsRequestorIdString()) {
            Avp rawAvp = this.avpSet.getAvp(1240, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1240L);
                logger.error((Object)"Failure while trying to obtain LCS-Requestor-Id-String AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasLcsDataCodingScheme() {
        return this.hasAvp(1236, 10415L);
    }

    public boolean hasLcsRequestorIdString() {
        return this.hasAvp(1240, 10415L);
    }

    public void setLcsDataCodingScheme(String lcsDataCodingScheme) {
        if (this.hasLcsDataCodingScheme()) {
            throw new IllegalStateException("AVP LCS-Data-Coding-Scheme is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1236, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1236, lcsDataCodingScheme, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLcsRequestorIdString(String lcsRequestorIdString) {
        if (this.hasLcsDataCodingScheme()) {
            throw new IllegalStateException("AVP LCS-Requestor-Id-String is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1240, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1240, lcsRequestorIdString, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

