/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.LocationEstimateType;
import net.java.slee.resource.diameter.ro.events.avp.LocationType;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class LocationTypeImpl
extends GroupedAvpImpl
implements LocationType {
    private static final Logger logger = Logger.getLogger(LocationTypeImpl.class);

    public LocationTypeImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getDeferredLocationEventType() {
        if (this.hasDeferredLocationEventType()) {
            Avp rawAvp = this.avpSet.getAvp(1230, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1230L);
                logger.error((Object)"Failure while trying to obtain Deferred-Location-Event-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public LocationEstimateType getLocationEstimateType() {
        if (this.hasLocationEstimateType()) {
            Avp rawAvp = this.avpSet.getAvp(1243, 10415L);
            try {
                return LocationEstimateType.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1243L);
                logger.error((Object)"Failure while trying to obtain Location-Estimate-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasDeferredLocationEventType() {
        return this.hasAvp(1230, 10415L);
    }

    public boolean hasLocationEstimateType() {
        return this.hasAvp(1243, 10415L);
    }

    public void setDeferredLocationEventType(String deferredLocationEventType) {
        if (this.hasDeferredLocationEventType()) {
            throw new IllegalStateException("AVP Deferred-Location-Event-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1230, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1230, deferredLocationEventType, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setLocationEstimateType(LocationEstimateType locationEstimateType) {
        if (this.hasLocationEstimateType()) {
            throw new IllegalStateException("AVP Location-Estimate-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1243, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1243, locationEstimateType.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }
}

