/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.FileRepairSupported;
import net.java.slee.resource.diameter.ro.events.avp.MbmsInformation;
import net.java.slee.resource.diameter.ro.events.avp.MbmsUserServiceType;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class MbmsInformationImpl
extends GroupedAvpImpl
implements MbmsInformation {
    private static final Logger logger = Logger.getLogger(MbmsInformationImpl.class);

    public MbmsInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public FileRepairSupported getFileRepairSupported() {
        if (this.hasFileRepairSupported()) {
            Avp rawAvp = this.avpSet.getAvp(1224, 10415L);
            try {
                return FileRepairSupported.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1224L);
                logger.error((Object)"Failure while trying to obtain File-Repair-Supported AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getMbms2g3gIndicator() {
        if (this.hasMbms2g3gIndicator()) {
            Avp rawAvp = this.avpSet.getAvp(907, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 907L);
                logger.error((Object)"Failure while trying to obtain MBMS-2G-3G-Indicator AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[][] getMbmsServiceAreas() {
        Object mbmsServiceAreas = null;
        AvpSet rawAvps = this.avpSet.getAvps(903, 10415L);
        mbmsServiceAreas = new byte[rawAvps.size()][];
        int i = 0;
        try {
            for (Avp rawAvp : rawAvps) {
                mbmsServiceAreas[i++] = rawAvp.getRaw();
            }
        }
        catch (AvpDataException e) {
            this.reportAvpFetchError(e.getMessage(), 903L);
            logger.error((Object)"Failure while trying to obtain MBMS-Service-Area AVP.", (Throwable)e);
        }
        return null;
    }

    public byte[] getMbmsServiceType() {
        if (this.hasMbmsServiceType()) {
            Avp rawAvp = this.avpSet.getAvp(906, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 906L);
                logger.error((Object)"Failure while trying to obtain MBMS-Service-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getMbmsSessionIdentity() {
        if (this.hasMbmsSessionIdentity()) {
            Avp rawAvp = this.avpSet.getAvp(908, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 908L);
                logger.error((Object)"Failure while trying to obtain MBMS-Session-Identity AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public MbmsUserServiceType getMbmsUserServiceType() {
        if (this.hasMbmsUserServiceType()) {
            Avp rawAvp = this.avpSet.getAvp(1225, 10415L);
            try {
                return MbmsUserServiceType.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1225L);
                logger.error((Object)"Failure while trying to obtain MBMS-User-Service-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getRai() {
        if (this.hasRai()) {
            Avp rawAvp = this.avpSet.getAvp(909, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 909L);
                logger.error((Object)"Failure while trying to obtain RAI AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getRequiredMbmsBearerCapabilities() {
        if (this.hasRequiredMbmsBearerCapabilities()) {
            Avp rawAvp = this.avpSet.getAvp(901, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 901L);
                logger.error((Object)"Failure while trying to obtain Required-MBMS-Bearer-Capabilities AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTmgi() {
        if (this.hasTmgi()) {
            Avp rawAvp = this.avpSet.getAvp(900, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 900L);
                logger.error((Object)"Failure while trying to obtain TMGI AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasFileRepairSupported() {
        return this.hasAvp(1224, 10415L);
    }

    public boolean hasMbms2g3gIndicator() {
        return this.hasAvp(907, 10415L);
    }

    public boolean hasMbmsServiceType() {
        return this.hasAvp(906, 10415L);
    }

    public boolean hasMbmsSessionIdentity() {
        return this.hasAvp(908, 10415L);
    }

    public boolean hasMbmsUserServiceType() {
        return this.hasAvp(1225, 10415L);
    }

    public boolean hasRai() {
        return this.hasAvp(909, 10415L);
    }

    public boolean hasRequiredMbmsBearerCapabilities() {
        return this.hasAvp(901, 10415L);
    }

    public boolean hasTmgi() {
        return this.hasAvp(900, 10415L);
    }

    public void setFileRepairSupported(FileRepairSupported fileRepairSupported) {
        if (this.hasFileRepairSupported()) {
            throw new IllegalStateException("AVP File-Repair-Supported is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1224, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1224, fileRepairSupported.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMbms2g3gIndicator(byte[] mbms2g3gIndicator) {
        if (this.hasMbms2g3gIndicator()) {
            throw new IllegalStateException("AVP MBMS-2G-3G-Indicator is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(907, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(907, mbms2g3gIndicator, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMbmsServiceArea(byte[] mbmsServiceArea) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(903, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(903, mbmsServiceArea, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMbmsServiceAreas(byte[][] mbmsServiceAreas) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(903, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (byte[] mbmsServiceArea : mbmsServiceAreas) {
            this.avpSet.addAvp(903, mbmsServiceArea, 10415L, mandatoryAvp, protectedAvp);
        }
    }

    public void setMbmsServiceType(byte[] mbmsServiceType) {
        if (this.hasMbmsServiceType()) {
            throw new IllegalStateException("AVP MBMS-Service-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(906, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(906, mbmsServiceType, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMbmsSessionIdentity(byte[] mbmsSessionIdentity) {
        if (this.hasMbmsSessionIdentity()) {
            throw new IllegalStateException("AVP MBMS-Session-Identity is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(908, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(908, mbmsSessionIdentity, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMbmsUserServiceType(MbmsUserServiceType mbmsUserServiceType) {
        if (this.hasMbmsUserServiceType()) {
            throw new IllegalStateException("AVP MBMS-User-Service-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1225, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1225, mbmsUserServiceType.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setRai(byte[] rai) {
        if (this.hasRai()) {
            throw new IllegalStateException("AVP RAI is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(909, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(909, rai, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setRequiredMbmsBearerCapabilities(byte[] requiredMbmsBearerCapabilities) {
        if (this.hasRequiredMbmsBearerCapabilities()) {
            throw new IllegalStateException("AVP Required-MBMS-Bearer-Capabilities is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(901, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(901, requiredMbmsBearerCapabilities, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTmgi(byte[] tmgi) {
        if (this.hasTmgi()) {
            throw new IllegalStateException("AVP TMGI is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(900, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(900, tmgi, 10415L, mandatoryAvp, protectedAvp);
    }
}

