/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.MessageBody;
import net.java.slee.resource.diameter.ro.events.avp.Originator;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class MessageBodyImpl
extends GroupedAvpImpl
implements MessageBody {
    private static final Logger logger = Logger.getLogger(MessageBodyImpl.class);

    public MessageBodyImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getContentDisposition() {
        if (this.hasContentDisposition()) {
            Avp rawAvp = this.avpSet.getAvp(828, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 828L);
                logger.error((Object)"Failure while trying to obtain Content-Disposition AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public long getContentLength() {
        if (this.hasContentType()) {
            Avp rawAvp = this.avpSet.getAvp(827, 10415L);
            try {
                return rawAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 827L);
                logger.error((Object)"Failure while trying to obtain Content-Length AVP.", (Throwable)e);
            }
        }
        return -1L;
    }

    public String getContentType() {
        if (this.hasContentType()) {
            Avp rawAvp = this.avpSet.getAvp(826, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 826L);
                logger.error((Object)"Failure while trying to obtain Content-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public Originator getOriginator() {
        if (this.hasOriginator()) {
            Avp rawAvp = this.avpSet.getAvp(864, 10415L);
            try {
                return Originator.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 864L);
                logger.error((Object)"Failure while trying to obtain Originator AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasContentDisposition() {
        return this.hasAvp(828, 10415L);
    }

    public boolean hasContentLength() {
        return this.hasAvp(827, 10415L);
    }

    public boolean hasContentType() {
        return this.hasAvp(826, 10415L);
    }

    public boolean hasOriginator() {
        return this.hasAvp(864, 10415L);
    }

    public void setContentDisposition(String contentDisposition) {
        if (this.hasContentDisposition()) {
            throw new IllegalStateException("AVP Content-Disposition is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(828, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(828, contentDisposition, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setContentLength(long contentLength) {
        if (this.hasContentDisposition()) {
            throw new IllegalStateException("AVP Content-Length is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(827, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(827, contentLength, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setContentType(String contentType) {
        if (this.hasContentDisposition()) {
            throw new IllegalStateException("AVP Content-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(826, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(826, contentType, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setOriginator(Originator originator) {
        if (this.hasOriginator()) {
            throw new IllegalStateException("AVP Originator is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(864, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(864, originator.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }
}

