/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.ClassIdentifier;
import net.java.slee.resource.diameter.ro.events.avp.MessageClass;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class MessageClassImpl
extends GroupedAvpImpl
implements MessageClass {
    private static final Logger logger = Logger.getLogger(MessageClassImpl.class);

    public MessageClassImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public ClassIdentifier getClassIdentifier() {
        if (this.hasClassIdentifier()) {
            Avp rawAvp = this.avpSet.getAvp(1214, 10415L);
            try {
                return ClassIdentifier.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1214L);
                logger.error((Object)"Failure while trying to obtain Class-Identifier AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getTokenText() {
        if (this.hasTokenText()) {
            Avp rawAvp = this.avpSet.getAvp(1215, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1215L);
                logger.error((Object)"Failure while trying to obtain Token-Text AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasClassIdentifier() {
        return this.hasAvp(1214, 10415L);
    }

    public boolean hasTokenText() {
        return this.hasAvp(1215, 10415L);
    }

    public void setClassIdentifier(ClassIdentifier classIdentifier) {
        if (this.hasClassIdentifier()) {
            throw new IllegalStateException("AVP Class-Identifier is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1214, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1214, classIdentifier.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTokenText(String tokenText) {
        if (this.hasTokenText()) {
            throw new IllegalStateException("AVP Token-Text is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1215, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1215, tokenText, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

