/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import java.util.Date;
import net.java.slee.resource.diameter.ro.events.avp.Adaptations;
import net.java.slee.resource.diameter.ro.events.avp.ContentClass;
import net.java.slee.resource.diameter.ro.events.avp.DeliveryReportRequested;
import net.java.slee.resource.diameter.ro.events.avp.DrmContent;
import net.java.slee.resource.diameter.ro.events.avp.MessageClass;
import net.java.slee.resource.diameter.ro.events.avp.MessageType;
import net.java.slee.resource.diameter.ro.events.avp.MmContentType;
import net.java.slee.resource.diameter.ro.events.avp.MmsInformation;
import net.java.slee.resource.diameter.ro.events.avp.OriginatorAddress;
import net.java.slee.resource.diameter.ro.events.avp.Priority;
import net.java.slee.resource.diameter.ro.events.avp.ReadReplyReportRequested;
import net.java.slee.resource.diameter.ro.events.avp.RecipientAddress;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.MessageClassImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.MmContentTypeImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.OriginatorAddressImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.RecipientAddressImpl;

public class MmsInformationImpl
extends GroupedAvpImpl
implements MmsInformation {
    private static final Logger logger = Logger.getLogger(MmsInformationImpl.class);

    public MmsInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public Adaptations getAdaptations() {
        if (this.hasAdaptations()) {
            Avp rawAvp = this.avpSet.getAvp(1217, 10415L);
            try {
                return Adaptations.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1217L);
                logger.error((Object)"Failure while trying to obtain Adaptations AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getApplicId() {
        if (this.hasApplicId()) {
            Avp rawAvp = this.avpSet.getAvp(1218, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1218L);
                logger.error((Object)"Failure while trying to obtain Applic-ID AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getAuxApplicInfo() {
        if (this.hasAuxApplicInfo()) {
            Avp rawAvp = this.avpSet.getAvp(1219, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1219L);
                logger.error((Object)"Failure while trying to obtain Aux-Applic-Info AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public ContentClass getContentClass() {
        if (this.hasContentClass()) {
            Avp rawAvp = this.avpSet.getAvp(1220, 10415L);
            try {
                return ContentClass.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1220L);
                logger.error((Object)"Failure while trying to obtain Content-Class AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public DeliveryReportRequested getDeliveryReportRequested() {
        if (this.hasDeliveryReportRequested()) {
            Avp rawAvp = this.avpSet.getAvp(1216, 10415L);
            try {
                return DeliveryReportRequested.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1216L);
                logger.error((Object)"Failure while trying to obtain Delivery-Report-Requested AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public DrmContent getDrmContent() {
        if (this.hasDrmContent()) {
            Avp rawAvp = this.avpSet.getAvp(1221, 10415L);
            try {
                return DrmContent.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1221L);
                logger.error((Object)"Failure while trying to obtain DRM-Content AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public MessageClass getMessageClass() {
        if (this.hasMessageClass()) {
            Avp rawAvp = this.avpSet.getAvp(1213, 10415L);
            try {
                return new MessageClassImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1213L);
                logger.error((Object)"Failure while trying to obtain Message-Class AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getMessageId() {
        if (this.hasMessageId()) {
            Avp rawAvp = this.avpSet.getAvp(1210, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1210L);
                logger.error((Object)"Failure while trying to obtain Message-ID AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public long getMessageSize() {
        if (this.hasMessageSize()) {
            Avp rawAvp = this.avpSet.getAvp(1212, 10415L);
            try {
                return rawAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1212L);
                logger.error((Object)"Failure while trying to obtain Message-Size AVP.", (Throwable)e);
            }
        }
        return -1L;
    }

    public MessageType getMessageType() {
        if (this.hasMessageType()) {
            Avp rawAvp = this.avpSet.getAvp(1211, 10415L);
            try {
                return MessageType.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1211L);
                logger.error((Object)"Failure while trying to obtain Message-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public MmContentType getMmContentType() {
        if (this.hasMmContentType()) {
            Avp rawAvp = this.avpSet.getAvp(1203, 10415L);
            try {
                return new MmContentTypeImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1203L);
                logger.error((Object)"Failure while trying to obtain MM-Content-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public OriginatorAddress getOriginatorAddress() {
        if (this.hasOriginatorAddress()) {
            Avp rawAvp = this.avpSet.getAvp(886, 10415L);
            try {
                return new OriginatorAddressImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 886L);
                logger.error((Object)"Failure while trying to obtain Originator-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public Priority getPriority() {
        if (this.hasPriority()) {
            Avp rawAvp = this.avpSet.getAvp(1209, 10415L);
            try {
                return Priority.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1209L);
                logger.error((Object)"Failure while trying to obtain Priority AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public ReadReplyReportRequested getReadReplyReportRequested() {
        if (this.hasReadReplyReportRequested()) {
            Avp rawAvp = this.avpSet.getAvp(1222, 10415L);
            try {
                return ReadReplyReportRequested.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1222L);
                logger.error((Object)"Failure while trying to obtain Read-Reply-Report-Requested AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public RecipientAddress[] getRecipientAddresses() {
        RecipientAddress[] recipientAddresses = null;
        AvpSet rawAvps = this.avpSet.getAvps(1201, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            recipientAddresses = new RecipientAddress[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    Avp rawAvp = rawAvps.getAvpByIndex(i);
                    recipientAddresses[i] = new RecipientAddressImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 1201L);
                    logger.error((Object)("Failure while trying to obtain Recipient-Address AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return recipientAddresses;
    }

    public String getReplyApplicId() {
        if (this.hasReplyApplicId()) {
            Avp rawAvp = this.avpSet.getAvp(1223, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1223L);
                logger.error((Object)"Failure while trying to obtain Reply-Applic-ID AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public Date getSubmissionTime() {
        if (this.hasSubmissionTime()) {
            Avp rawAvp = this.avpSet.getAvp(1202, 10415L);
            try {
                return rawAvp.getTime();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1202L);
                logger.error((Object)"Failure while trying to obtain Submission-Time AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getVasId() {
        if (this.hasVasId()) {
            Avp rawAvp = this.avpSet.getAvp(1102, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1102L);
                logger.error((Object)"Failure while trying to obtain VAS-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getVaspId() {
        if (this.hasVaspId()) {
            Avp rawAvp = this.avpSet.getAvp(1101, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1101L);
                logger.error((Object)"Failure while trying to obtain VASP-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasAdaptations() {
        return this.hasAvp(1217, 10415L);
    }

    public boolean hasApplicId() {
        return this.hasAvp(1218, 10415L);
    }

    public boolean hasAuxApplicInfo() {
        return this.hasAvp(1219, 10415L);
    }

    public boolean hasContentClass() {
        return this.hasAvp(1220, 10415L);
    }

    public boolean hasDeliveryReportRequested() {
        return this.hasAvp(1216, 10415L);
    }

    public boolean hasDrmContent() {
        return this.hasAvp(1221, 10415L);
    }

    public boolean hasMessageClass() {
        return this.hasAvp(1213, 10415L);
    }

    public boolean hasMessageId() {
        return this.hasAvp(1210, 10415L);
    }

    public boolean hasMessageSize() {
        return this.hasAvp(1212, 10415L);
    }

    public boolean hasMessageType() {
        return this.hasAvp(1211, 10415L);
    }

    public boolean hasMmContentType() {
        return this.hasAvp(1203, 10415L);
    }

    public boolean hasOriginatorAddress() {
        return this.hasAvp(886, 10415L);
    }

    public boolean hasPriority() {
        return this.hasAvp(1209, 10415L);
    }

    public boolean hasReadReplyReportRequested() {
        return this.hasAvp(1222, 10415L);
    }

    public boolean hasReplyApplicId() {
        return this.hasAvp(1223, 10415L);
    }

    public boolean hasSubmissionTime() {
        return this.hasAvp(1202, 10415L);
    }

    public boolean hasVasId() {
        return this.hasAvp(1102, 10415L);
    }

    public boolean hasVaspId() {
        return this.hasAvp(1101, 10415L);
    }

    public void setAdaptations(Adaptations adaptations) {
        if (this.hasAdaptations()) {
            throw new IllegalStateException("AVP Adaptations is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1217, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1217, adaptations.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setApplicId(String applicId) {
        if (this.hasApplicId()) {
            throw new IllegalStateException("AVP Applic-ID is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1218, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1218, applicId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setAuxApplicInfo(String auxApplicInfo) {
        if (this.hasAuxApplicInfo()) {
            throw new IllegalStateException("AVP Aux-Applic-Info is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1219, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1219, auxApplicInfo, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setContentClass(ContentClass contentClass) {
        if (this.hasContentClass()) {
            throw new IllegalStateException("AVP Content-Class is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1220, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1220, contentClass.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setDeliveryReportRequested(DeliveryReportRequested deliveryReportRequested) {
        if (this.hasDeliveryReportRequested()) {
            throw new IllegalStateException("AVP Delivery-Report-Requested is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1216, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1216, deliveryReportRequested.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setDrmContent(DrmContent drmContent) {
        if (this.hasDrmContent()) {
            throw new IllegalStateException("AVP DRM-Content is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1221, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1221, drmContent.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMessageClass(MessageClass messageClass) {
        if (this.hasMessageClass()) {
            throw new IllegalStateException("AVP Message-Class is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1213, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1213, messageClass.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMessageId(String messageId) {
        if (this.hasMessageId()) {
            throw new IllegalStateException("AVP Message-ID is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1210, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1210, messageId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setMessageSize(long messageSize) {
        if (this.hasMessageSize()) {
            throw new IllegalStateException("AVP Message-Size is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1212, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1212, messageSize, 10415L, mandatoryAvp, protectedAvp, true);
    }

    public void setMessageType(MessageType messageType) {
        if (this.hasMessageType()) {
            throw new IllegalStateException("AVP Message-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1211, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1211, messageType.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMmContentType(MmContentType mmContentType) {
        if (this.hasMmContentType()) {
            throw new IllegalStateException("AVP MM-Content-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1203, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1203, mmContentType.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setOriginatorAddress(OriginatorAddress originatorAddress) {
        if (this.hasOriginatorAddress()) {
            throw new IllegalStateException("AVP Originator-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(886, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(886, originatorAddress.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setPriority(Priority priority) {
        if (this.hasPriority()) {
            throw new IllegalStateException("AVP Priority is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1209, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1209, priority.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setReadReplyReportRequested(ReadReplyReportRequested readReplyReportRequested) {
        if (this.hasReadReplyReportRequested()) {
            throw new IllegalStateException("AVP Read-Reply-Report-Requested is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1222, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1222, readReplyReportRequested.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setRecipientAddress(RecipientAddress recipientAddress) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1201, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1201, recipientAddress.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setRecipientAddresses(RecipientAddress[] recipientAddresses) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1201, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (RecipientAddress recipientAddress : recipientAddresses) {
            this.avpSet.addAvp(1201, recipientAddress.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
        }
    }

    public void setReplyApplicId(String replyApplicId) {
        if (this.hasReplyApplicId()) {
            throw new IllegalStateException("AVP Reply-Applic-ID is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1223, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1223, replyApplicId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setSubmissionTime(Date submissionTime) {
        if (this.hasSubmissionTime()) {
            throw new IllegalStateException("AVP Submission-Time is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1202, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1202, submissionTime, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setVasId(String vasId) {
        if (this.hasVasId()) {
            throw new IllegalStateException("AVP VAS-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1102, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1102, vasId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setVaspId(String vaspId) {
        if (this.hasVaspId()) {
            throw new IllegalStateException("AVP VASP-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1101, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1101, vaspId, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

