/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.AddressDomain;
import net.java.slee.resource.diameter.ro.events.avp.AddressType;
import net.java.slee.resource.diameter.ro.events.avp.OriginatorAddress;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.AddressDomainImpl;

public class OriginatorAddressImpl
extends GroupedAvpImpl
implements OriginatorAddress {
    private static final Logger logger = Logger.getLogger(OriginatorAddressImpl.class);

    public OriginatorAddressImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getAddressData() {
        if (this.hasAddressData()) {
            Avp rawAvp = this.avpSet.getAvp(897, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 897L);
                logger.error((Object)"Failure while trying to obtain Address-Data AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public AddressDomain getAddressDomain() {
        if (this.hasAddressDomain()) {
            Avp rawAvp = this.avpSet.getAvp(898, 10415L);
            try {
                return new AddressDomainImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 898L);
                logger.error((Object)"Failure while trying to obtain Address-Domain AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public AddressType getAddressType() {
        if (this.hasAddressDomain()) {
            Avp rawAvp = this.avpSet.getAvp(899, 10415L);
            try {
                return AddressType.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 899L);
                logger.error((Object)"Failure while trying to obtain Address-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasAddressData() {
        return this.hasAvp(897, 10415L);
    }

    public boolean hasAddressDomain() {
        return this.hasAvp(898, 10415L);
    }

    public boolean hasAddressType() {
        return this.hasAvp(899, 10415L);
    }

    public void setAddressData(String addressData) {
        if (this.hasAddressData()) {
            throw new IllegalStateException("AVP Address-Data is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(897, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(897, addressData, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setAddressDomain(AddressDomain addressDomain) {
        if (this.hasAddressDomain()) {
            throw new IllegalStateException("AVP Address-Domain is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(898, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(898, addressDomain.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setAddressType(AddressType addressType) {
        if (this.hasAddressType()) {
            throw new IllegalStateException("AVP Address-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(899, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(899, addressType.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }
}

