/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.PocInformation;
import net.java.slee.resource.diameter.ro.events.avp.PocServerRole;
import net.java.slee.resource.diameter.ro.events.avp.PocSessionType;
import net.java.slee.resource.diameter.ro.events.avp.TalkBurstExchange;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.MmsInformationImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.TalkBurstExchangeImpl;

public class PocInformationImpl
extends GroupedAvpImpl
implements PocInformation {
    private static final Logger logger = Logger.getLogger(MmsInformationImpl.class);

    public PocInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public int getNumberOfParticipants() {
        if (this.hasNumberOfParticipants()) {
            Avp rawAvp = this.avpSet.getAvp(885, 10415L);
            try {
                return rawAvp.getInteger32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 885L);
                logger.error((Object)"Failure while trying to obtain Number-of-Participants AVP.", (Throwable)e);
            }
        }
        return -1;
    }

    public String[] getParticipantsInvolveds() {
        String[] participantsInvolveds = null;
        AvpSet rawAvps = this.avpSet.getAvps(887, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            participantsInvolveds = new String[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    participantsInvolveds[i] = rawAvps.getAvp(i).getUTF8String();
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 887L);
                    logger.error((Object)("Failure while trying to obtain Participants-Involveds AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return participantsInvolveds;
    }

    public String getPocControllingAddress() {
        if (this.hasPocControllingAddress()) {
            Avp rawAvp = this.avpSet.getAvp(858, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 858L);
                logger.error((Object)"Failure while trying to obtain PoC-Controlling-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getPocGroupName() {
        if (this.hasPocControllingAddress()) {
            Avp rawAvp = this.avpSet.getAvp(859, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 859L);
                logger.error((Object)"Failure while trying to obtain PoC-Group-Name AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public PocServerRole getPocServerRole() {
        if (this.hasPocServerRole()) {
            Avp rawAvp = this.avpSet.getAvp(883, 10415L);
            try {
                return PocServerRole.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 883L);
                logger.error((Object)"Failure while trying to obtain PoC-Server-Role AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getPocSessionId() {
        if (this.hasPocSessionId()) {
            Avp rawAvp = this.avpSet.getAvp(1229, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1229L);
                logger.error((Object)"Failure while trying to obtain PoC-Session-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public PocSessionType getPocSessionType() {
        if (this.hasPocSessionType()) {
            Avp rawAvp = this.avpSet.getAvp(884, 10415L);
            try {
                return PocSessionType.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 884L);
                logger.error((Object)"Failure while trying to obtain PoC-Session-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public TalkBurstExchange[] getTalkBurstExchanges() {
        TalkBurstExchange[] talkBurstExchanges = null;
        AvpSet rawAvps = this.avpSet.getAvps(860, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            talkBurstExchanges = new TalkBurstExchange[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    Avp rawAvp = rawAvps.getAvpByIndex(i);
                    talkBurstExchanges[i] = new TalkBurstExchangeImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 860L);
                    logger.error((Object)("Failure while trying to obtain Talk-Burst-Exchange AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return talkBurstExchanges;
    }

    public boolean hasNumberOfParticipants() {
        return this.hasAvp(885, 10415L);
    }

    public boolean hasPocControllingAddress() {
        return this.hasAvp(858, 10415L);
    }

    public boolean hasPocGroupName() {
        return this.hasAvp(859, 10415L);
    }

    public boolean hasPocServerRole() {
        return this.hasAvp(883, 10415L);
    }

    public boolean hasPocSessionId() {
        return this.hasAvp(1229, 10415L);
    }

    public boolean hasPocSessionType() {
        return this.hasAvp(884, 10415L);
    }

    public void setNumberOfParticipants(int numberOfParticipants) {
        if (this.hasNumberOfParticipants()) {
            throw new IllegalStateException("AVP Number-of-Participants is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(885, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(885, numberOfParticipants, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setParticipantsInvolved(String participantsInvolved) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(887, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(887, participantsInvolved, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setParticipantsInvolveds(String[] participantsInvolveds) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(887, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (String participantsInvolved : participantsInvolveds) {
            this.avpSet.addAvp(887, participantsInvolved, 10415L, mandatoryAvp, protectedAvp, false);
        }
    }

    public void setPocControllingAddress(String pocControllingAddress) {
        if (this.hasPocControllingAddress()) {
            throw new IllegalStateException("AVP PoC-Controlling-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(858, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(858, pocControllingAddress, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setPocGroupName(String pocGroupName) {
        if (this.hasPocGroupName()) {
            throw new IllegalStateException("AVP PoC-Group-Name is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(859, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(859, pocGroupName, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setPocServerRole(PocServerRole pocServerRole) {
        if (this.hasPocServerRole()) {
            throw new IllegalStateException("AVP PoC-Server-Role is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(883, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(883, pocServerRole.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setPocSessionId(String pocSessionId) {
        if (this.hasPocSessionId()) {
            throw new IllegalStateException("AVP PoC-Session-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1229, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1229, pocSessionId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setPocSessionType(PocSessionType pocSessionType) {
        if (this.hasPocSessionType()) {
            throw new IllegalStateException("AVP PoC-Session-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(884, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(884, pocSessionType.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTalkBurstExchange(TalkBurstExchange talkBurstExchange) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(860, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(860, talkBurstExchange.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTalkBurstExchanges(TalkBurstExchange[] talkBurstExchanges) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(860, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (TalkBurstExchange talkBurstExchange : talkBurstExchanges) {
            this.avpSet.addAvp(860, talkBurstExchange.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
        }
    }
}

