/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.PsAppendFreeFormatData;
import net.java.slee.resource.diameter.ro.events.avp.PsFurnishChargingInformation;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class PsFurnishChargingInformationImpl
extends GroupedAvpImpl
implements PsFurnishChargingInformation {
    private static final Logger logger = Logger.getLogger(PsFurnishChargingInformationImpl.class);

    public PsFurnishChargingInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public PsAppendFreeFormatData getPsAppendFreeFormatData() {
        if (this.hasPsAppendFreeFormatData()) {
            Avp rawAvp = this.avpSet.getAvp(867, 10415L);
            try {
                return PsAppendFreeFormatData.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 867L);
                logger.error((Object)"Failure while trying to obtain PS-Append-Free-Format-Data AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getPsFreeFormatData() {
        if (this.hasPsFreeFormatData()) {
            Avp rawAvp = this.avpSet.getAvp(866, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 866L);
                logger.error((Object)"Failure while trying to obtain PS-Free-Format-Data AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppChargingId() {
        if (this.hasTgppChargingId()) {
            Avp rawAvp = this.avpSet.getAvp(2, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 2L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Charging-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasPsAppendFreeFormatData() {
        return this.hasAvp(867, 10415L);
    }

    public boolean hasPsFreeFormatData() {
        return this.hasAvp(866, 10415L);
    }

    public boolean hasTgppChargingId() {
        return this.hasAvp(2, 10415L);
    }

    public void setPsAppendFreeFormatData(PsAppendFreeFormatData psAppendFreeFormatData) {
        if (this.hasPsAppendFreeFormatData()) {
            throw new IllegalStateException("AVP PS-Append-Free-Format-Data is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(867, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(867, psAppendFreeFormatData.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setPsFreeFormatData(byte[] psFreeFormatData) {
        if (this.hasPsFreeFormatData()) {
            throw new IllegalStateException("AVP PS-Free-Format-Data is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(866, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(866, psFreeFormatData, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppChargingId(byte[] tgppChargingId) {
        if (this.hasTgppChargingId()) {
            throw new IllegalStateException("AVP 3GPP-Charging-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(2, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(2, tgppChargingId, 10415L, mandatoryAvp, protectedAvp);
    }
}

