/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.base.events.avp.AddressAvp;
import net.java.slee.resource.diameter.ro.events.avp.PsFurnishChargingInformation;
import net.java.slee.resource.diameter.ro.events.avp.PsInformation;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.AddressAvpImpl;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.PsFurnishChargingInformationImpl;

public class PsInformationImpl
extends GroupedAvpImpl
implements PsInformation {
    private static final Logger logger = Logger.getLogger(PsInformationImpl.class);

    public PsInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public AddressAvp getCgAddress() {
        if (this.hasCgAddress()) {
            Avp rawAvp = this.avpSet.getAvp(846, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 846L);
                logger.error((Object)"Failure while trying to obtain CG-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getChargingRuleBaseName() {
        if (this.hasChargingRuleBaseName()) {
            Avp rawAvp = this.avpSet.getAvp(1004, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1004L);
                logger.error((Object)"Failure while trying to obtain Charging-Rule-Base-Name AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public AddressAvp getGgsnAddress() {
        if (this.hasGgsnAddress()) {
            Avp rawAvp = this.avpSet.getAvp(847, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 847L);
                logger.error((Object)"Failure while trying to obtain GGSN-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public AddressAvp getPdpAddress() {
        if (this.hasPdpAddress()) {
            Avp rawAvp = this.avpSet.getAvp(1227, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1227L);
                logger.error((Object)"Failure while trying to obtain PDP-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public PsFurnishChargingInformation getPsFurnishChargingInformation() {
        if (this.hasPsFurnishChargingInformation()) {
            Avp rawAvp = this.avpSet.getAvp(865, 10415L);
            try {
                return new PsFurnishChargingInformationImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 865L);
                logger.error((Object)"Failure while trying to obtain PS-Furnish-Charging-Information AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public AddressAvp getSgsnAddress() {
        if (this.hasSgsnAddress()) {
            Avp rawAvp = this.avpSet.getAvp(1228, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1228L);
                logger.error((Object)"Failure while trying to obtain SGSN-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppCamelChargingInfo() {
        if (this.hasTgppCamelChargingInfo()) {
            Avp rawAvp = this.avpSet.getAvp(24, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 24L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Camel-Charging-Info  AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppChargingCharacteristics() {
        if (this.hasTgppChargingCharacteristics()) {
            Avp rawAvp = this.avpSet.getAvp(13, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 13L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Charging-Characteristics AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppChargingId() {
        if (this.hasTgppChargingId()) {
            Avp rawAvp = this.avpSet.getAvp(2, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 2L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Charging-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppGgsnMccMnc() {
        if (this.hasTgppGgsnMccMnc()) {
            Avp rawAvp = this.avpSet.getAvp(9, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 9L);
                logger.error((Object)"Failure while trying to obtain 3GPP-GGSN-MCC-MNC AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppGprsNegotiatedQosProfile() {
        if (this.hasTgppGprsNegotiatedQosProfile()) {
            Avp rawAvp = this.avpSet.getAvp(5, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 5L);
                logger.error((Object)"Failure while trying to obtain 3GPP-GPRS-Negotiated-QoS-Profile AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppImsiMccMnc() {
        if (this.hasTgppImsiMccMnc()) {
            Avp rawAvp = this.avpSet.getAvp(8, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 8L);
                logger.error((Object)"Failure while trying to obtain 3GPP-IMSI-MCC-MNC AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppMsTimezone() {
        if (this.hasTgppMsTimezone()) {
            Avp rawAvp = this.avpSet.getAvp(23, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 23L);
                logger.error((Object)"Failure while trying to obtain 3GPP-MS-TimeZone AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppNsapi() {
        if (this.hasTgppNsapi()) {
            Avp rawAvp = this.avpSet.getAvp(10, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 10L);
                logger.error((Object)"Failure while trying to obtain 3GPP-NSAPI AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppPdpType() {
        if (this.hasTgppPdpType()) {
            Avp rawAvp = this.avpSet.getAvp(3, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 3L);
                logger.error((Object)"Failure while trying to obtain 3GPP-PDP-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppRatType() {
        if (this.hasTgppRatType()) {
            Avp rawAvp = this.avpSet.getAvp(21, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 21L);
                logger.error((Object)"Failure while trying to obtain 3GPP-RAT-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppSelectionMode() {
        if (this.hasTgppSelectionMode()) {
            Avp rawAvp = this.avpSet.getAvp(12, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 12L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Selection-Mode AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppSessionStopIndicator() {
        if (this.hasTgppSessionStopIndicator()) {
            Avp rawAvp = this.avpSet.getAvp(11, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 11L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Session-Stop-Indicator AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppSgsnMccMnc() {
        if (this.hasTgppSgsnMccMnc()) {
            Avp rawAvp = this.avpSet.getAvp(18, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 18L);
                logger.error((Object)"Failure while trying to obtain 3GPP-SGSN-MCC-MNC AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppUserLocationInfo() {
        if (this.hasTgppUserLocationInfo()) {
            Avp rawAvp = this.avpSet.getAvp(22, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 22L);
                logger.error((Object)"Failure while trying to obtain 3GPP-User-Location-Info AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasCgAddress() {
        return this.hasAvp(846, 10415L);
    }

    public boolean hasChargingRuleBaseName() {
        return this.hasAvp(1004, 10415L);
    }

    public boolean hasGgsnAddress() {
        return this.hasAvp(847, 10415L);
    }

    public boolean hasPdpAddress() {
        return this.hasAvp(1227, 10415L);
    }

    public boolean hasPsFurnishChargingInformation() {
        return this.hasAvp(865, 10415L);
    }

    public boolean hasSgsnAddress() {
        return this.hasAvp(1228, 10415L);
    }

    public boolean hasTgppCamelChargingInfo() {
        return this.hasAvp(24, 10415L);
    }

    public boolean hasTgppChargingCharacteristics() {
        return this.hasAvp(13, 10415L);
    }

    public boolean hasTgppChargingId() {
        return this.hasAvp(2, 10415L);
    }

    public boolean hasTgppGgsnMccMnc() {
        return this.hasAvp(9, 10415L);
    }

    public boolean hasTgppGprsNegotiatedQosProfile() {
        return this.hasAvp(5, 10415L);
    }

    public boolean hasTgppImsiMccMnc() {
        return this.hasAvp(8, 10415L);
    }

    public boolean hasTgppMsTimezone() {
        return this.hasAvp(23, 10415L);
    }

    public boolean hasTgppNsapi() {
        return this.hasAvp(10, 10415L);
    }

    public boolean hasTgppPdpType() {
        return this.hasAvp(3, 10415L);
    }

    public boolean hasTgppRatType() {
        return this.hasAvp(21, 10415L);
    }

    public boolean hasTgppSelectionMode() {
        return this.hasAvp(12, 10415L);
    }

    public boolean hasTgppSessionStopIndicator() {
        return this.hasAvp(11, 10415L);
    }

    public boolean hasTgppSgsnMccMnc() {
        return this.hasAvp(18, 10415L);
    }

    public boolean hasTgppUserLocationInfo() {
        return this.hasAvp(22, 10415L);
    }

    public void setCgAddress(AddressAvp cgAddress) {
        if (this.hasCgAddress()) {
            throw new IllegalStateException("AVP CG-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(846, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(846, cgAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setChargingRuleBaseName(byte[] chargingRuleBaseName) {
        if (this.hasChargingRuleBaseName()) {
            throw new IllegalStateException("AVP Charging-Rule-Base-Name is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1004, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1004, chargingRuleBaseName, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setGgsnAddress(AddressAvp ggsnAddress) {
        if (this.hasGgsnAddress()) {
            throw new IllegalStateException("AVP GGSN-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(847, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(847, ggsnAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setPdpAddress(AddressAvp pdpAddress) {
        if (this.hasPdpAddress()) {
            throw new IllegalStateException("AVP PDP-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1227, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1227, pdpAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setPsFurnishChargingInformation(PsFurnishChargingInformation psFurnishChargingInformation) {
        if (this.hasPsFurnishChargingInformation()) {
            throw new IllegalStateException("AVP PS-Furnish-Charging-Information is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(865, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(865, psFurnishChargingInformation.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setSgsnAddress(AddressAvp sgsnAddress) {
        if (this.hasSgsnAddress()) {
            throw new IllegalStateException("AVP SGSN-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1228, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1228, sgsnAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppCamelChargingInfo(byte[] tgppCamelChargingInfo) {
        if (this.hasTgppCamelChargingInfo()) {
            throw new IllegalStateException("AVP 3GPP-Camel-Charging-Info is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(24, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(24, tgppCamelChargingInfo, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppChargingCharacteristics(byte[] tgppChargingCharacteristics) {
        if (this.hasTgppChargingCharacteristics()) {
            throw new IllegalStateException("AVP 3GPP-Charging-Characteristics is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(13, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(13, tgppChargingCharacteristics, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppChargingId(byte[] tgppChargingId) {
        if (this.hasTgppChargingId()) {
            throw new IllegalStateException("AVP 3GPP-Charging-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(2, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(2, tgppChargingId, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppGgsnMccMnc(byte[] tgppGgsnMccMnc) {
        if (this.hasTgppGgsnMccMnc()) {
            throw new IllegalStateException("AVP 3GPP-GGSN-MCC-MNC is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(9, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(9, tgppGgsnMccMnc, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppGprsNegotiatedQosProfile(byte[] tgppGprsNegotiatedQosProfile) {
        if (this.hasTgppGprsNegotiatedQosProfile()) {
            throw new IllegalStateException("AVP 3GPP-GPRS-Negotiated-QoS-Profile is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(5, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(5, tgppGprsNegotiatedQosProfile, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppImsiMccMnc(byte[] tgppImsiMccMnc) {
        if (this.hasTgppImsiMccMnc()) {
            throw new IllegalStateException("AVP 3GPP-IMSI-MCC-MNC is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(8, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(8, tgppImsiMccMnc, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppMsTimezone(byte[] tgppMsTimezone) {
        if (this.hasTgppMsTimezone()) {
            throw new IllegalStateException("AVP 3GPP-MS-TimeZone is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(23, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(23, tgppMsTimezone, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppNsapi(byte[] tgppNsapi) {
        if (this.hasTgppNsapi()) {
            throw new IllegalStateException("AVP 3GPP-NSAPI is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(10, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(10, tgppNsapi, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppPdpType(byte[] tgppPdpType) {
        if (this.hasTgppPdpType()) {
            throw new IllegalStateException("AVP 3GPP-PDP-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(3, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(3, tgppPdpType, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppRatType(byte[] tgppRatType) {
        if (this.hasTgppRatType()) {
            throw new IllegalStateException("AVP 3GPP-RAT-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(21, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(21, tgppRatType, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppSelectionMode(byte[] tgppSelectionMode) {
        if (this.hasTgppSelectionMode()) {
            throw new IllegalStateException("AVP 3GPP-Selection-Mode is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(12, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(12, tgppSelectionMode, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppSessionStopIndicator(byte[] tgppSessionStopIndicator) {
        if (this.hasTgppSessionStopIndicator()) {
            throw new IllegalStateException("AVP 3GPP-Session-Stop-Indicator is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(11, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(11, tgppSessionStopIndicator, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppSgsnMccMnc(byte[] tgppSgsnMccMnc) {
        if (this.hasTgppSgsnMccMnc()) {
            throw new IllegalStateException("AVP 3GPP-SGSN-MCC-MNC is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(18, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(18, tgppSgsnMccMnc, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTgppUserLocationInfo(byte[] tgppUserLocationInfo) {
        if (this.hasTgppUserLocationInfo()) {
            throw new IllegalStateException("AVP 3GPP-User-Location-Info is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(22, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(22, tgppUserLocationInfo, 10415L, mandatoryAvp, protectedAvp);
    }
}

