/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.MediaInitiatorFlag;
import net.java.slee.resource.diameter.ro.events.avp.SdpMediaComponent;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class SdpMediaComponentImpl
extends GroupedAvpImpl
implements SdpMediaComponent {
    private static final Logger logger = Logger.getLogger(SdpMediaComponentImpl.class);

    public SdpMediaComponentImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getAuthorizedQos() {
        if (this.hasAuthorizedQos()) {
            Avp rawAvp = this.avpSet.getAvp(849, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 849L);
                logger.error((Object)"Failure while trying to obtain Authorized-QOS AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public MediaInitiatorFlag getMediaInitiatorFlag() {
        if (this.hasMediaInitiatorFlag()) {
            Avp rawAvp = this.avpSet.getAvp(882, 10415L);
            try {
                return MediaInitiatorFlag.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 882L);
                logger.error((Object)"Failure while trying to obtain Media-Initiator-Flag AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String[] getSdpMediaDescriptions() {
        String[] sdpMediaDescriptions = null;
        AvpSet rawAvps = this.avpSet.getAvps(845, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            sdpMediaDescriptions = new String[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    sdpMediaDescriptions[i] = rawAvps.getAvpByIndex(i).getUTF8String();
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 845L);
                    logger.error((Object)("Failure while trying to obtain SDP-Media-Descriptions AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return sdpMediaDescriptions;
    }

    public String getSdpMediaName() {
        if (this.hasSdpMediaName()) {
            Avp rawAvp = this.avpSet.getAvp(844, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 844L);
                logger.error((Object)"Failure while trying to obtain SDP-Media-Name AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppChargingId() {
        if (this.hasSdpMediaName()) {
            Avp rawAvp = this.avpSet.getAvp(2, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 2L);
                logger.error((Object)"Failure while trying to obtain 3GPP-Charging-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasAuthorizedQos() {
        return this.hasAvp(849, 10415L);
    }

    public boolean hasMediaInitiatorFlag() {
        return this.hasAvp(882, 10415L);
    }

    public boolean hasSdpMediaName() {
        return this.hasAvp(844, 10415L);
    }

    public boolean hasTgppChargingId() {
        return this.hasAvp(2, 10415L);
    }

    public void setAuthorizedQos(String authorizedQos) {
        if (this.hasAuthorizedQos()) {
            throw new IllegalStateException("AVP Authorized-QOS is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(849, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(849, authorizedQos, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setMediaInitiatorFlag(MediaInitiatorFlag mediaInitiatorFlag) {
        if (this.hasMediaInitiatorFlag()) {
            throw new IllegalStateException("AVP Media-Initiator-Flag is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(882, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(882, mediaInitiatorFlag.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setSdpMediaDescription(String sdpMediaDescription) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(845, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(845, sdpMediaDescription, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setSdpMediaDescriptions(String[] sdpMediaDescriptions) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(845, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (String sdpMediaDescription : sdpMediaDescriptions) {
            this.avpSet.addAvp(845, sdpMediaDescription, 10415L, mandatoryAvp, protectedAvp, false);
        }
    }

    public void setSdpMediaName(String sdpMediaName) {
        if (this.hasSdpMediaName()) {
            throw new IllegalStateException("AVP SDP-Media-Name is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(844, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(844, sdpMediaName, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setTgppChargingId(byte[] tgppChargingId) {
        if (this.hasTgppChargingId()) {
            throw new IllegalStateException("AVP 3GPP-Charging-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(2, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(2, tgppChargingId, 10415L, mandatoryAvp, protectedAvp);
    }
}

