/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import java.util.Date;
import net.java.slee.resource.diameter.ro.events.avp.TimeStamps;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.ApplicationServerInformationImpl;

public class TimeStampsImpl
extends GroupedAvpImpl
implements TimeStamps {
    private static final Logger logger = Logger.getLogger(ApplicationServerInformationImpl.class);

    public TimeStampsImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public Date getSipRequestTimestamp() {
        if (this.hasSipRequestTimestamp()) {
            Avp rawAvp = this.avpSet.getAvp(834, 10415L);
            try {
                return rawAvp.getTime();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 834L);
                logger.error((Object)"Failure while trying to obtain SIP-Request-Timestamp AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public Date getSipResponseTimestamp() {
        if (this.hasSipResponseTimestamp()) {
            Avp rawAvp = this.avpSet.getAvp(835, 10415L);
            try {
                return rawAvp.getTime();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 835L);
                logger.error((Object)"Failure while trying to obtain SIP-Response-Timestamp AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasSipRequestTimestamp() {
        return this.hasAvp(834, 10415L);
    }

    public boolean hasSipResponseTimestamp() {
        return this.hasAvp(835, 10415L);
    }

    public void setSipRequestTimestamp(Date sipRequestTimestamp) {
        if (this.hasSipRequestTimestamp()) {
            throw new IllegalStateException("AVP SIP-Request-Timestamp is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(834, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(834, sipRequestTimestamp, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setSipResponseTimestamp(Date sipResponseTimestamp) {
        if (this.hasSipResponseTimestamp()) {
            throw new IllegalStateException("AVP SIP-Response-Timestamp is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(835, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(835, sipResponseTimestamp, 10415L, mandatoryAvp, protectedAvp);
    }
}

