/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.TrunkGroupId;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class TrunkGroupIdImpl
extends GroupedAvpImpl
implements TrunkGroupId {
    private static final Logger logger = Logger.getLogger(TrunkGroupIdImpl.class);

    public TrunkGroupIdImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getIncomingTrunkGroupId() {
        if (this.hasIncomingTrunkGroupId()) {
            Avp rawAvp = this.avpSet.getAvp(852, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 852L);
                logger.error((Object)"Failure while trying to obtain Incoming-Trunk-Group-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getOutgoingTrunkGroupId() {
        if (this.hasOutgoingTrunkGroupId()) {
            Avp rawAvp = this.avpSet.getAvp(853, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 853L);
                logger.error((Object)"Failure while trying to obtain Outgoing-Trunk-Group-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasIncomingTrunkGroupId() {
        return this.hasAvp(853, 10415L);
    }

    public boolean hasOutgoingTrunkGroupId() {
        return this.hasAvp(853, 10415L);
    }

    public void setIncomingTrunkGroupId(String incomingTrunkGroupId) {
        if (this.hasIncomingTrunkGroupId()) {
            throw new IllegalStateException("AVP Incoming-Trunk-Group-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(852, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(852, incomingTrunkGroupId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setOutgoingTrunkGroupId(String outgoingTrunkGroupId) {
        if (this.hasOutgoingTrunkGroupId()) {
            throw new IllegalStateException("AVP Outgoing-Trunk-Group-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(853, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(853, outgoingTrunkGroupId, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

