/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.base.events.avp.AddressAvp;
import net.java.slee.resource.diameter.ro.events.avp.WlanInformation;
import net.java.slee.resource.diameter.ro.events.avp.WlanRadioContainer;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.AddressAvpImpl;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.WlanRadioContainerImpl;

public class WlanInformationImpl
extends GroupedAvpImpl
implements WlanInformation {
    private static final Logger logger = Logger.getLogger(WlanInformationImpl.class);

    public WlanInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public AddressAvp getPdgAddress() {
        if (this.hasPdgAddress()) {
            Avp rawAvp = this.avpSet.getAvp(895, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 895L);
                logger.error((Object)"Failure while trying to obtain PDG-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public long getPdgChargingId() {
        if (this.hasPdgChargingId()) {
            Avp rawAvp = this.avpSet.getAvp(896, 10415L);
            try {
                return rawAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 896L);
                logger.error((Object)"Failure while trying to obtain PDG-Address AVP.", (Throwable)e);
            }
        }
        return -1L;
    }

    public AddressAvp getWagAddress() {
        if (this.hasWagAddress()) {
            Avp rawAvp = this.avpSet.getAvp(890, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 890L);
                logger.error((Object)"Failure while trying to obtain WAG-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getWagPlmnId() {
        if (this.hasWagPlmnId()) {
            Avp rawAvp = this.avpSet.getAvp(891, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 891L);
                logger.error((Object)"Failure while trying to obtain WAG-PLMN-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public WlanRadioContainer getWlanRadioContainer() {
        if (this.hasWlanRadioContainer()) {
            Avp rawAvp = this.avpSet.getAvp(892, 10415L);
            try {
                return new WlanRadioContainerImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 892L);
                logger.error((Object)"Failure while trying to obtain WLAN-Radio-Container AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getWlanSessionId() {
        if (this.hasWlanSessionId()) {
            Avp rawAvp = this.avpSet.getAvp(8861, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 8861L);
                logger.error((Object)"Failure while trying to obtain WLAN-Session-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public AddressAvp getWlanUeLocalIpaddress() {
        if (this.hasWlanUeLocalIpaddress()) {
            Avp rawAvp = this.avpSet.getAvp(894, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 894L);
                logger.error((Object)"Failure while trying to obtain WLAN-UE-Local-IPAddress AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasPdgAddress() {
        return this.hasAvp(895, 10415L);
    }

    public boolean hasPdgChargingId() {
        return this.hasAvp(896, 10415L);
    }

    public boolean hasWagAddress() {
        return this.hasAvp(890, 10415L);
    }

    public boolean hasWagPlmnId() {
        return this.hasAvp(891, 10415L);
    }

    public boolean hasWlanRadioContainer() {
        return this.hasAvp(892, 10415L);
    }

    public boolean hasWlanSessionId() {
        return this.hasAvp(8861, 10415L);
    }

    public boolean hasWlanUeLocalIpaddress() {
        return this.hasAvp(894, 10415L);
    }

    public void setPdgAddress(AddressAvp pdgAddress) {
        if (this.hasPdgAddress()) {
            throw new IllegalStateException("AVP PDG-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(895, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(895, pdgAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setPdgChargingId(long pdgChargingId) {
        if (this.hasPdgChargingId()) {
            throw new IllegalStateException("AVP PDG-Charging-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(896, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(896, pdgChargingId, 10415L, mandatoryAvp, protectedAvp, true);
    }

    public void setWagAddress(AddressAvp wagAddress) {
        if (this.hasWagAddress()) {
            throw new IllegalStateException("AVP WAG-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(890, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(890, wagAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setWagPlmnId(byte[] wagPlmnId) {
        if (this.hasWagPlmnId()) {
            throw new IllegalStateException("AVP WAG-PLMN-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(891, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(891, wagPlmnId, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setWlanRadioContainer(WlanRadioContainer wlanRadioContainer) {
        if (this.hasWlanRadioContainer()) {
            throw new IllegalStateException("AVP WLAN-Radio-Container is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(892, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(892, wlanRadioContainer.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setWlanSessionId(String wlanSessionId) {
        if (this.hasWlanSessionId()) {
            throw new IllegalStateException("AVP WLAN-Session-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(8861, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(8861, wlanSessionId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setWlanUeLocalIpaddress(AddressAvp wlanUeLocalIpaddress) {
        if (this.hasWlanUeLocalIpaddress()) {
            throw new IllegalStateException("AVP WLAN-UE-Local-IPAddress is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(894, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(894, wlanUeLocalIpaddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }
}

