/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.LocationType;
import net.java.slee.resource.diameter.ro.events.avp.WlanRadioContainer;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.LocationTypeImpl;

public class WlanRadioContainerImpl
extends GroupedAvpImpl
implements WlanRadioContainer {
    private static final Logger logger = Logger.getLogger(WlanRadioContainerImpl.class);

    public WlanRadioContainerImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public LocationType getLocationType() {
        if (this.hasLocationType()) {
            Avp rawAvp = this.avpSet.getAvp(1244, 10415L);
            try {
                return new LocationTypeImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1244L);
                logger.error((Object)"Failure while trying to obtain Location-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public long getWlanTechnology() {
        if (this.hasWlanTechnology()) {
            Avp rawAvp = this.avpSet.getAvp(893, 10415L);
            try {
                return rawAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 893L);
                logger.error((Object)"Failure while trying to obtain WLAN-Technology AVP.", (Throwable)e);
            }
        }
        return -1L;
    }

    public boolean hasLocationType() {
        return this.hasAvp(1244, 10415L);
    }

    public boolean hasWlanTechnology() {
        return this.hasAvp(893, 10415L);
    }

    public void setLocationType(LocationType locationType) {
        if (this.hasLocationType()) {
            throw new IllegalStateException("AVP Location-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1244, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1244, locationType.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setWlanTechnology(long wlanTechnology) {
        if (this.hasWlanTechnology()) {
            throw new IllegalStateException("AVP WLAN-Technology is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(893, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(893, wlanTechnology, 10415L, mandatoryAvp, protectedAvp, true);
    }
}

