/*
 * Decompiled with CFR 0.152.
 */
package net.java.slee.resource.diameter.ro.events.avp;

import java.io.Serializable;
import java.io.StreamCorruptedException;
import net.java.slee.resource.diameter.base.events.avp.Enumerated;

public class AddressType
implements Enumerated,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int _ALPHANUMERIC_SHORTCODE = 5;
    public static final int _E_MAIL_ADDRESS = 0;
    public static final int _IPV4_ADDRESS = 2;
    public static final int _IPV6_ADDRESS = 3;
    public static final int _MSISDN = 1;
    public static final int _NUMERIC_SHORTCODE = 4;
    public static final int _OTHER = 6;
    public static final AddressType ALPHANUMERIC_SHORTCODE = new AddressType(5);
    public static final AddressType E_MAIL_ADDRESS = new AddressType(0);
    public static final AddressType IPV4_ADDRESS = new AddressType(2);
    public static final AddressType IPV6_ADDRESS = new AddressType(3);
    public static final AddressType MSISDN = new AddressType(1);
    public static final AddressType NUMERIC_SHORTCODE = new AddressType(4);
    public static final AddressType OTHER = new AddressType(6);
    private int value = 0;

    private AddressType(int v) {
        this.value = v;
    }

    public static AddressType fromInt(int type) {
        switch (type) {
            case 5: {
                return ALPHANUMERIC_SHORTCODE;
            }
            case 0: {
                return E_MAIL_ADDRESS;
            }
            case 2: {
                return IPV4_ADDRESS;
            }
            case 3: {
                return IPV6_ADDRESS;
            }
            case 1: {
                return MSISDN;
            }
            case 4: {
                return NUMERIC_SHORTCODE;
            }
            case 6: {
                return OTHER;
            }
        }
        throw new IllegalArgumentException("Invalid DisconnectCause value: " + type);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 5: {
                return "ALPHANUMERIC_SHORTCODE";
            }
            case 0: {
                return "E_MAIL_ADDRESS";
            }
            case 2: {
                return "IPV4_ADDRESS";
            }
            case 3: {
                return "IPV6_ADDRESS";
            }
            case 1: {
                return "MSISDN";
            }
            case 4: {
                return "NUMERIC_SHORTCODE";
            }
            case 6: {
                return "OTHER";
            }
        }
        return "<Invalid Value>";
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return AddressType.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found: " + this.value);
        }
    }
}

