/*
 * Decompiled with CFR 0.152.
 */
package net.java.slee.resource.diameter.ro.events.avp;

import java.io.Serializable;
import java.io.StreamCorruptedException;
import net.java.slee.resource.diameter.base.events.avp.Enumerated;

public class NodeFunctionality
implements Enumerated,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int _S_CSCF = 0;
    public static final int _P_CSCF = 1;
    public static final int _I_CSCF = 2;
    public static final int _MRFC = 3;
    public static final int _MGCF = 4;
    public static final int _BGCF = 5;
    public static final int _AS = 6;
    public static final NodeFunctionality AS = new NodeFunctionality(6);
    public static final NodeFunctionality BGCF = new NodeFunctionality(5);
    public static final NodeFunctionality I_CSCF = new NodeFunctionality(2);
    public static final NodeFunctionality MGCF = new NodeFunctionality(4);
    public static final NodeFunctionality MRFC = new NodeFunctionality(3);
    public static final NodeFunctionality P_CSCF = new NodeFunctionality(1);
    public static final NodeFunctionality S_CSCF = new NodeFunctionality(0);
    private int value = 0;

    private NodeFunctionality(int v) {
        this.value = v;
    }

    public static NodeFunctionality fromInt(int type) {
        switch (type) {
            case 6: {
                return AS;
            }
            case 5: {
                return BGCF;
            }
            case 2: {
                return I_CSCF;
            }
            case 4: {
                return MGCF;
            }
            case 3: {
                return MRFC;
            }
            case 1: {
                return P_CSCF;
            }
            case 0: {
                return S_CSCF;
            }
        }
        throw new IllegalArgumentException("Invalid NodeFunctionality value: " + type);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 6: {
                return "AS";
            }
            case 5: {
                return "BGCF";
            }
            case 2: {
                return "I_CSCF";
            }
            case 4: {
                return "MGCF";
            }
            case 3: {
                return "MRFC";
            }
            case 1: {
                return "P_CSCF";
            }
            case 0: {
                return "S_CSCF";
            }
        }
        return "<Invalid Value>";
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return NodeFunctionality.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found: " + this.value);
        }
    }
}

