/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rx;

import java.io.IOException;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rx.RxServerSessionActivity;
import net.java.slee.resource.diameter.rx.RxSessionState;
import net.java.slee.resource.diameter.rx.events.AAAnswer;
import net.java.slee.resource.diameter.rx.events.AARequest;
import net.java.slee.resource.diameter.rx.events.AbortSessionRequest;
import net.java.slee.resource.diameter.rx.events.ReAuthRequest;
import net.java.slee.resource.diameter.rx.events.SessionTerminationAnswer;
import net.java.slee.resource.diameter.rx.events.SessionTerminationRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.rx.ServerRxSession;
import org.jdiameter.api.rx.events.RxAAAnswer;
import org.jdiameter.api.rx.events.RxAbortSessionRequest;
import org.jdiameter.api.rx.events.RxReAuthRequest;
import org.jdiameter.api.rx.events.RxSessionTermAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.rx.ServerRxSessionState;
import org.jdiameter.common.impl.app.rx.RxAAAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxAbortSessionRequestImpl;
import org.jdiameter.common.impl.app.rx.RxReAuthRequestImpl;
import org.jdiameter.common.impl.app.rx.RxSessionTermAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.rx.RxMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.rx.RxSessionActivityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RxServerSessionActivityImpl
extends RxSessionActivityImpl
implements RxServerSessionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 5230054776594429948L;
    private static Logger logger = Logger.getLogger(RxServerSessionActivityImpl.class);
    protected transient ServerRxSession session = null;
    protected transient AARequest lastAARequest = null;
    protected transient SessionTerminationRequest lastSessionTermRequest = null;

    public RxServerSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ServerRxSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)session), destinationRealm, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)this.session.getSessions().get(0));
        super.setRxMessageFactory(new RxMessageFactoryImpl(messageFactory, session.getSessionId(), stack));
    }

    public AAAnswer createAAAnswer() {
        if (this.lastAARequest == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No request received, cant create answer.");
            }
            return null;
        }
        AAAnswer answer = ((RxMessageFactoryImpl)this.getRxMessageFactory()).createAAAnswer(this.lastAARequest);
        return answer;
    }

    public SessionTerminationAnswer createSessionTermAnswer() {
        if (this.lastSessionTermRequest == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No request received, cant create answer.");
            }
            return null;
        }
        SessionTerminationAnswer answer = null;
        answer = ((RxMessageFactoryImpl)this.getRxMessageFactory()).createSessionTerminationAnswer(this.lastSessionTermRequest);
        return answer;
    }

    public void sendAAAnswer(AAAnswer aaa) throws IOException {
        this.fetchCurrentState(aaa);
        DiameterMessageImpl msg = (DiameterMessageImpl)aaa;
        try {
            this.session.sendAAAnswer((RxAAAnswer)new RxAAAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException anae = new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            throw new IOException("Failed to send message.", e);
        }
    }

    public void sendSessionTermAnswer(SessionTerminationAnswer sta) throws IOException {
        this.fetchCurrentState(sta);
        DiameterMessageImpl msg = (DiameterMessageImpl)sta;
        try {
            this.session.sendSessionTermAnswer((RxSessionTermAnswer)new RxSessionTermAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException anae = new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            throw new IOException("Failed to send message.", e);
        }
    }

    public void sendReAuthRequest(ReAuthRequest rar) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)rar;
        try {
            this.session.sendReAuthRequest((RxReAuthRequest)new RxReAuthRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException anae = new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            throw new IOException("Failed to send message.", e);
        }
    }

    public void sendAbortSessionRequest(AbortSessionRequest asr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)asr;
        try {
            this.session.sendAbortSessionRequest((RxAbortSessionRequest)new RxAbortSessionRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException anae = new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            throw new IOException("Failed to send message.", e);
        }
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("AA Server FSM State Changed: " + oldState + " => " + newState));
        }
        ServerRxSessionState s = (ServerRxSessionState)newState;
        switch (s) {
            case OPEN: {
                break;
            }
            case IDLE: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
                break;
            }
            default: {
                logger.error((Object)("Unexpected state in AA Server FSM: " + s));
            }
        }
    }

    public void fetchCurrentState(AARequest aar) {
        this.lastAARequest = aar;
    }

    public void fetchCurrentState(SessionTerminationRequest str) {
        this.lastSessionTermRequest = str;
    }

    public void fetchCurrentState(AAAnswer aaa) {
    }

    public void fetchCurrentState(SessionTerminationAnswer sta) {
    }

    public ServerRxSession getSession() {
        return this.session;
    }

    public void setSession(ServerRxSession session2) {
        this.session = session2;
        this.session.addStateChangeNotification((StateChangeListener)this);
    }

    public RxSessionState getState() {
        ServerRxSessionState sessionState = (ServerRxSessionState)this.session.getState(ServerRxSessionState.class);
        switch (sessionState) {
            case OPEN: {
                return RxSessionState.OPEN;
            }
            case IDLE: {
                return RxSessionState.IDLE;
            }
        }
        logger.error((Object)("Unexpected state in AA Server FSM: " + sessionState));
        return null;
    }

    public String toString() {
        return super.toString() + " -- Event[ " + (this.lastAARequest != null) + " ] Session[ " + this.session + " ] State[ " + this.getState() + " ]";
    }

    public void endActivity() {
        this.session.release();
        super.endActivity();
    }
}

