/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.transaction.SleeTransactionManager;
import net.java.slee.resource.diameter.Validator;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rx.RxAvpFactory;
import net.java.slee.resource.diameter.rx.RxClientSessionActivity;
import net.java.slee.resource.diameter.rx.RxMessageFactory;
import net.java.slee.resource.diameter.rx.RxProvider;
import net.java.slee.resource.diameter.rx.RxServerSessionActivity;
import net.java.slee.resource.diameter.rx.events.AAAnswer;
import net.java.slee.resource.diameter.rx.events.AARequest;
import net.java.slee.resource.diameter.rx.events.AbortSessionAnswer;
import net.java.slee.resource.diameter.rx.events.AbortSessionRequest;
import net.java.slee.resource.diameter.rx.events.ReAuthAnswer;
import net.java.slee.resource.diameter.rx.events.ReAuthRequest;
import net.java.slee.resource.diameter.rx.events.SessionTerminationAnswer;
import net.java.slee.resource.diameter.rx.events.SessionTerminationRequest;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.rx.ClientRxSession;
import org.jdiameter.api.rx.ServerRxSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.server.impl.app.rx.ServerRxSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.AbstractClusteredDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.ValidatorImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.rx.EventIDCache;
import org.mobicents.slee.resource.diameter.rx.RxAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.rx.RxClientSessionActivityImpl;
import org.mobicents.slee.resource.diameter.rx.RxMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.rx.RxServerSessionActivityImpl;
import org.mobicents.slee.resource.diameter.rx.events.AAAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.AARequestImpl;
import org.mobicents.slee.resource.diameter.rx.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.AbortSessionRequestImpl;
import org.mobicents.slee.resource.diameter.rx.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.ReAuthRequestImpl;
import org.mobicents.slee.resource.diameter.rx.events.SessionTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.SessionTerminationRequestImpl;
import org.mobicents.slee.resource.diameter.rx.handlers.RxSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiameterRxResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface,
FaultTolerantResourceAdaptor<String, DiameterActivity> {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private static final int DEFAULT_ACTIVITY_FLAGS = 2;
    private static final int MARSHALABLE_ACTIVITY_FLAGS = ActivityFlags.setSleeMayMarshal((int)2);
    private static final int EVENT_FLAGS = DiameterRxResourceAdaptor.getEventFlags();
    public final EventIDCache eventIdCache = new EventIDCache();
    protected DiameterBaseMarshaler marshaler = new DiameterBaseMarshaler();
    protected int defaultDirectDebitingFailureHandling;
    protected int defaultCreditControlFailureHandling;
    protected long defaultValidityTime = 30L;
    protected long defaultTxTimerValue = 10L;
    protected long activityRemoveDelay = 30000L;
    protected RxSessionFactory rxSessionFactory;
    protected RxAvpFactory rxAvpFactory;
    protected RxMessageFactory rxMessageFactory;
    protected transient RxProviderImpl raProvider;
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private List<ApplicationId> authApplicationIds;
    private ResourceAdaptorContext raContext;
    private FaultTolerantResourceAdaptorContext<String, DiameterActivity> ftRAContext;
    private transient SleeEndpoint sleeEndpoint;
    private Tracer tracer;
    private Stack stack;
    private ObjectName diameterMultiplexerObjectName;
    private DiameterStackMultiplexerMBean diameterMux;
    private DiameterAvpFactory baseAvpFactory;
    private DiameterMessageFactoryImpl baseMessageFactory;
    private SessionFactory sessionFactory;
    private transient EventLookupFacility eventLookup;
    private transient DiameterActivityManagement activities;

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterRxResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
        this.raProvider = new RxProviderImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<String, DiameterActivity> ctx) {
        this.ftRAContext = ctx;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRAContext = null;
    }

    public void dataRemoved(String arg0) {
        this.activities.remove(this.getActivityHandle(arg0));
    }

    public void failOver(String arg0) {
        throw new UnsupportedOperationException();
    }

    public ApplicationId[] getSupportedApplications() {
        return null;
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter Rx RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.baseMessageFactory = new DiameterMessageFactoryImpl(this.stack);
            this.rxAvpFactory = new RxAvpFactoryImpl(this.baseAvpFactory);
            this.rxMessageFactory = new RxMessageFactoryImpl((DiameterMessageFactory)this.baseMessageFactory, null, this.stack);
            ApplicationId firstAppId = this.authApplicationIds.get(0);
            ((RxMessageFactoryImpl)this.rxMessageFactory).setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
            this.sessionFactory = this.stack.getSessionFactory();
            this.rxSessionFactory = new RxSessionFactory(this, this.sessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerRxSession.class, (IAppSessionFactory)this.rxSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientRxSession.class, (IAppSessionFactory)this.rxSessionFactory);
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter Rx RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister Rx RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: raStopping completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: raInactive.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: raInactive completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            String trimmedString = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = trimmedString.split(",");
            this.authApplicationIds = new ArrayList<ApplicationId>(appIdsStrings.length);
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                this.authApplicationIds.add(ApplicationId.createByAuthAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        this.tracer.info("Diameter Rx RA :: queryLiveness :: handle[" + handle + "].");
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: getActivity :: handle[" + handle + "].");
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAfterEventDelivery(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        DiameterActivityImpl activity = (DiameterActivityImpl)this.getActivity(handle);
        if (activity != null) {
            DiameterActivityImpl diameterActivityImpl = activity;
            synchronized (diameterActivityImpl) {
                if (activity.isTerminateAfterProcessing()) {
                    activity.endActivity();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        this.tracer.info("Diameter Rx RA :: activityEnded :: handle[" + handle + ".");
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (handle instanceof DiameterActivityHandle) {
            this.endActivity((DiameterActivityHandle)handle);
        }
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                Object o = this.getActivity(handle);
                if (o == null) {
                    throw new IllegalStateException("No activity for handle: " + handle);
                }
                if (o instanceof RxServerSessionActivityImpl && event instanceof AARequest) {
                    ((RxServerSessionActivityImpl)((Object)o)).fetchCurrentState((AARequest)event);
                }
                if (o instanceof RxServerSessionActivityImpl && event instanceof SessionTerminationRequest) {
                    ((RxServerSessionActivityImpl)((Object)o)).fetchCurrentState((SessionTerminationRequest)event);
                }
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    public void endActivity(DiameterActivityHandle arg0) {
        this.sleeEndpoint.endActivity((ActivityHandle)arg0);
    }

    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        this.activities.startActivityRemoveTimer(handle);
    }

    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        this.activities.stopActivityRemoveTimer(handle);
    }

    public void update(DiameterActivityHandle arg0, DiameterActivity arg1) {
        this.activities.update(arg0, arg1);
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 265: {
                return isRequest ? new AARequestImpl(message) : new AAAnswerImpl(message);
            }
            case 274: {
                return isRequest ? new AbortSessionRequestImpl(message) : new AbortSessionAnswerImpl(message);
            }
            case 275: {
                return isRequest ? new SessionTerminationRequestImpl(message) : new SessionTerminationAnswerImpl(message);
            }
            case 258: {
                return isRequest ? new ReAuthRequestImpl(message) : new ReAuthAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    private void addActivity(DiameterActivity ac, boolean suspended) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            if (suspended) {
                this.sleeEndpoint.startActivitySuspended((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            }
            activity.setSessionListener((Object)this);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.authApplicationIds.toArray(new ApplicationId[this.authApplicationIds.size()]));
        this.stack = this.diameterMux.getStack();
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        DiameterRxResourceAdaptor lst = this;
        if (this.ftRAContext.isLocal()) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in LOCAL mode.");
            }
            this.activities = new LocalDiameterActivityManagement(this.raContext, this.activityRemoveDelay);
        } else {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in CLUSTER mode.");
            }
            ReplicatedData clusteredData = this.ftRAContext.getReplicateData(true);
            this.activities = new ClusteredDiameterActivityManagementImpl(this.ftRAContext, this.activityRemoveDelay, this.raContext.getTracer(""), this.stack, this.raContext.getSleeTransactionManager(), (ReplicatedData<String, DiameterActivity>)clusteredData, lst);
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: Got Request. Command-Code[" + request.getCommandCode() + "]");
        }
        if (request.getCommandCode() == 265) {
            try {
                DiameterActivity activity = this.raProvider.createActivity((Message)request);
                if (activity == null) {
                    this.tracer.severe("Diameter Rx RA :: Failed to create session, Command-Code: " + request.getCommandCode() + ", Session-Id: " + request.getSessionId());
                } else if (activity instanceof RxServerSessionActivity) {
                    RxServerSessionActivityImpl session = (RxServerSessionActivityImpl)activity;
                    ((ServerRxSessionImpl)session.getSession()).processRequest(request);
                }
            }
            catch (CreateActivityException e) {
                this.tracer.severe("Failure trying to create Rx Activity.", (Throwable)e);
            }
            return null;
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: Received unexpected Request. Either its not CCR or session should exist to handle this, Command-Code: " + request.getCommandCode() + ", Session-Id: " + request.getSessionId());
        }
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rx RA :: receivedSuccessMessage :: Request[" + request + "], Answer[" + answer + "].");
        }
        this.tracer.warning("Resource Adaptor should not receive this (receivedSuccessMessage), a session should exist to handle it.");
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + answer.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rx RA :: timeoutExpired :: Request[" + request + "].");
        }
        this.tracer.warning("Resource Adaptor should not receive this (timeoutExpired), a session should exist to handle it.");
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(request.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public void sessionCreated(ClientRxSession rxClientSession) {
        if (this.getActivity((ActivityHandle)this.getActivityHandle(((Session)rxClientSession.getSessions().get(0)).getSessionId())) != null) {
            this.tracer.warning("Activity found for created Rx Client Session. Shouldn't exist. Aborting.");
            return;
        }
        RxClientSessionActivityImpl activity = new RxClientSessionActivityImpl(this.rxMessageFactory, this.rxAvpFactory, rxClientSession, null, null, this.stack);
        activity.setSessionListener(this);
        this.addActivity((DiameterActivity)activity, false);
    }

    public void sessionCreated(ServerRxSession rxServerSession) {
        if (this.getActivity((ActivityHandle)this.getActivityHandle(((Session)rxServerSession.getSessions().get(0)).getSessionId())) != null) {
            this.tracer.warning("Activity found for created Rx Server Session. Shouldn't exist. Aborting.");
            return;
        }
        RxServerSessionActivityImpl activity = new RxServerSessionActivityImpl(this.rxMessageFactory, this.rxAvpFactory, rxServerSession, null, null, this.stack);
        activity.setSessionListener(this);
        this.addActivity((DiameterActivity)activity, false);
    }

    public boolean sessionExists(String sessionId) {
        return this.activities.containsKey(this.getActivityHandle(sessionId));
    }

    public void sessionDestroyed(String sessionId, Object appSession) {
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            this.tracer.severe("Failure Ending Activity with Session-Id[" + sessionId + "]", (Throwable)e);
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                this.tracer.severe("Failure getting peer list.", (Throwable)e);
            }
        }
        return new DiameterIdentity[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusteredDiameterActivityManagementImpl
    extends AbstractClusteredDiameterActivityManagement {
        private final DiameterRAInterface lst;

        public ClusteredDiameterActivityManagementImpl(FaultTolerantResourceAdaptorContext ftRAContext, long delay, Tracer tracer, Stack diameterStack, SleeTransactionManager sleeTxManager, ReplicatedData<String, DiameterActivity> replicatedData, DiameterRAInterface lst) {
            super(ftRAContext, delay, tracer, diameterStack, sleeTxManager, replicatedData);
            this.lst = lst;
        }

        protected void performBeforeReturn(DiameterActivityImpl activity) {
            block5: {
                try {
                    Session session = null;
                    if (activity.getClass().equals(DiameterActivityImpl.class)) {
                        session = this.diameterStack.getSessionFactory().getNewSession(activity.getSessionId());
                        this.performBeforeReturnOnBase(activity, session);
                        return;
                    }
                    if (activity instanceof RxClientSessionActivity) {
                        RxClientSessionActivityImpl acc = (RxClientSessionActivityImpl)activity;
                        ClientRxSession appSession = (ClientRxSession)this.diameterStack.getSession(activity.getSessionId(), ClientRxSession.class);
                        session = (Session)appSession.getSessions().get(0);
                        this.performBeforeReturnOnBase(activity, session);
                        this.performBeforeReturnRx(acc, session);
                        this.performBeforeReturnCC(acc);
                        acc.setSession(appSession);
                        break block5;
                    }
                    if (activity instanceof RxServerSessionActivity) {
                        RxServerSessionActivityImpl acc = (RxServerSessionActivityImpl)activity;
                        ServerRxSession appSession = (ServerRxSession)this.diameterStack.getSession(activity.getSessionId(), ServerRxSession.class);
                        session = (Session)appSession.getSessions().get(0);
                        this.performBeforeReturnOnBase(activity, session);
                        this.performBeforeReturnRx(acc, session);
                        this.performBeforeReturnCC(acc);
                        acc.setSession(appSession);
                        break block5;
                    }
                    throw new IllegalArgumentException("Unknown activity type: " + activity);
                }
                catch (Exception e) {
                    throw new DiameterException((Throwable)e);
                }
            }
        }

        private void performBeforeReturnCC(RxServerSessionActivityImpl acc) {
        }

        private void performBeforeReturnCC(RxClientSessionActivityImpl acc) {
        }

        private void performBeforeReturnRx(RxServerSessionActivityImpl acc, Session session) {
            RxMessageFactoryImpl messageFactory = new RxMessageFactoryImpl((DiameterMessageFactory)DiameterRxResourceAdaptor.this.baseMessageFactory, session.getSessionId(), DiameterRxResourceAdaptor.this.stack);
            ApplicationId firstAppId = (ApplicationId)DiameterRxResourceAdaptor.this.authApplicationIds.get(0);
            messageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
            acc.setRxMessageFactory(messageFactory);
        }

        private void performBeforeReturnRx(RxClientSessionActivityImpl acc, Session session) {
            RxMessageFactoryImpl messageFactory = new RxMessageFactoryImpl((DiameterMessageFactory)DiameterRxResourceAdaptor.this.baseMessageFactory, session.getSessionId(), DiameterRxResourceAdaptor.this.stack);
            ApplicationId firstAppId = (ApplicationId)DiameterRxResourceAdaptor.this.authApplicationIds.get(0);
            messageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
            acc.setRxMessageFactory(messageFactory);
        }

        private void performBeforeReturnOnBase(DiameterActivityImpl ac, Session session) {
            DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, DiameterRxResourceAdaptor.this.stack, new DiameterIdentity[0]);
            ac.setAvpFactory(DiameterRxResourceAdaptor.this.baseAvpFactory);
            ac.setMessageFactory((DiameterMessageFactory)msgFactory);
            ac.setCurrentWorkingSession(session);
            ac.setSessionListener((Object)this.lst);
        }

        public DiameterActivity get(DiameterActivityHandle handle) {
            return super.get(handle);
        }

        public void put(DiameterActivityHandle handle, DiameterActivity activity) {
            super.put(handle, activity);
        }

        public DiameterActivity remove(DiameterActivityHandle handle) {
            return super.remove(handle);
        }
    }

    private class RxProviderImpl
    implements RxProvider {
        private DiameterRxResourceAdaptor ra;
        private Validator validator = new ValidatorImpl();

        public RxProviderImpl(DiameterRxResourceAdaptor ra) {
            this.ra = ra;
        }

        public RxClientSessionActivity createRxClientSessionActivity() throws CreateActivityException {
            try {
                ClientRxSession session = (ClientRxSession)((ISessionFactory)DiameterRxResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, (ApplicationId)DiameterRxResourceAdaptor.this.authApplicationIds.get(0), ClientRxSession.class, new Object[0]);
                DiameterRxResourceAdaptor.this.sessionCreated(session);
                if (session == null) {
                    DiameterRxResourceAdaptor.this.tracer.severe("Failure creating Rx Client Session (null).");
                    return null;
                }
                return (RxClientSessionActivity)DiameterRxResourceAdaptor.this.getActivity((ActivityHandle)DiameterRxResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (Exception e) {
                throw new CreateActivityException((Throwable)e);
            }
        }

        public RxClientSessionActivity createRxClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            RxClientSessionActivityImpl clientSession = (RxClientSessionActivityImpl)this.createRxClientSessionActivity();
            clientSession.setDestinationHost(destinationHost);
            clientSession.setDestinationRealm(destinationRealm);
            return clientSession;
        }

        public RxAvpFactory getRxAvpFactory() {
            return this.ra.rxAvpFactory;
        }

        public RxMessageFactory getRxMessageFactory() {
            return this.ra.rxMessageFactory;
        }

        public AAAnswer sendAARequest(AARequest aar) throws IOException {
            try {
                DiameterActivityImpl activity = (DiameterActivityImpl)DiameterRxResourceAdaptor.this.getActivity((ActivityHandle)DiameterRxResourceAdaptor.this.getActivityHandle(aar.getSessionId()));
                if (activity == null) {
                    activity = (DiameterActivityImpl)this.createActivity(((DiameterMessageImpl)aar).getGenericData());
                }
                return (AAAnswer)activity.sendSyncMessage((DiameterMessage)aar);
            }
            catch (Exception e) {
                DiameterRxResourceAdaptor.this.tracer.severe("Failure sending sync request.", (Throwable)e);
                return null;
            }
        }

        public AbortSessionAnswer sendAbortSessionRequest(AbortSessionRequest ccr) throws IOException {
            try {
                DiameterActivityImpl activity = (DiameterActivityImpl)DiameterRxResourceAdaptor.this.getActivity((ActivityHandle)DiameterRxResourceAdaptor.this.getActivityHandle(ccr.getSessionId()));
                if (activity == null) {
                    activity = (DiameterActivityImpl)this.createActivity(((DiameterMessageImpl)ccr).getGenericData());
                }
                return (AbortSessionAnswer)activity.sendSyncMessage((DiameterMessage)ccr);
            }
            catch (Exception e) {
                DiameterRxResourceAdaptor.this.tracer.severe("Failure sending sync request.", (Throwable)e);
                return null;
            }
        }

        public SessionTerminationAnswer sendSessionTerminationRequest(SessionTerminationRequest ccr) throws IOException {
            try {
                DiameterActivityImpl activity = (DiameterActivityImpl)DiameterRxResourceAdaptor.this.getActivity((ActivityHandle)DiameterRxResourceAdaptor.this.getActivityHandle(ccr.getSessionId()));
                if (activity == null) {
                    activity = (DiameterActivityImpl)this.createActivity(((DiameterMessageImpl)ccr).getGenericData());
                }
                return (SessionTerminationAnswer)activity.sendSyncMessage((DiameterMessage)ccr);
            }
            catch (Exception e) {
                DiameterRxResourceAdaptor.this.tracer.severe("Failure sending sync request.", (Throwable)e);
                return null;
            }
        }

        public ReAuthAnswer sendReAuthRequest(ReAuthRequest ccr) throws IOException {
            try {
                DiameterActivityImpl activity = (DiameterActivityImpl)DiameterRxResourceAdaptor.this.getActivity((ActivityHandle)DiameterRxResourceAdaptor.this.getActivityHandle(ccr.getSessionId()));
                if (activity == null) {
                    activity = (DiameterActivityImpl)this.createActivity(((DiameterMessageImpl)ccr).getGenericData());
                }
                return (ReAuthAnswer)activity.sendSyncMessage((DiameterMessage)ccr);
            }
            catch (Exception e) {
                DiameterRxResourceAdaptor.this.tracer.severe("Failure sending sync request.", (Throwable)e);
                return null;
            }
        }

        private DiameterActivity createActivity(Message message) throws CreateActivityException {
            DiameterActivity activity = DiameterRxResourceAdaptor.this.activities.get(DiameterRxResourceAdaptor.this.getActivityHandle(message.getSessionId()));
            if (activity == null) {
                if (message.isRequest()) {
                    return this.createRxServerSessionActivity((Request)message);
                }
                AvpSet avps = message.getAvps();
                Avp avp = null;
                DiameterIdentity destinationHost = null;
                DiameterIdentity destinationRealm = null;
                avp = avps.getAvp(293);
                if (avp != null) {
                    try {
                        destinationHost = new DiameterIdentity(avp.getDiameterIdentity());
                    }
                    catch (AvpDataException e) {
                        DiameterRxResourceAdaptor.this.tracer.severe("Failed to extract Destination-Host from Message.", (Throwable)e);
                    }
                }
                if ((avp = avps.getAvp(283)) != null) {
                    try {
                        destinationRealm = new DiameterIdentity(avp.getDiameterIdentity());
                    }
                    catch (AvpDataException e) {
                        DiameterRxResourceAdaptor.this.tracer.severe("Failed to extract Destination-Realm from Message.", (Throwable)e);
                    }
                }
                return (DiameterActivity)this.createRxClientSessionActivity(destinationHost, destinationRealm);
            }
            return activity;
        }

        private DiameterActivity createRxServerSessionActivity(Request message) throws CreateActivityException {
            try {
                ServerRxSession session = (ServerRxSession)((ISessionFactory)DiameterRxResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(message.getSessionId(), (ApplicationId)DiameterRxResourceAdaptor.this.authApplicationIds.get(0), ServerRxSession.class, new Object[0]);
                DiameterRxResourceAdaptor.this.sessionCreated(session);
                if (session == null) {
                    DiameterRxResourceAdaptor.this.tracer.severe("Failure creating Rx Server Session (null).");
                    return null;
                }
                return (DiameterActivity)DiameterRxResourceAdaptor.this.getActivity((ActivityHandle)DiameterRxResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (Exception e) {
                throw new CreateActivityException((Throwable)e);
            }
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }

        public Validator getValidator() {
            return this.validator;
        }
    }
}

