/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.FireableEventType;
import org.jdiameter.api.Message;

public class EventIDCache {
    private static final String RX_PACKAGE_PREFIX = "net.java.slee.resource.diameter.rx.events.";
    private static final String BASE_PACKAGE_PREFIX = "net.java.slee.resource.diameter.base.events.";
    public static Map<Integer, String> eventNames = new ConcurrentHashMap<Integer, String>();
    public static final String ERROR_ANSWER = "net.java.slee.resource.diameter.base.events.ErrorAnswer";
    public static final String EXTENSION_DIAMETER_MESSAGE = "net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage";
    private static final String VENDOR = "java.net";
    private static final String VERSION = "0.8";
    private ConcurrentHashMap<String, FireableEventType> eventIds = new ConcurrentHashMap();

    public FireableEventType getEventId(EventLookupFacility eventLookupFacility, Message message) {
        FireableEventType eventID;
        if (message.isError()) {
            eventID = this.getEventId(eventLookupFacility, ERROR_ANSWER);
        } else {
            int commandCode = message.getCommandCode();
            boolean isRequest = message.isRequest();
            String eventName = eventNames.get(commandCode);
            eventID = eventName != null ? this.getEventId(eventLookupFacility, eventName + (isRequest ? "Request" : "Answer")) : this.getEventId(eventLookupFacility, EXTENSION_DIAMETER_MESSAGE);
        }
        return eventID;
    }

    private FireableEventType getEventId(EventLookupFacility eventLookupFacility, String eventName) {
        FireableEventType eventType = this.eventIds.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, VENDOR, VERSION));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (eventType != null) {
                this.eventIds.put(eventName, eventType);
            }
        }
        return eventType;
    }

    static {
        HashMap<Integer, String> eventsTemp = new HashMap<Integer, String>();
        eventsTemp.put(265, "net.java.slee.resource.diameter.rx.events.AA");
        eventsTemp.put(274, "net.java.slee.resource.diameter.rx.events.AbortSession");
        eventsTemp.put(258, "net.java.slee.resource.diameter.rx.events.ReAuth");
        eventsTemp.put(275, "net.java.slee.resource.diameter.rx.events.SessionTermination");
        eventNames = Collections.unmodifiableMap(eventsTemp);
    }
}

