/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rx;

import java.io.IOException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rx.RxAvpFactory;
import net.java.slee.resource.diameter.rx.RxClientSessionActivity;
import net.java.slee.resource.diameter.rx.RxMessageFactory;
import net.java.slee.resource.diameter.rx.RxSessionState;
import net.java.slee.resource.diameter.rx.events.AARequest;
import net.java.slee.resource.diameter.rx.events.AbortSessionAnswer;
import net.java.slee.resource.diameter.rx.events.ReAuthAnswer;
import net.java.slee.resource.diameter.rx.events.SessionTerminationRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.rx.ClientRxSession;
import org.jdiameter.api.rx.events.RxAARequest;
import org.jdiameter.api.rx.events.RxAbortSessionAnswer;
import org.jdiameter.api.rx.events.RxReAuthAnswer;
import org.jdiameter.api.rx.events.RxSessionTermRequest;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.rx.ClientRxSessionState;
import org.jdiameter.common.impl.app.rx.RxAARequestImpl;
import org.jdiameter.common.impl.app.rx.RxAbortSessionAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxReAuthAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxSessionTermRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.rx.RxSessionActivityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RxClientSessionActivityImpl
extends RxSessionActivityImpl
implements RxClientSessionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 6391181777305378777L;
    protected transient ClientRxSession session;

    public RxClientSessionActivityImpl(RxMessageFactory rxMessageFactory, RxAvpFactory rxAvpFactory, ClientRxSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(rxMessageFactory, rxAvpFactory, null, (EventListener<Request, Answer>)((EventListener)session), destinationRealm, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)session.getSessions().get(0));
    }

    public AARequest createRxAARequest() {
        AARequest request = super.getRxMessageFactory().createAARequest(super.getSessionId());
        if (this.destinationHost != null) {
            request.setDestinationHost(this.destinationHost);
        }
        if (this.destinationRealm != null) {
            request.setDestinationRealm(this.destinationRealm);
        }
        return request;
    }

    public SessionTerminationRequest createSessionTermRequest() {
        SessionTerminationRequest request = super.getRxMessageFactory().createSessionTerminationRequest();
        if (this.destinationHost != null) {
            request.setDestinationHost(this.destinationHost);
        }
        if (this.destinationRealm != null) {
            request.setDestinationRealm(this.destinationRealm);
        }
        return request;
    }

    public void sendRxAARequest(AARequest aar) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)aar;
        try {
            this.session.sendAARequest((RxAARequest)new RxAARequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendSessionTermRequest(SessionTerminationRequest str) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)str;
        try {
            this.session.sendSessionTermRequest((RxSessionTermRequest)new RxSessionTermRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendReAuthAnswer(ReAuthAnswer raa) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)raa;
        try {
            this.session.sendReAuthAnswer((RxReAuthAnswer)new RxReAuthAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendAbortSessionAnswer(AbortSessionAnswer asr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)asr;
        try {
            this.session.sendAbortSessionAnswer((RxAbortSessionAnswer)new RxAbortSessionAnswerImpl((Answer)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession arg0, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ClientRxSessionState s = (ClientRxSessionState)newState;
        switch (s) {
            case IDLE: {
                this.setTerminateAfterProcessing(true);
                this.baseListener.startActivityRemoveTimer(this.getActivityHandle());
                break;
            }
            default: {
                logger.error((Object)("Unexpected state in AA Client FSM: " + s));
            }
        }
    }

    public void setSession(ClientRxSession session2) {
        this.session = session2;
        this.session.addStateChangeNotification((StateChangeListener)this);
    }

    public RxSessionState getState() {
        ClientRxSessionState s = (ClientRxSessionState)this.session.getState(ClientRxSessionState.class);
        switch (s) {
            case PENDING_EVENT: {
                return RxSessionState.PENDING_EVENT;
            }
            case PENDING_BUFFERED: {
                return RxSessionState.PENDING_BUFFERED;
            }
            case PENDING_STR: {
                return RxSessionState.PENDING_STR;
            }
            case PENDING_AAR: {
                return RxSessionState.PENDING_AAR;
            }
            case OPEN: {
                return RxSessionState.OPEN;
            }
            case IDLE: {
                return RxSessionState.IDLE;
            }
        }
        logger.error((Object)("Unexpected state in AA Client FSM: " + s));
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isTerminateAfterProcessing() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RxClientSessionActivityImpl other = (RxClientSessionActivityImpl)((Object)obj);
        return this.terminateAfterProcessing == other.isTerminateAfterProcessing();
    }

    public void endActivity() {
        this.session.release();
        super.endActivity();
    }
}

