/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rx;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import net.java.slee.resource.diameter.rx.RxMessageFactory;
import net.java.slee.resource.diameter.rx.events.AAAnswer;
import net.java.slee.resource.diameter.rx.events.AARequest;
import net.java.slee.resource.diameter.rx.events.AbortSessionAnswer;
import net.java.slee.resource.diameter.rx.events.AbortSessionRequest;
import net.java.slee.resource.diameter.rx.events.ReAuthAnswer;
import net.java.slee.resource.diameter.rx.events.ReAuthRequest;
import net.java.slee.resource.diameter.rx.events.SessionTerminationAnswer;
import net.java.slee.resource.diameter.rx.events.SessionTerminationRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Message;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.diameter.rx.events.AAAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.AARequestImpl;
import org.mobicents.slee.resource.diameter.rx.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.AbortSessionRequestImpl;
import org.mobicents.slee.resource.diameter.rx.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.ReAuthRequestImpl;
import org.mobicents.slee.resource.diameter.rx.events.SessionTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.SessionTerminationRequestImpl;

public class RxMessageFactoryImpl
implements RxMessageFactory {
    protected Logger logger = Logger.getLogger(RxMessageFactoryImpl.class);
    private static final DiameterAvp[] EMPTY_AVP_ARRAY = new DiameterAvp[0];
    protected static final Set<Integer> ids;
    protected DiameterMessageFactory baseFactory = null;
    protected String sessionId;
    protected Stack stack;
    private ApplicationId rxAppId = ApplicationId.createByAuthAppId((long)0x1000014L);

    public RxMessageFactoryImpl(DiameterMessageFactory baseFactory, String sessionId, Stack stack) {
        this.baseFactory = baseFactory;
        this.sessionId = sessionId;
        this.stack = stack;
    }

    public void setApplicationId(long vendorId, long applicationId) {
        this.rxAppId = ApplicationId.createByAuthAppId((long)vendorId, (long)applicationId);
    }

    public ApplicationId getApplicationId() {
        return this.rxAppId;
    }

    public AARequest createAARequest() {
        AARequest aar = (AARequest)this.createDiameterMessage(null, new DiameterAvp[0], 265, this.rxAppId);
        if (this.sessionId != null) {
            aar.setSessionId(this.sessionId);
        }
        return aar;
    }

    public AARequest createAARequest(String sessionId) {
        AARequest aar = this.createAARequest();
        aar.setSessionId(sessionId);
        return aar;
    }

    public AAAnswer createAAAnswer(AARequest request) {
        AAAnswerImpl msg = (AAAnswerImpl)this.createDiameterMessage(request.getHeader(), EMPTY_AVP_ARRAY, 0, this.rxAppId);
        msg.getGenericData().getAvps().removeAvp(293);
        msg.getGenericData().getAvps().removeAvp(283);
        msg.getGenericData().getAvps().removeAvp(264);
        msg.getGenericData().getAvps().removeAvp(296);
        msg.setSessionId(request.getSessionId());
        DiameterAvp[] messageAvps = request.getAvps();
        if (messageAvps != null) {
            for (DiameterAvp a : messageAvps) {
                try {
                    if (!ids.contains(a.getCode())) continue;
                    msg.addAvp(a);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to add AVP to answer. Code[" + a.getCode() + "]"), (Throwable)e);
                }
            }
        }
        return msg;
    }

    public AbortSessionAnswer createAbortSessionAnswer(AbortSessionRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        AbortSessionAnswer msg = (AbortSessionAnswer)this.createDiameterMessage(request.getHeader(), avps, 274, this.getApplicationId((DiameterMessage)request));
        if (msg.getSessionId() == null) {
            String reqSessionId = request.getSessionId();
            if (reqSessionId != null) {
                msg.setSessionId(reqSessionId);
            } else if (this.sessionId != null) {
                msg.setSessionId(this.sessionId);
            }
        }
        return msg;
    }

    public AbortSessionAnswer createAbortSessionAnswer(AbortSessionRequest request) {
        try {
            return this.createAbortSessionAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            this.logger.error((Object)"Unexpected failure while trying to create ASA message.", (Throwable)e);
            return null;
        }
    }

    public AbortSessionRequest createAbortSessionRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        AbortSessionRequest msg = (AbortSessionRequest)this.createDiameterMessage(null, avps, 274, this.rxAppId);
        if (msg.getSessionId() == null && this.sessionId != null) {
            msg.setSessionId(this.sessionId);
        }
        return msg;
    }

    public AbortSessionRequest createAbortSessionRequest() {
        try {
            return this.createAbortSessionRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            this.logger.error((Object)"Unexpected failure while trying to create ASR message.", (Throwable)e);
            return null;
        }
    }

    public ReAuthAnswer createReAuthAnswer(ReAuthRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        ReAuthAnswer msg = (ReAuthAnswer)this.createDiameterMessage(request.getHeader(), avps, 258, this.getApplicationId((DiameterMessage)request));
        if (msg.getSessionId() == null) {
            String reqSessionId = request.getSessionId();
            if (reqSessionId != null) {
                msg.setSessionId(reqSessionId);
            } else if (this.sessionId != null) {
                msg.setSessionId(this.sessionId);
            }
        }
        return msg;
    }

    public ReAuthAnswer createReAuthAnswer(ReAuthRequest request) {
        try {
            return this.createReAuthAnswer(request, new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            this.logger.error((Object)"Unexpected failure while trying to create RAA message.", (Throwable)e);
            return null;
        }
    }

    public ReAuthRequest createReAuthRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        ReAuthRequest msg = (ReAuthRequest)this.createDiameterMessage(null, avps, 258, this.rxAppId);
        if (msg.getSessionId() == null && this.sessionId != null) {
            msg.setSessionId(this.sessionId);
        }
        return msg;
    }

    public ReAuthRequest createReAuthRequest() {
        try {
            return this.createReAuthRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            this.logger.error((Object)"Unexpected failure while trying to create RAR message.", (Throwable)e);
            return null;
        }
    }

    public SessionTerminationAnswer createSessionTerminationAnswer(SessionTerminationRequest request, DiameterAvp[] avps) throws AvpNotAllowedException {
        SessionTerminationAnswer msg = (SessionTerminationAnswer)this.createDiameterMessage(request.getHeader(), avps, 275, this.rxAppId);
        if (msg.getSessionId() == null) {
            String reqSessionId = request.getSessionId();
            if (reqSessionId != null) {
                msg.setSessionId(reqSessionId);
            } else if (this.sessionId != null) {
                msg.setSessionId(this.sessionId);
            }
        }
        return msg;
    }

    public SessionTerminationAnswer createSessionTerminationAnswer(SessionTerminationRequest request) {
        try {
            return this.createSessionTerminationAnswer(request, EMPTY_AVP_ARRAY);
        }
        catch (AvpNotAllowedException e) {
            this.logger.error((Object)"Unexpected failure while trying to create STA message.", (Throwable)e);
            return null;
        }
    }

    public SessionTerminationRequest createSessionTerminationRequest(DiameterAvp[] avps) throws AvpNotAllowedException {
        SessionTerminationRequest msg = (SessionTerminationRequest)this.createDiameterMessage(null, avps, 275, this.rxAppId);
        if (msg.getSessionId() == null && this.sessionId != null) {
            msg.setSessionId(this.sessionId);
        }
        return msg;
    }

    public SessionTerminationRequest createSessionTerminationRequest() {
        try {
            return this.createSessionTerminationRequest(new DiameterAvp[0]);
        }
        catch (AvpNotAllowedException e) {
            this.logger.error((Object)"Unexpected failure while trying to create STR message.", (Throwable)e);
            return null;
        }
    }

    protected DiameterMessage createDiameterMessage(DiameterHeader diameterHeader, DiameterAvp[] avps, int _commandCode, ApplicationId appId) throws IllegalArgumentException {
        Message raw;
        boolean creatingRequest = diameterHeader == null;
        Message msg = null;
        if (!creatingRequest) {
            raw = this.createMessage(diameterHeader, avps, 0, appId);
            raw.setRequest(false);
            raw.setReTransmitted(false);
            msg = raw;
        } else {
            raw = this.createMessage(diameterHeader, avps, _commandCode, appId);
            raw.setRequest(true);
            msg = raw;
        }
        int commandCode = creatingRequest ? _commandCode : diameterHeader.getCommandCode();
        AARequestImpl diamMessage = null;
        switch (commandCode) {
            case 265: {
                diamMessage = creatingRequest ? new AARequestImpl(msg) : new AAAnswerImpl(msg);
                break;
            }
            case 274: {
                diamMessage = creatingRequest ? new AbortSessionRequestImpl(msg) : new AbortSessionAnswerImpl(msg);
                break;
            }
            case 258: {
                diamMessage = creatingRequest ? new ReAuthRequestImpl(msg) : new ReAuthAnswerImpl(msg);
                break;
            }
            case 275: {
                diamMessage = creatingRequest ? new SessionTerminationRequestImpl(msg) : new SessionTerminationAnswerImpl(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.addOriginHostAndRealm((DiameterMessage)diamMessage);
        return diamMessage;
    }

    public DiameterMessageFactory getBaseMessageFactory() {
        return this.baseFactory;
    }

    protected Message createMessage(DiameterHeader header, DiameterAvp[] avps, int _commandCode, ApplicationId appId) throws AvpNotAllowedException {
        try {
            Message msg = this.createRawMessage(header, _commandCode, appId);
            if (avps != null && avps.length > 0) {
                AvpSet set = msg.getAvps();
                for (DiameterAvp avp : avps) {
                    if (appId != null && (avp.getCode() == 260 || avp.getCode() == 259 || avp.getCode() == 258)) continue;
                    this.addAvp(avp, set);
                }
            }
            return msg;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure trying to create Diameter message.", (Throwable)e);
            return null;
        }
    }

    protected Message createRawMessage(DiameterHeader header, int _commandCode, ApplicationId appId) {
        int commandCode = 0;
        long endToEndId = 0L;
        long hopByHopId = 0L;
        boolean isRequest = true;
        boolean isProxiable = true;
        boolean isError = false;
        boolean isPotentiallyRetransmitted = false;
        if (header != null) {
            commandCode = header.getCommandCode();
            endToEndId = header.getEndToEndId();
            hopByHopId = header.getHopByHopId();
            isRequest = header.isRequest();
            isProxiable = header.isProxiable();
            isError = header.isError();
            isPotentiallyRetransmitted = header.isPotentiallyRetransmitted();
        } else {
            commandCode = _commandCode;
        }
        try {
            Message msg = this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, appId != null ? appId : this.rxAppId, hopByHopId, endToEndId, new Avp[0]);
            msg.setRequest(isRequest);
            msg.setProxiable(isProxiable);
            msg.setError(isError);
            msg.setReTransmitted(isRequest && isPotentiallyRetransmitted);
            return msg;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure while trying to create raw message.", (Throwable)e);
            return null;
        }
    }

    protected void addAvp(DiameterAvp avp, AvpSet set) {
        if (avp instanceof GroupedAvp) {
            DiameterAvp[] groupedAVPs;
            AvpSet avpSet = set.addGroupedAvp(avp.getCode(), avp.getVendorId(), avp.getMandatoryRule() != 2, avp.getProtectedRule() == 0);
            for (DiameterAvp avpFromGroup : groupedAVPs = ((GroupedAvp)avp).getExtensionAvps()) {
                this.addAvp(avpFromGroup, avpSet);
            }
        } else if (avp != null) {
            set.addAvp(avp.getCode(), avp.byteArrayValue(), avp.getVendorId(), avp.getMandatoryRule() != 2, avp.getProtectedRule() == 0);
        }
    }

    public void clean() {
    }

    public DiameterMessage createMessage(DiameterHeader header, DiameterAvp[] avps) throws AvpNotAllowedException {
        return this.createDiameterMessage(header, avps, header.getCommandCode(), this.rxAppId);
    }

    private void addOriginHostAndRealm(DiameterMessage msg) {
        if (!msg.hasOriginHost()) {
            msg.setOriginHost(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getUri().getFQDN().toString()));
        }
        if (!msg.hasOriginRealm()) {
            msg.setOriginRealm(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getRealmName()));
        }
    }

    private ApplicationId getApplicationId(DiameterMessage msg) {
        ApplicationId applicationId = this.getApplicationId(msg.getAvps());
        if (applicationId == null) {
            applicationId = this.rxAppId;
        }
        return applicationId;
    }

    private ApplicationId getApplicationId(DiameterAvp[] avps) {
        ApplicationId applicationId = null;
        long vendorId = 0L;
        if (avps != null) {
            for (DiameterAvp avp : avps) {
                if (avp.getCode() == 266) {
                    vendorId = avp.intValue();
                }
                if (avp.getCode() == 260) {
                    applicationId = this.getApplicationId(((GroupedAvp)avp).getExtensionAvps());
                    break;
                }
                if (avp.getCode() == 259) {
                    applicationId = ApplicationId.createByAccAppId((long)vendorId, (long)avp.intValue());
                    break;
                }
                if (avp.getCode() != 258) continue;
                applicationId = ApplicationId.createByAuthAppId((long)vendorId, (long)avp.intValue());
                break;
            }
        }
        return applicationId;
    }

    static {
        HashSet _ids = new HashSet();
        ids = Collections.unmodifiableSet(_ids);
    }
}

