/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rx;

import java.util.concurrent.Future;
import javax.naming.OperationNotSupportedException;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rx.RxAvpFactory;
import net.java.slee.resource.diameter.rx.RxMessageFactory;
import net.java.slee.resource.diameter.rx.RxSessionActivity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.AAAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.rx.events.SessionTerminationAnswerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RxSessionActivityImpl
extends DiameterActivityImpl
implements RxSessionActivity {
    private static final long serialVersionUID = 5037967180962414549L;
    protected transient RxMessageFactory rxMessageFactory;

    public RxSessionActivityImpl(RxMessageFactory rxMessageFactory, RxAvpFactory rxAvpFactory, Session session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(rxMessageFactory.getBaseMessageFactory(), rxAvpFactory.getBaseFactory(), session, raEventListener, destinationHost, destinationRealm);
        this.rxMessageFactory = rxMessageFactory;
    }

    public RxMessageFactory getRxMessageFactory() {
        return this.rxMessageFactory;
    }

    public void setRxMessageFactory(RxMessageFactory rxMessageFactory) {
        this.rxMessageFactory = rxMessageFactory;
    }

    public void setDestinationHost(DiameterIdentity destinationHost) {
        this.destinationHost = destinationHost;
    }

    public void setDestinationRealm(DiameterIdentity destinationRealm) {
        this.destinationRealm = destinationRealm;
    }

    protected Message doSendMessage(DiameterMessage message) {
        Message receivedMessage = null;
        try {
            if (!(message instanceof DiameterMessageImpl)) {
                throw new OperationNotSupportedException("Trying to send wrong type of message? [" + message.getClass() + "] \n" + message);
            }
            Future future = this.session.send(((DiameterMessageImpl)message).getGenericData());
            receivedMessage = (Message)future.get();
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            logger.error((Object)"Failure sending sync request.", (Throwable)e);
        }
        return receivedMessage;
    }

    public DiameterMessage sendSyncMessage(DiameterMessage message) {
        ErrorAnswerImpl answer = null;
        Message receivedMessage = this.doSendMessage(message);
        if (receivedMessage != null) {
            if (!receivedMessage.isRequest()) {
                if (receivedMessage.isError()) {
                    answer = new ErrorAnswerImpl(receivedMessage);
                } else {
                    switch (receivedMessage.getCommandCode()) {
                        case 274: {
                            answer = new AbortSessionAnswerImpl(receivedMessage);
                            break;
                        }
                        case 258: {
                            answer = new ReAuthAnswerImpl(receivedMessage);
                            break;
                        }
                        case 275: {
                            answer = new SessionTerminationAnswerImpl(receivedMessage);
                            break;
                        }
                        case 265: {
                            answer = new AAAnswerImpl(receivedMessage);
                        }
                        default: {
                            logger.error((Object)("Received an unknown type of Message for Base Activity: " + receivedMessage));
                            break;
                        }
                    }
                }
            } else {
                logger.error((Object)"Received a REQUEST message when expecting an ANSWER.");
            }
        } else {
            logger.debug((Object)"No answer received. Returning null.");
        }
        return answer;
    }
}

