/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.s6a;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.Validator;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.s6a.S6aAVPFactory;
import net.java.slee.resource.diameter.s6a.S6aClientSessionActivity;
import net.java.slee.resource.diameter.s6a.S6aMessageFactory;
import net.java.slee.resource.diameter.s6a.S6aProvider;
import net.java.slee.resource.diameter.s6a.S6aServerSessionActivity;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.s6a.ClientS6aSession;
import org.jdiameter.api.s6a.ServerS6aSession;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.ValidatorImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.handlers.AuthorizationSessionFactory;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.s6a.EventIDCache;
import org.mobicents.slee.resource.diameter.s6a.S6aAVPFactoryImpl;
import org.mobicents.slee.resource.diameter.s6a.S6aClientSessionImpl;
import org.mobicents.slee.resource.diameter.s6a.S6aMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.s6a.S6aServerSessionImpl;
import org.mobicents.slee.resource.diameter.s6a.events.AuthenticationInformationAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.AuthenticationInformationRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.CancelLocationAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.CancelLocationRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.DeleteSubscriberDataAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.DeleteSubscriberDataRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.InsertSubscriberDataAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.InsertSubscriberDataRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.NotifyAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.NotifyRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.PurgeUEAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.PurgeUERequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.ResetAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.ResetRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.UpdateLocationAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.UpdateLocationRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.handlers.S6aSessionFactory;

public class DiameterS6aResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private List<ApplicationId> authApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    private DiameterBaseMarshaler marshaler;
    private Stack stack;
    private long messageTimeout = 5000L;
    private long activityRemoveDelay = 30000L;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private DiameterAvpFactory baseAvpFactory = null;
    private SessionFactory sessionFactory = null;
    private S6aAVPFactory s6aAvpFactory;
    private S6aMessageFactory s6aMessageFactory;
    private S6aSessionFactory s6aSessionFactory = null;
    private transient EventLookupFacility eventLookup = null;
    private transient DiameterActivityManagement activities = null;
    private transient S6aProviderImpl raProvider = null;
    protected transient AuthorizationSessionFactory authSessionFactory = null;
    protected transient SessionFactory proxySessionFactory = null;
    private static final int EVENT_FLAGS = DiameterS6aResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = ActivityFlags.setRequestSleeActivityGCCallback((int)2);

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterS6aResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
        this.raProvider = new S6aProviderImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter S6a RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.s6aMessageFactory = new S6aMessageFactoryImpl(this.stack);
            this.s6aAvpFactory = new S6aAVPFactoryImpl(this.baseAvpFactory);
            this.sessionFactory = this.stack.getSessionFactory();
            this.s6aSessionFactory = new S6aSessionFactory(this, this.messageTimeout, this.sessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerS6aSession.class, (IAppSessionFactory)this.s6aSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientS6aSession.class, (IAppSessionFactory)this.s6aSessionFactory);
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter S6a RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister S6a RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: raStopping completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: raInactive.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: raInactive completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                appIds.add(ApplicationId.createByAuthAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
            this.authApplicationIds = appIds;
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: queryLiveness :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: getActivity :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return null;
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        this.tracer.info("Diameter S6a RA :: activityEnded :: handle[" + handle + ".");
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        this.activities.startActivityRemoveTimer(handle);
    }

    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        this.activities.stopActivityRemoveTimer(handle);
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.activityEnded(handle);
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    public void endActivity(DiameterActivityHandle handle) {
        this.sleeEndpoint.endActivity((ActivityHandle)handle);
    }

    public void update(DiameterActivityHandle handle, DiameterActivity activity) {
        this.activities.update(handle, activity);
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 316: {
                return isRequest ? new UpdateLocationRequestImpl(message) : new UpdateLocationAnswerImpl(message);
            }
            case 318: {
                return isRequest ? new AuthenticationInformationRequestImpl(message) : new AuthenticationInformationAnswerImpl(message);
            }
            case 317: {
                return isRequest ? new CancelLocationRequestImpl(message) : new CancelLocationAnswerImpl(message);
            }
            case 319: {
                return isRequest ? new InsertSubscriberDataRequestImpl(message) : new InsertSubscriberDataAnswerImpl(message);
            }
            case 320: {
                return isRequest ? new DeleteSubscriberDataRequestImpl(message) : new DeleteSubscriberDataAnswerImpl(message);
            }
            case 321: {
                return isRequest ? new PurgeUERequestImpl(message) : new PurgeUEAnswerImpl(message);
            }
            case 322: {
                return isRequest ? new ResetRequestImpl(message) : new ResetAnswerImpl(message);
            }
            case 323: {
                return isRequest ? new NotifyRequestImpl(message) : new NotifyAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    private void addActivity(DiameterActivity ac, boolean suspended) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            if (suspended) {
                this.sleeEndpoint.startActivitySuspended((ActivityHandle)activity.getActivityHandle(), (Object)activity, DEFAULT_ACTIVITY_FLAGS);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, DEFAULT_ACTIVITY_FLAGS);
            }
            activity.setSessionListener((Object)this);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.authApplicationIds.toArray(new ApplicationId[this.authApplicationIds.size()]));
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        this.activities = new LocalDiameterActivityManagement(this.raContext, this.activityRemoveDelay);
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        try {
            if (request == null) {
                this.tracer.severe("Request is null");
            }
            if (this.raProvider == null) {
                this.tracer.severe("raProvider is null");
            }
            this.raProvider.createActivity((Message)request);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter S6a RA :: receivedSuccessMessage :: Request[" + request + "], Answer[" + answer + "].");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + answer.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter S6a RA :: timeoutExpired :: Request[" + request + "].");
        }
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(request.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public void sessionCreated(ServerS6aSession session) {
        S6aMessageFactoryImpl sessionMsgFactory = new S6aMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        S6aServerSessionImpl serverActivity = new S6aServerSessionImpl(sessionMsgFactory, this.s6aAvpFactory, session, (EventListener<Request, Answer>)this, null, null, this.stack);
        serverActivity.setSessionListener(this);
    }

    public void sessionCreated(ClientS6aSession session) {
        S6aMessageFactoryImpl sessionMsgFactory = new S6aMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        S6aClientSessionImpl clientActivity = new S6aClientSessionImpl(sessionMsgFactory, this.s6aAvpFactory, session, (EventListener<Request, Answer>)this, null, null, this.stack);
        clientActivity.setSessionListener(this);
    }

    public void sessionCreated(Session session) {
        DiameterMessageFactoryImpl sessionMsgFactory = new DiameterMessageFactoryImpl(session, this.stack, new DiameterIdentity[]{null, null});
        DiameterActivityImpl activity = new DiameterActivityImpl((DiameterMessageFactory)sessionMsgFactory, this.baseAvpFactory, session, (EventListener)this, null, null);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity, true);
    }

    public ApplicationId[] getSupportedApplications() {
        return (ApplicationId[])this.authApplicationIds.toArray();
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        DiameterActivityHandle dah = this.getActivityHandle(source.getSessionId());
        Object activity = this.getActivity((ActivityHandle)dah);
        if (activity != null) {
            if (source instanceof ServerShSession) {
                try {
                    StateChangeListener scl = (StateChangeListener)activity;
                    scl.stateChanged((Object)source, oldState, newState);
                }
                catch (Exception e) {
                    this.tracer.warning("Failed to deliver state, for: " + dah + " on stateChanged( " + source + ", " + oldState + ", " + newState + " )", (Throwable)e);
                }
            }
        } else {
            this.tracer.warning("No activity for: " + dah + " on stateChanged( " + source + ", " + oldState + ", " + newState + " )");
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                this.tracer.severe("Failure getting peer list.", (Throwable)e);
            }
        }
        return new DiameterIdentity[0];
    }

    private class S6aProviderImpl
    implements S6aProvider {
        protected DiameterS6aResourceAdaptor ra;
        protected Validator validator = new ValidatorImpl();

        public S6aProviderImpl(DiameterS6aResourceAdaptor s6aResourceAdaptor) {
            this.ra = s6aResourceAdaptor;
        }

        private DiameterActivity createActivity(Message message) throws CreateActivityException {
            DiameterActivity activity = DiameterS6aResourceAdaptor.this.activities.get(DiameterS6aResourceAdaptor.this.getActivityHandle(message.getSessionId()));
            if (activity == null) {
                if (message.isRequest()) {
                    switch (message.getCommandCode()) {
                        case 316: 
                        case 318: 
                        case 321: 
                        case 323: {
                            return this.createS6aServerSessionActivity((Request)message);
                        }
                        case 317: 
                        case 319: 
                        case 320: 
                        case 322: {
                            return this.createS6aClientSessionActivity((Request)message);
                        }
                    }
                } else {
                    throw new IllegalStateException("Got answer, there should already be activity.");
                }
            }
            return activity;
        }

        private DiameterActivity createS6aServerSessionActivity(Request request) throws CreateActivityException {
            ServerS6aSession session = null;
            try {
                String sessionId = request == null ? null : request.getSessionId();
                ApplicationId appId = request.getApplicationIdAvps().isEmpty() ? null : (ApplicationId)request.getApplicationIdAvps().iterator().next();
                session = (ServerS6aSession)((ISessionFactory)DiameterS6aResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(sessionId, appId, ServerS6aSession.class, new Object[]{request});
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating S6a Server Activity");
                }
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating S6a Server Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating S6a Server Activity", (Throwable)e);
            }
            S6aServerSessionImpl activity = new S6aServerSessionImpl(this.ra.s6aMessageFactory, this.ra.s6aAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), null, null, DiameterS6aResourceAdaptor.this.stack);
            DiameterS6aResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
            if (request != null) {
                switch (request.getCommandCode()) {
                    case 318: {
                        activity.fetchSessionData((DiameterMessage)new AuthenticationInformationRequestImpl((Message)request));
                        break;
                    }
                    case 316: {
                        activity.fetchSessionData((DiameterMessage)new UpdateLocationRequestImpl((Message)request));
                        break;
                    }
                    case 321: {
                        activity.fetchSessionData((DiameterMessage)new PurgeUERequestImpl((Message)request));
                        break;
                    }
                    case 323: {
                        activity.fetchSessionData((DiameterMessage)new NotifyRequestImpl((Message)request));
                    }
                }
                ((org.jdiameter.server.impl.app.s6a.S6aServerSessionImpl)session).processRequest(request);
            }
            return activity;
        }

        private DiameterActivity createS6aClientSessionActivity(Request request) throws CreateActivityException {
            ClientS6aSession session = null;
            try {
                String sessionId = request == null ? null : request.getSessionId();
                ApplicationId appId = request.getApplicationIdAvps().isEmpty() ? null : (ApplicationId)request.getApplicationIdAvps().iterator().next();
                session = (ClientS6aSession)((ISessionFactory)DiameterS6aResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(sessionId, appId, ClientS6aSession.class, new Object[]{request});
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating S6a Client Activity");
                }
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating S6a Client Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating S6a Client Activity", (Throwable)e);
            }
            S6aClientSessionImpl activity = new S6aClientSessionImpl(this.ra.s6aMessageFactory, this.ra.s6aAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), null, null, DiameterS6aResourceAdaptor.this.stack);
            DiameterS6aResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
            if (request != null) {
                switch (request.getCommandCode()) {
                    case 317: {
                        activity.fetchSessionData((DiameterMessage)new CancelLocationRequestImpl((Message)request));
                        break;
                    }
                    case 319: {
                        activity.fetchSessionData((DiameterMessage)new InsertSubscriberDataRequestImpl((Message)request));
                        break;
                    }
                    case 320: {
                        activity.fetchSessionData((DiameterMessage)new DeleteSubscriberDataRequestImpl((Message)request));
                        break;
                    }
                    case 322: {
                        activity.fetchSessionData((DiameterMessage)new ResetRequestImpl((Message)request));
                    }
                }
                ((org.jdiameter.server.impl.app.s6a.S6aServerSessionImpl)session).processRequest(request);
            }
            return activity;
        }

        public S6aServerSessionActivity createS6aServerSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ServerS6aSession session = (ServerS6aSession)((ISessionFactory)DiameterS6aResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, ApplicationId.createByAuthAppId((long)10415L, (long)16777251L), ServerS6aSession.class);
                S6aServerSessionImpl activity = new S6aServerSessionImpl(this.ra.s6aMessageFactory, this.ra.s6aAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), destinationHost, destinationRealm, DiameterS6aResourceAdaptor.this.stack);
                DiameterS6aResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
                return activity;
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating S6a Server Activity", (Throwable)e);
            }
        }

        public S6aClientSessionActivity createS6aClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ClientS6aSession session = (ClientS6aSession)((ISessionFactory)DiameterS6aResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, ApplicationId.createByAuthAppId((long)10415L, (long)16777251L), ClientS6aSession.class);
                S6aClientSessionImpl activity = new S6aClientSessionImpl(this.ra.s6aMessageFactory, this.ra.s6aAvpFactory, session, (EventListener<Request, Answer>)((EventListener)session), destinationHost, destinationRealm, DiameterS6aResourceAdaptor.this.stack);
                DiameterS6aResourceAdaptor.this.addActivity((DiameterActivity)activity, false);
                return activity;
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating S6a Client Activity", (Throwable)e);
            }
        }

        public S6aMessageFactory getS6aMessageFactory() {
            return this.ra.s6aMessageFactory;
        }

        public S6aAVPFactory getS6aAVPFactory() {
            return this.ra.s6aAvpFactory;
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }

        public S6aServerSessionActivity createS6aServerSessionActivity() throws CreateActivityException {
            return this.createS6aServerSessionActivity(null, null);
        }

        public S6aClientSessionActivity createS6aClientSessionActivity() throws CreateActivityException {
            return this.createS6aClientSessionActivity(null, null);
        }

        public Validator getValidator() {
            return this.validator;
        }
    }
}

