/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.s6a;

import java.io.IOException;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.s6a.S6aAVPFactory;
import net.java.slee.resource.diameter.s6a.S6aClientSessionActivity;
import net.java.slee.resource.diameter.s6a.S6aMessageFactory;
import net.java.slee.resource.diameter.s6a.events.AuthenticationInformationRequest;
import net.java.slee.resource.diameter.s6a.events.CancelLocationAnswer;
import net.java.slee.resource.diameter.s6a.events.CancelLocationRequest;
import net.java.slee.resource.diameter.s6a.events.DeleteSubscriberDataAnswer;
import net.java.slee.resource.diameter.s6a.events.DeleteSubscriberDataRequest;
import net.java.slee.resource.diameter.s6a.events.InsertSubscriberDataAnswer;
import net.java.slee.resource.diameter.s6a.events.InsertSubscriberDataRequest;
import net.java.slee.resource.diameter.s6a.events.PurgeUERequest;
import net.java.slee.resource.diameter.s6a.events.ResetAnswer;
import net.java.slee.resource.diameter.s6a.events.ResetRequest;
import net.java.slee.resource.diameter.s6a.events.UpdateLocationRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.s6a.ClientS6aSession;
import org.jdiameter.api.s6a.events.JAuthenticationInformationRequest;
import org.jdiameter.api.s6a.events.JCancelLocationAnswer;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JPurgeUERequest;
import org.jdiameter.api.s6a.events.JResetAnswer;
import org.jdiameter.api.s6a.events.JUpdateLocationRequest;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.s6a.S6aSessionState;
import org.jdiameter.common.impl.app.s6a.JAuthenticationInformationRequestImpl;
import org.jdiameter.common.impl.app.s6a.JCancelLocationAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JDeleteSubscriberDataAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JInsertSubscriberDataAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JPurgeUERequestImpl;
import org.jdiameter.common.impl.app.s6a.JResetAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JUpdateLocationRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.s6a.S6aMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.s6a.S6aSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S6aClientSessionImpl
extends S6aSessionImpl
implements S6aClientSessionActivity {
    private static final long serialVersionUID = 7518916596996009148L;
    protected transient ClientS6aSession appSession;

    public S6aClientSessionImpl(S6aMessageFactory s6aMessageFactory, S6aAVPFactory s6aAvpFactory, ClientS6aSession session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(s6aMessageFactory, s6aAvpFactory, (Session)session.getSessions().get(0), raEventListener, destinationHost, destinationRealm);
        this.setSession(session);
    }

    public void setSession(ClientS6aSession session) {
        this.appSession = session;
        this.appSession.addStateChangeNotification((StateChangeListener)this);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (!(this.terminated || newState != S6aSessionState.TERMINATED && newState != S6aSessionState.TIMEDOUT)) {
            this.terminated = true;
            this.endActivity();
        }
    }

    public void stateChanged(AppSession appSession, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void endActivity() {
        if (this.appSession != null) {
            this.appSession.release();
        }
        try {
            this.baseListener.endActivity(this.getActivityHandle());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to end activity [" + (Object)((Object)this) + "]."), (Throwable)e);
        }
    }

    public void sendUpdateLocationRequest(UpdateLocationRequest ulr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)ulr;
        JUpdateLocationRequestImpl answer = new JUpdateLocationRequestImpl((Message)((Request)msg.getGenericData()));
        try {
            this.appSession.sendUpdateLocationRequest((JUpdateLocationRequest)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendAuthenticationInformationRequest(AuthenticationInformationRequest air) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)air;
        JAuthenticationInformationRequestImpl answer = new JAuthenticationInformationRequestImpl((Message)((Request)msg.getGenericData()));
        try {
            this.appSession.sendAuthenticationInformationRequest((JAuthenticationInformationRequest)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public CancelLocationAnswer createCancelLocationAnswer() {
        if (!(this.lastRequest instanceof CancelLocationRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            CancelLocationAnswer cla = (CancelLocationAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 317, S6aMessageFactoryImpl.s6aAppId);
            this.fillSessionAVPs((DiameterMessage)cla);
            return cla;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Cancel-Location-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendCancelLocationAnswer(CancelLocationAnswer cla) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)cla;
        JCancelLocationAnswerImpl request = new JCancelLocationAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendCancelLocationAnswer((JCancelLocationAnswer)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public InsertSubscriberDataAnswer createInsertSubscriberDataAnswer() {
        if (!(this.lastRequest instanceof InsertSubscriberDataRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            InsertSubscriberDataAnswer ida = (InsertSubscriberDataAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 319, S6aMessageFactoryImpl.s6aAppId);
            this.fillSessionAVPs((DiameterMessage)ida);
            return ida;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Insert-Subscriber-Data-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendInsertSubscriberDataAnswer(InsertSubscriberDataAnswer ida) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)ida;
        JInsertSubscriberDataAnswerImpl request = new JInsertSubscriberDataAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendInsertSubscriberDataAnswer((JInsertSubscriberDataAnswer)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public DeleteSubscriberDataAnswer createDeleteSubscriberDataAnswer() {
        if (!(this.lastRequest instanceof DeleteSubscriberDataRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            DeleteSubscriberDataAnswer dsa = (DeleteSubscriberDataAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 320, S6aMessageFactoryImpl.s6aAppId);
            this.fillSessionAVPs((DiameterMessage)dsa);
            return dsa;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Delete-Subscriber-Data-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendDeleteSubscriberDataAnswer(DeleteSubscriberDataAnswer dsa) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)dsa;
        JDeleteSubscriberDataAnswerImpl request = new JDeleteSubscriberDataAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendDeleteSubscriberDataAnswer((JDeleteSubscriberDataAnswer)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendPurgeUERequest(PurgeUERequest pur) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)pur;
        JPurgeUERequestImpl answer = new JPurgeUERequestImpl((Message)((Request)msg.getGenericData()));
        try {
            this.appSession.sendPurgeUERequest((JPurgeUERequest)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public ResetAnswer createResetAnswer() {
        if (!(this.lastRequest instanceof ResetRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            ResetAnswer rsa = (ResetAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 322, S6aMessageFactoryImpl.s6aAppId);
            this.fillSessionAVPs((DiameterMessage)rsa);
            return rsa;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Reset-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendResetAnswer(ResetAnswer rsa) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)rsa;
        JResetAnswerImpl request = new JResetAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendResetAnswer((JResetAnswer)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }
}

