/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.s6a.handlers;

import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.s6a.ClientS6aSession;
import org.jdiameter.api.s6a.ServerS6aSession;
import org.jdiameter.api.s6a.events.JAuthenticationInformationAnswer;
import org.jdiameter.api.s6a.events.JAuthenticationInformationRequest;
import org.jdiameter.api.s6a.events.JCancelLocationAnswer;
import org.jdiameter.api.s6a.events.JCancelLocationRequest;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JNotifyAnswer;
import org.jdiameter.api.s6a.events.JNotifyRequest;
import org.jdiameter.api.s6a.events.JPurgeUEAnswer;
import org.jdiameter.api.s6a.events.JPurgeUERequest;
import org.jdiameter.api.s6a.events.JResetAnswer;
import org.jdiameter.api.s6a.events.JResetRequest;
import org.jdiameter.api.s6a.events.JUpdateLocationAnswer;
import org.jdiameter.api.s6a.events.JUpdateLocationRequest;
import org.jdiameter.client.impl.app.s6a.S6aClientSessionImpl;
import org.jdiameter.common.impl.app.s6a.S6aSessionFactoryImpl;
import org.jdiameter.server.impl.app.s6a.S6aServerSessionImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S6aSessionFactory
extends S6aSessionFactoryImpl {
    private DiameterRAInterface s6aResourceAdaptor;
    private static final Logger logger = Logger.getLogger(S6aSessionFactory.class);

    public S6aSessionFactory(DiameterRAInterface s6aResourceAdaptor, long messageTimeout, SessionFactory sessionFactory) {
        super(sessionFactory);
        this.s6aResourceAdaptor = s6aResourceAdaptor;
    }

    public AppSession getNewSession(String sessionId, Class<? extends AppSession> appSessionClass, ApplicationId applicationId, Object[] args) {
        S6aServerSessionImpl appSession = null;
        if (appSessionClass == ServerS6aSession.class) {
            S6aServerSessionImpl serverSession = null;
            appSession = serverSession = (S6aServerSessionImpl)super.getNewSession(sessionId, appSessionClass, applicationId, args);
        } else if (appSessionClass == ClientS6aSession.class) {
            S6aClientSessionImpl clientSession = null;
            clientSession = (S6aClientSessionImpl)super.getNewSession(sessionId, appSessionClass, applicationId, args);
            appSession = clientSession;
        } else {
            throw new IllegalArgumentException("Wrong session class: [" + appSessionClass + "]. Supported[" + ServerS6aSession.class + "," + ClientS6aSession.class + "]");
        }
        return appSession;
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent(appSession, answer != null ? answer.getMessage() : request.getMessage());
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info((Object)("Diameter S6a Session Factory :: stateChanged :: source[" + source + "] :: oldState[" + oldState + "], newState[" + newState + "]"));
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info((Object)("Diameter S6a Session Factory :: stateChanged :: oldState[" + oldState + "], newState[" + newState + "]"));
    }

    public long getApplicationId() {
        return 16777251L;
    }

    private void doFireEvent(AppSession appSession, Message message) {
        this.s6aResourceAdaptor.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), message);
    }

    public void doUpdateLocationRequestEvent(ServerS6aSession appSession, JUpdateLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doUpdateLocationRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doUpdateLocationAnswerEvent(ClientS6aSession appSession, JUpdateLocationRequest request, JUpdateLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doUpdateLocationAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doAuthenticationInformationRequestEvent(ServerS6aSession appSession, JAuthenticationInformationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doAuthenticationInformationRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doAuthenticationInformationAnswerEvent(ClientS6aSession appSession, JAuthenticationInformationRequest request, JAuthenticationInformationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doAuthenticationInformationAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doCancelLocationRequestEvent(ClientS6aSession appSession, JCancelLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doCancelLocationRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doCancelLocationAnswerEvent(ServerS6aSession appSession, JCancelLocationRequest request, JCancelLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doCancelLocationAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doInsertSubscriberDataRequestEvent(ClientS6aSession appSession, JInsertSubscriberDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doInsertSubscriberDataRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doInsertSubscriberDataAnswerEvent(ServerS6aSession appSession, JInsertSubscriberDataRequest request, JInsertSubscriberDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doInsertSubscriberDataAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doDeleteSubscriberDataRequestEvent(ClientS6aSession appSession, JDeleteSubscriberDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doDeleteSubscriberDataRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doDeleteSubscriberDataAnswerEvent(ServerS6aSession appSession, JDeleteSubscriberDataRequest request, JDeleteSubscriberDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doDeleteSubscriberDataAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doPurgeUERequestEvent(ServerS6aSession appSession, JPurgeUERequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doPurgeUERequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doPurgeUEAnswerEvent(ClientS6aSession appSession, JPurgeUERequest request, JPurgeUEAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doPurgeUEAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doResetRequestEvent(ClientS6aSession appSession, JResetRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doResetRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doResetAnswerEvent(ServerS6aSession appSession, JResetRequest request, JResetAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doResetAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }

    public void doNotifyRequestEvent(ServerS6aSession appSession, JNotifyRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doNotifyRequest :: appSession[" + appSession + "], Request[" + request + "]"));
        this.doFireEvent((AppSession)appSession, request.getMessage());
    }

    public void doNotifyAnswerEvent(ClientS6aSession appSession, JNotifyRequest request, JNotifyAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info((Object)("Diameter S6a Session Factory :: doNotifyAnswer :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
        this.doFireEvent((AppSession)appSession, answer.getMessage());
    }
}

