/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.s6a;

import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.s6a.S6aMessageFactory;
import net.java.slee.resource.diameter.s6a.events.AuthenticationInformationRequest;
import net.java.slee.resource.diameter.s6a.events.CancelLocationRequest;
import net.java.slee.resource.diameter.s6a.events.DeleteSubscriberDataRequest;
import net.java.slee.resource.diameter.s6a.events.InsertSubscriberDataRequest;
import net.java.slee.resource.diameter.s6a.events.NotifyRequest;
import net.java.slee.resource.diameter.s6a.events.PurgeUERequest;
import net.java.slee.resource.diameter.s6a.events.ResetRequest;
import net.java.slee.resource.diameter.s6a.events.UpdateLocationRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.s6a.events.AuthenticationInformationAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.AuthenticationInformationRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.CancelLocationAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.CancelLocationRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.DeleteSubscriberDataAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.DeleteSubscriberDataRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.InsertSubscriberDataAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.InsertSubscriberDataRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.NotifyAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.NotifyRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.PurgeUEAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.PurgeUERequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.ResetAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.ResetRequestImpl;
import org.mobicents.slee.resource.diameter.s6a.events.UpdateLocationAnswerImpl;
import org.mobicents.slee.resource.diameter.s6a.events.UpdateLocationRequestImpl;

public class S6aMessageFactoryImpl
extends DiameterMessageFactoryImpl
implements S6aMessageFactory {
    private static Logger logger = Logger.getLogger(S6aMessageFactoryImpl.class);
    private DiameterAvp[] EMPTY_AVP_ARRAY = new DiameterAvp[0];
    private ApplicationId s6aAppId = ApplicationId.createByAuthAppId((long)10415L, (long)16777251L);

    public S6aMessageFactoryImpl(Session session, Stack stack, DiameterIdentity ... avps) {
        super(session, stack, avps);
    }

    public S6aMessageFactoryImpl(Stack stack) {
        super(stack);
    }

    public void setApplicationId(long vendorId, long applicationId) {
        this.s6aAppId = ApplicationId.createByAuthAppId((long)vendorId, (long)applicationId);
    }

    public ApplicationId getApplicationId() {
        return this.s6aAppId;
    }

    DiameterMessage createS6aMessage(DiameterHeader diameterHeader, DiameterAvp[] avps, int _commandCode, ApplicationId appId) throws InternalException {
        Message raw;
        boolean creatingRequest = diameterHeader == null;
        Message msg = null;
        if (!creatingRequest) {
            raw = this.createMessage(diameterHeader, avps, 0, appId);
            raw.setProxiable(diameterHeader.isProxiable());
            raw.setRequest(false);
            raw.setReTransmitted(false);
            msg = raw;
        } else {
            raw = this.createMessage(diameterHeader, avps, _commandCode, appId);
            raw.setProxiable(true);
            raw.setRequest(true);
            msg = raw;
        }
        int commandCode = creatingRequest ? _commandCode : diameterHeader.getCommandCode();
        ExtensionDiameterMessageImpl diamMessage = null;
        switch (commandCode) {
            case 316: {
                diamMessage = creatingRequest ? new UpdateLocationRequestImpl(msg) : new UpdateLocationAnswerImpl(msg);
                break;
            }
            case 318: {
                diamMessage = creatingRequest ? new AuthenticationInformationRequestImpl(msg) : new AuthenticationInformationAnswerImpl(msg);
                break;
            }
            case 317: {
                diamMessage = creatingRequest ? new CancelLocationRequestImpl(msg) : new CancelLocationAnswerImpl(msg);
                break;
            }
            case 319: {
                diamMessage = creatingRequest ? new InsertSubscriberDataRequestImpl(msg) : new InsertSubscriberDataAnswerImpl(msg);
                break;
            }
            case 320: {
                diamMessage = creatingRequest ? new DeleteSubscriberDataRequestImpl(msg) : new DeleteSubscriberDataAnswerImpl(msg);
                break;
            }
            case 321: {
                diamMessage = creatingRequest ? new PurgeUERequestImpl(msg) : new PurgeUEAnswerImpl(msg);
                break;
            }
            case 322: {
                diamMessage = creatingRequest ? new ResetRequestImpl(msg) : new ResetAnswerImpl(msg);
                break;
            }
            case 323: {
                diamMessage = creatingRequest ? new NotifyRequestImpl(msg) : new NotifyAnswerImpl(msg);
                break;
            }
            default: {
                diamMessage = new ExtensionDiameterMessageImpl(msg);
            }
        }
        if (!diamMessage.hasSessionId() && this.session != null) {
            diamMessage.setSessionId(this.session.getSessionId());
        }
        return diamMessage;
    }

    public AuthenticationInformationRequest createAuthenticationInformationRequest() {
        try {
            return (AuthenticationInformationRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 318, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Authentication-Information-Request", (Throwable)e);
            return null;
        }
    }

    public AuthenticationInformationRequest createAuthenticationInformationRequest(String sessionId) throws IllegalArgumentException {
        AuthenticationInformationRequest uar = this.createAuthenticationInformationRequest();
        uar.setSessionId(sessionId);
        return uar;
    }

    public CancelLocationRequest createCancelLocationRequest() {
        try {
            return (CancelLocationRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 317, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Cancel-Location-Request", (Throwable)e);
            return null;
        }
    }

    public CancelLocationRequest createCancelLocationRequest(String sessionId) throws IllegalArgumentException {
        CancelLocationRequest clr = this.createCancelLocationRequest();
        clr.setSessionId(sessionId);
        return clr;
    }

    public PurgeUERequest createPurgeUERequest() {
        try {
            return (PurgeUERequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 321, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Purge-UE-Request", (Throwable)e);
            return null;
        }
    }

    public PurgeUERequest createPurgeUERequest(String sessionId) throws IllegalArgumentException {
        PurgeUERequest uar = this.createPurgeUERequest();
        uar.setSessionId(sessionId);
        return uar;
    }

    public UpdateLocationRequest createUpdateLocationRequest() {
        try {
            return (UpdateLocationRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 316, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Update-Location-Request", (Throwable)e);
            return null;
        }
    }

    public UpdateLocationRequest createUpdateLocationRequest(String sessionId) throws IllegalArgumentException {
        UpdateLocationRequest uar = this.createUpdateLocationRequest();
        uar.setSessionId(sessionId);
        return uar;
    }

    public InsertSubscriberDataRequest createInsertSubscriberDataRequest() {
        try {
            return (InsertSubscriberDataRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 319, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Insert-Subscriber-Data-Request", (Throwable)e);
            return null;
        }
    }

    public InsertSubscriberDataRequest createInsertSubscriberDataRequest(String sessionId) throws IllegalArgumentException {
        InsertSubscriberDataRequest idr = this.createInsertSubscriberDataRequest();
        idr.setSessionId(sessionId);
        return idr;
    }

    public DeleteSubscriberDataRequest createDeleteSubscriberDataRequest() {
        try {
            return (DeleteSubscriberDataRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 320, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Delete-Subscriber-Data-Request", (Throwable)e);
            return null;
        }
    }

    public DeleteSubscriberDataRequest createDeleteSubscriberDataRequest(String sessionId) throws IllegalArgumentException {
        DeleteSubscriberDataRequest dsr = this.createDeleteSubscriberDataRequest();
        dsr.setSessionId(sessionId);
        return dsr;
    }

    public ResetRequest createResetRequest() {
        try {
            return (ResetRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 322, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Reset-Request", (Throwable)e);
            return null;
        }
    }

    public ResetRequest createResetRequest(String sessionId) throws IllegalArgumentException {
        ResetRequest rsr = this.createResetRequest();
        rsr.setSessionId(sessionId);
        return rsr;
    }

    public NotifyRequest createNotifyRequest() {
        try {
            return (NotifyRequest)this.createS6aMessage(null, this.EMPTY_AVP_ARRAY, 323, this.s6aAppId);
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Notify-Request", (Throwable)e);
            return null;
        }
    }

    public NotifyRequest createNotifyRequest(String sessionId) throws IllegalArgumentException {
        NotifyRequest nor = this.createNotifyRequest();
        nor.setSessionId(sessionId);
        return nor;
    }
}

