/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.s6a;

import java.io.IOException;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.s6a.S6aAVPFactory;
import net.java.slee.resource.diameter.s6a.S6aMessageFactory;
import net.java.slee.resource.diameter.s6a.S6aServerSessionActivity;
import net.java.slee.resource.diameter.s6a.events.AuthenticationInformationAnswer;
import net.java.slee.resource.diameter.s6a.events.AuthenticationInformationRequest;
import net.java.slee.resource.diameter.s6a.events.CancelLocationRequest;
import net.java.slee.resource.diameter.s6a.events.DeleteSubscriberDataRequest;
import net.java.slee.resource.diameter.s6a.events.InsertSubscriberDataRequest;
import net.java.slee.resource.diameter.s6a.events.NotifyAnswer;
import net.java.slee.resource.diameter.s6a.events.NotifyRequest;
import net.java.slee.resource.diameter.s6a.events.PurgeUEAnswer;
import net.java.slee.resource.diameter.s6a.events.PurgeUERequest;
import net.java.slee.resource.diameter.s6a.events.ResetRequest;
import net.java.slee.resource.diameter.s6a.events.UpdateLocationAnswer;
import net.java.slee.resource.diameter.s6a.events.UpdateLocationRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.s6a.ServerS6aSession;
import org.jdiameter.api.s6a.events.JAuthenticationInformationAnswer;
import org.jdiameter.api.s6a.events.JCancelLocationRequest;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JNotifyAnswer;
import org.jdiameter.api.s6a.events.JPurgeUEAnswer;
import org.jdiameter.api.s6a.events.JResetRequest;
import org.jdiameter.api.s6a.events.JUpdateLocationAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.s6a.S6aSessionState;
import org.jdiameter.common.impl.app.s6a.JAuthenticationInformationAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JCancelLocationRequestImpl;
import org.jdiameter.common.impl.app.s6a.JDeleteSubscriberDataRequestImpl;
import org.jdiameter.common.impl.app.s6a.JInsertSubscriberDataRequestImpl;
import org.jdiameter.common.impl.app.s6a.JNotifyAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JPurgeUEAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JResetRequestImpl;
import org.jdiameter.common.impl.app.s6a.JUpdateLocationAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.s6a.S6aSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S6aServerSessionImpl
extends S6aSessionImpl
implements S6aServerSessionActivity {
    private static final long serialVersionUID = 7518916596996009148L;
    protected transient ServerS6aSession appSession;

    public S6aServerSessionImpl(S6aMessageFactory s6aMessageFactory, S6aAVPFactory s6aAvpFactory, ServerS6aSession session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(s6aMessageFactory, s6aAvpFactory, (Session)session.getSessions().get(0), raEventListener, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)session.getSessions().get(0));
    }

    public void setSession(ServerS6aSession session) {
        this.appSession = session;
        this.appSession.addStateChangeNotification((StateChangeListener)this);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (!(this.terminated || newState != S6aSessionState.TERMINATED && newState != S6aSessionState.TIMEDOUT)) {
            this.terminated = true;
            this.endActivity();
        }
    }

    public void stateChanged(AppSession appSession, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void endActivity() {
        if (this.appSession != null) {
            this.appSession.release();
        }
        try {
            this.baseListener.endActivity(this.getActivityHandle());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to end activity [" + (Object)((Object)this) + "]."), (Throwable)e);
        }
    }

    public AuthenticationInformationAnswer createAuthenticationInformationAnswer() {
        if (!(this.lastRequest instanceof AuthenticationInformationRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            AuthenticationInformationAnswer aia = (AuthenticationInformationAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 318, this.s6aMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)aia);
            return aia;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Authentication-Information-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendAuthenticationInformationAnswer(AuthenticationInformationAnswer aia) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)aia;
        JAuthenticationInformationAnswerImpl answer = new JAuthenticationInformationAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendAuthenticationInformationAnswer((JAuthenticationInformationAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public PurgeUEAnswer createPurgeUEAnswer() {
        if (!(this.lastRequest instanceof PurgeUERequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            PurgeUEAnswer aia = (PurgeUEAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 321, this.s6aMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)aia);
            return aia;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Purge-UE-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendPurgeUEAnswer(PurgeUEAnswer pua) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)pua;
        JPurgeUEAnswerImpl answer = new JPurgeUEAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendPurgeUEAnswer((JPurgeUEAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public UpdateLocationAnswer createUpdateLocationAnswer() {
        if (!(this.lastRequest instanceof UpdateLocationRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            UpdateLocationAnswer aia = (UpdateLocationAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 316, this.s6aMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)aia);
            return aia;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Update-Location-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendUpdateLocationAnswer(UpdateLocationAnswer ula) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)ula;
        JUpdateLocationAnswerImpl answer = new JUpdateLocationAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendUpdateLocationAnswer((JUpdateLocationAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendCancelLocationRequest(CancelLocationRequest clr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)clr;
        JCancelLocationRequestImpl request = new JCancelLocationRequestImpl((Message)((Answer)msg.getGenericData()));
        try {
            this.appSession.sendCancelLocationRequest((JCancelLocationRequest)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendInsertSubscriberDataRequest(InsertSubscriberDataRequest idr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)idr;
        JInsertSubscriberDataRequestImpl request = new JInsertSubscriberDataRequestImpl((Message)((Answer)msg.getGenericData()));
        try {
            this.appSession.sendInsertSubscriberDataRequest((JInsertSubscriberDataRequest)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendDeleteSubscriberDataRequest(DeleteSubscriberDataRequest dsr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)dsr;
        JDeleteSubscriberDataRequestImpl request = new JDeleteSubscriberDataRequestImpl((Message)((Answer)msg.getGenericData()));
        try {
            this.appSession.sendDeleteSubscriberDataRequest((JDeleteSubscriberDataRequest)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public void sendResetRequest(ResetRequest rsr) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)rsr;
        JResetRequestImpl request = new JResetRequestImpl((Message)((Answer)msg.getGenericData()));
        try {
            this.appSession.sendResetRequest((JResetRequest)request);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }

    public NotifyAnswer createNotifyAnswer() {
        if (!(this.lastRequest instanceof NotifyRequest)) {
            logger.warn((Object)"Invalid type of answer for this activity.");
            return null;
        }
        try {
            NotifyAnswer aia = (NotifyAnswer)this.s6aMessageFactory.createS6aMessage(this.lastRequest.getHeader(), new DiameterAvp[0], 323, this.s6aMessageFactory.getApplicationId());
            this.fillSessionAVPs((DiameterMessage)aia);
            return aia;
        }
        catch (InternalException e) {
            logger.error((Object)"Failed to create Notify-Answer.", (Throwable)e);
            return null;
        }
    }

    public void sendNotifyAnswer(NotifyAnswer ula) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)ula;
        JNotifyAnswerImpl answer = new JNotifyAnswerImpl((Answer)msg.getGenericData());
        try {
            this.appSession.sendNotifyAnswer((JNotifyAnswer)answer);
        }
        catch (AvpNotAllowedException anae) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException(anae.getMessage(), anae.getAvpCode(), anae.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }
}

