/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivity;
import net.java.slee.resource.diameter.sh.client.ShClientActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientProvider;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer;
import net.java.slee.resource.diameter.sh.server.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.server.events.UserDataRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.ClientShSessionListener;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.sh.ShClientSessionImpl;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.DiameterShAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.ShClientActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.ShClientActivityImpl;
import org.mobicents.slee.resource.diameter.sh.client.ShClientMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.ShClientSubscriptionActivityImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.ProfileUpdateAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.PushNotificationRequestImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.UserDataAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.handlers.ShClientSessionListener;
import org.mobicents.slee.resource.diameter.sh.server.events.ProfileUpdateRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.PushNotificationAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.UserDataRequestImpl;

public class DiameterShClientResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
ShClientSessionListener {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger(DiameterShClientResourceAdaptor.class);
    private Stack stack;
    private SessionFactory sessionFactory = null;
    private long messageTimeout = 5000L;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private ResourceAdaptorState state;
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private static final Map<Integer, String> events;
    private transient ShClientProviderImpl clientProvider = null;
    private transient ConcurrentHashMap<ActivityHandle, DiameterActivity> activities = null;
    private transient ShClientActivityContextInterfaceFactory acif = null;
    private DiameterAvpFactoryImpl diameterAvpFactory = new DiameterAvpFactoryImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        logger.info((Object)("Diameter ShClient RA :: activityEnded :: handle[" + handle + "."));
        if (this.activities != null) {
            ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
            synchronized (concurrentHashMap) {
                this.activities.remove(handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        logger.info((Object)("Diameter ShClient RA :: activityUnreferenced :: handle[" + handle + "]."));
        this.activityEnded(handle);
    }

    public void entityActivated() throws ResourceException {
        logger.info((Object)"Diameter ShClient RA :: entityActivated.");
        try {
            logger.info((Object)"Activating Diameter ShClient RA Entity");
            this.initializeNamingContext();
            this.activities = new ConcurrentHashMap();
            this.state = ResourceAdaptorState.CONFIGURED;
        }
        catch (Exception e) {
            logger.error((Object)"Error Configuring Diameter ShClient RA Entity", (Throwable)e);
        }
        try {
            ObjectName diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            String operation = "getMultiplexerMBean";
            Object object = SleeContainer.lookupFromJndi().getMBeanServer().invoke(diameterMultiplexerObjectName, operation, params, signature);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.state = ResourceAdaptorState.ACTIVE;
            this.sessionFactory = this.stack.getSessionFactory();
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientShSession.class, (IAppSessionFactory)new ShClientSessionFactory(this));
        }
        catch (Exception e) {
            logger.error((Object)"Error Activating Diameter ShClient RA Entity", (Throwable)e);
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.info((Object)("Diameter ShClient RA :: entityCreated :: bootstrapContext[" + bootstrapContext + "]."));
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityDeactivated() {
        logger.info((Object)"Diameter ShClient RA :: entityDeactivated.");
        logger.info((Object)"Diameter ShClient RA :: Cleaning RA Activities.");
        ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            this.activities.clear();
        }
        this.activities = null;
        logger.info((Object)"Diameter ShClient RA :: Cleaning naming context.");
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Diameter ShClient RA :: Cannot unbind naming context.", (Throwable)e);
        }
        logger.info((Object)"Diameter ShClient RA :: RA Stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityDeactivating() {
        logger.info((Object)"Diameter ShClient RA :: entityDeactivating.");
        this.state = ResourceAdaptorState.STOPPING;
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to unregister ShClient RA from Diameter Mux.", (Throwable)e);
        }
        ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            for (ActivityHandle activityHandle : this.activities.keySet()) {
                try {
                    logger.info((Object)("Ending activity [" + activityHandle + "]"));
                    this.activities.get(activityHandle).endActivity();
                }
                catch (Exception e) {
                    logger.error((Object)"Error Deactivating Activity", (Throwable)e);
                }
            }
        }
        logger.info((Object)"Diameter ShClient RA :: entityDeactivating completed.");
    }

    public void entityRemoved() {
        this.acif = null;
        this.activities = null;
        this.bootstrapContext = null;
        this.eventLookup = null;
        this.sleeEndpoint = null;
        this.stack = null;
        logger.info((Object)"Diameter ShClient RA :: entityRemoved.");
    }

    private void initializeNamingContext() throws NamingException {
        ResourceAdaptorEntity resourceAdaptorEntity;
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        try {
            resourceAdaptorEntity = container.getResourceAdaptorEntity(entityName);
        }
        catch (UnrecognizedResourceAdaptorEntityException uraee) {
            throw new NamingException("Failure setting up Naming Context. RA Entity not found.");
        }
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new ShClientActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.info((Object)("Diameter ShClient RA :: Registering in JNDI :: Prefix[" + prefix + "], Name[" + name + "]."));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
                logger.info((Object)"Diameter ShClient RA :: Registered in JNDI successfully.");
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.info((Object)"Failure initializing name context.", (Throwable)iobe);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.info((Object)("Diameter ShClient RA :: Unregistering from JNDI :: Name[" + javaJNDIName + "]."));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.info((Object)"Diameter ShClient RA :: Unregistered from JNDI successfully.");
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.error((Object)"Failure cleaning name context.", (Throwable)iobe);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, new ApplicationId[]{ApplicationId.createByAuthAppId((long)10415L, (long)0x1000001L)});
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        this.clientProvider = new ShClientProviderImpl(this);
        logger.info((Object)"Diameter ShClient RA :: Successfully initialized stack.");
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int eventID, Address address, int flags, FailureReason reason) {
        logger.info((Object)("Diameter ShClient RA :: eventProcessingFailed :: handle[" + handle + "], event[" + event + "], eventID[" + eventID + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "]."));
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int eventID, Address address, int flags) {
        logger.info((Object)("Diameter ShClient RA :: eventProcessingSuccessful :: handle[" + handle + "], event[" + event + "], eventID[" + eventID + "], address[" + address + "], flags[" + flags + "]."));
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        logger.info((Object)("Diameter ShClient RA :: getActivityHandle :: activity[" + activity + "]."));
        if (!(activity instanceof DiameterActivity)) {
            logger.warn((Object)"Diameter ShClient RA :: getActivityHandle :: Invalid Activity passed (not instanceof DiameterActivity).");
            return null;
        }
        DiameterActivity inActivity = (DiameterActivity)activity;
        for (Map.Entry<ActivityHandle, DiameterActivity> activityInfo : this.activities.entrySet()) {
            DiameterActivity curActivity = activityInfo.getValue();
            if (!curActivity.equals(inActivity)) continue;
            return activityInfo.getKey();
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String className) {
        return this.clientProvider;
    }

    public Answer processRequest(Request request) {
        try {
            this.clientProvider.createActivity((Message)request);
        }
        catch (CreateActivityException e) {
            logger.error((Object)"Failed creating activity to process request.", (Throwable)e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request req, Answer ans) {
        logger.info((Object)("Diameter ShClient RA :: receivedSuccessMessage :: Request[" + req + "], Answer[" + ans + "]."));
        try {
            logger.info((Object)("Received Message Result-Code: " + ans.getResultCode().getUnsigned32()));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request req) {
        logger.info((Object)("Diameter Base RA :: timeoutExpired :: Request[" + req + "]."));
        DiameterActivityHandle ah = new DiameterActivityHandle(req.getSessionId());
        try {
            this.activities.get(ah).endActivity();
        }
        catch (Exception e) {
            logger.error((Object)"Failure processing timeout message.", (Throwable)e);
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                logger.error((Object)"Failure getting peer list.", (Throwable)e);
            }
        }
        return null;
    }

    public void fireEvent(ActivityHandle handle, String name, Request request, Answer answer) {
        try {
            int eventID = this.eventLookup.getEventID(name, "java.net", "0.8");
            DiameterMessage event = this.createEvent(request, answer);
            this.sleeEndpoint.fireEvent(handle, (Object)event, eventID, null);
        }
        catch (Exception e) {
            logger.error((Object)"Can not send event", (Throwable)e);
        }
    }

    public DiameterMessage createEvent(Request request, Answer answer) throws OperationNotSupportedException {
        int commandCode;
        if (request == null && answer == null) {
            return null;
        }
        int n = commandCode = request != null ? request.getCommandCode() : answer.getCommandCode();
        if (answer != null && answer.isError()) {
            return new ErrorAnswerImpl((Message)answer);
        }
        switch (commandCode) {
            case 309: {
                return request != null ? new PushNotificationRequestImpl((Message)request) : new PushNotificationAnswerImpl((Message)answer);
            }
            case 307: {
                return request != null ? new ProfileUpdateRequestImpl((Message)request) : new ProfileUpdateAnswerImpl((Message)answer);
            }
            case 308: {
                return request != null ? new SubscribeNotificationsRequestImpl((Message)request) : new SubscribeNotificationsAnswerImpl((Message)answer);
            }
            case 306: {
                return request != null ? new UserDataRequestImpl((Message)request) : new UserDataAnswerImpl((Message)answer);
            }
        }
        return new ExtensionDiameterMessageImpl((Message)(request != null ? request : answer));
    }

    private void activityCreated(DiameterActivity ac) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            this.sleeEndpoint.activityStarted((ActivityHandle)activity.getActivityHandle());
            this.activities.put((ActivityHandle)activity.getActivityHandle(), (DiameterActivity)activity);
            logger.info((Object)("Activity started [" + activity.getActivityHandle() + "]"));
        }
        catch (Exception e) {
            logger.error((Object)"Error creating/starting activity.", (Throwable)e);
        }
    }

    public void queryLiveness(ActivityHandle handle) {
    }

    public void serviceActivated(String serviceKey) {
    }

    public void serviceDeactivated(String serviceKey) {
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] resourceOptions) {
    }

    public void serviceUninstalled(String serviceKey) {
    }

    public void sessionDestroyed(String sessionId, ClientShSession session) {
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to end activity with handle[" + this.getActivityHandle(sessionId)));
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    static {
        HashMap<Integer, String> eventsTemp = new HashMap<Integer, String>();
        eventsTemp.put(307, "ProfileUpdate");
        eventsTemp.put(309, "PushNotification");
        eventsTemp.put(306, "UserData");
        eventsTemp.put(308, "SubscribeNotifications");
        events = Collections.unmodifiableMap(eventsTemp);
    }

    private class ShClientProviderImpl
    implements ShClientProvider {
        DiameterShClientResourceAdaptor ra = null;

        public ShClientProviderImpl(DiameterShClientResourceAdaptor ra) {
            this.ra = ra;
        }

        DiameterActivity createActivity(Message message) throws CreateActivityException {
            String sessionId = message.getSessionId();
            DiameterActivityHandle handle = new DiameterActivityHandle(sessionId);
            if (DiameterShClientResourceAdaptor.this.activities.keySet().contains(handle)) {
                return (DiameterActivity)DiameterShClientResourceAdaptor.this.activities.get(handle);
            }
            if (message.getCommandCode() != 309) {
                throw new CreateActivityException("Cant create activity for unexpected message:\r\n" + message);
            }
            ShClientSubscriptionActivityImpl activity = (ShClientSubscriptionActivityImpl)this.createShClientSubscriptionActivity((net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest)new PushNotificationRequestImpl(message));
            return activity;
        }

        private ShClientSubscriptionActivity createShClientSubscriptionActivity(net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest pushNotificationRequest) {
            ClientShSession session = null;
            try {
                session = (ClientShSession)((ISessionFactory)DiameterShClientResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, null, ClientShSession.class, null);
                if (session == null) {
                    logger.error((Object)"Failure creating Sh-Client Subscription Session (null).");
                    return null;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure creating Sh-Client Subscription Session.", (Throwable)e);
                return null;
            }
            DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack, new DiameterIdentity[]{null, null});
            ShClientSubscriptionActivityImpl activity = new ShClientSubscriptionActivityImpl(msgFactory, new ShClientMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack), DiameterShClientResourceAdaptor.this.diameterAvpFactory, (DiameterShAvpFactory)new DiameterShAvpFactoryImpl((DiameterAvpFactory)DiameterShClientResourceAdaptor.this.diameterAvpFactory), session, DiameterShClientResourceAdaptor.this.messageTimeout, null, null, DiameterShClientResourceAdaptor.this.sleeEndpoint);
            activity.fetchSessionData((DiameterMessage)pushNotificationRequest, true);
            activity.setSessionListener(this.ra);
            DiameterShClientResourceAdaptor.this.activityCreated((DiameterActivity)activity);
            ((ShClientSessionImpl)session).processRequest((Request)((DiameterMessageImpl)pushNotificationRequest).getGenericData());
            return activity;
        }

        public ShClientActivity createShClientActivity() throws CreateActivityException {
            ClientShSession session = null;
            try {
                session = (ClientShSession)((ISessionFactory)DiameterShClientResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, null, ClientShSession.class, null);
                if (session == null) {
                    logger.error((Object)"Failure creating Sh-Client Session (null).");
                    return null;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure creating Sh-Client Session.", (Throwable)e);
                return null;
            }
            DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack, new DiameterIdentity[]{null, null});
            ShClientActivityImpl activity = new ShClientActivityImpl(msgFactory, new ShClientMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack), DiameterShClientResourceAdaptor.this.diameterAvpFactory, (DiameterShAvpFactory)new DiameterShAvpFactoryImpl((DiameterAvpFactory)DiameterShClientResourceAdaptor.this.diameterAvpFactory), session, DiameterShClientResourceAdaptor.this.messageTimeout, null, null, DiameterShClientResourceAdaptor.this.sleeEndpoint);
            activity.setSessionListener(this.ra);
            DiameterShClientResourceAdaptor.this.activityCreated((DiameterActivity)activity);
            return activity;
        }

        public ShClientMessageFactory getClientMessageFactory() {
            return new ShClientMessageFactoryImpl(DiameterShClientResourceAdaptor.this.stack);
        }

        public ProfileUpdateAnswer profileUpdateRequest(ProfileUpdateRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShClientResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new ProfileUpdateAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Failed to send due to: " + e);
            }
        }

        public net.java.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswer subscribeNotificationsRequest(net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShClientResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new SubscribeNotificationsAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Failed to send due to: " + e);
            }
        }

        public net.java.slee.resource.diameter.sh.client.events.UserDataAnswer userDataRequest(UserDataRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShClientResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new UserDataAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Failed to send due to: " + e);
            }
        }

        public ShClientSubscriptionActivity createShClientSubscriptionActivity() throws CreateActivityException {
            ClientShSession session = null;
            try {
                session = (ClientShSession)((ISessionFactory)DiameterShClientResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, null, ClientShSession.class, null);
                if (session == null) {
                    logger.error((Object)"Failure creating Sh-Client Subscription Session (null).");
                    return null;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure creating Sh-Client Subscription Session.", (Throwable)e);
                return null;
            }
            DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack, new DiameterIdentity[]{null, null});
            ShClientSubscriptionActivityImpl activity = new ShClientSubscriptionActivityImpl(msgFactory, new ShClientMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack), DiameterShClientResourceAdaptor.this.diameterAvpFactory, (DiameterShAvpFactory)new DiameterShAvpFactoryImpl((DiameterAvpFactory)DiameterShClientResourceAdaptor.this.diameterAvpFactory), session, DiameterShClientResourceAdaptor.this.messageTimeout, null, null, DiameterShClientResourceAdaptor.this.sleeEndpoint);
            activity.setSessionListener(this.ra);
            DiameterShClientResourceAdaptor.this.activityCreated((DiameterActivity)activity);
            return activity;
        }

        public DiameterShAvpFactory getClientAvpFactory() {
            return new DiameterShAvpFactoryImpl((DiameterAvpFactory)DiameterShClientResourceAdaptor.this.diameterAvpFactory);
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.getConnectedPeers().length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShClientSessionFactory
    implements IAppSessionFactory,
    ClientShSessionListener,
    StateChangeListener,
    IShMessageFactory {
        DiameterShClientResourceAdaptor ra = null;

        public ShClientSessionFactory(DiameterShClientResourceAdaptor ra) {
            this.ra = ra;
        }

        public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
            try {
                if (aClass == ClientShSession.class) {
                    ShClientSessionImpl clientSession = null;
                    if (args != null && args.length > 1 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        clientSession = new ShClientSessionImpl(request.getSessionId(), (IShMessageFactory)this, DiameterShClientResourceAdaptor.this.sessionFactory, (ClientShSessionListener)this);
                    } else {
                        clientSession = new ShClientSessionImpl(null, (IShMessageFactory)this, DiameterShClientResourceAdaptor.this.sessionFactory, (ClientShSessionListener)this);
                    }
                    clientSession.addStateChangeNotification((StateChangeListener)this);
                    return clientSession;
                }
                throw new IllegalArgumentException("Wrong session class!![" + aClass + "]. Supported[" + ClientShSession.class + "]");
            }
            catch (Exception e) {
                logger.error((Object)"Failure to obtain new Accounting Session.", (Throwable)e);
                return null;
            }
        }

        public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            logger.info((Object)("Diameter ShClient RA :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]"));
            DiameterActivityHandle handle = new DiameterActivityHandle(((Session)appSession.getSessions().get(0)).getSessionId());
            if (answer != null) {
                if (answer.getMessage().isError()) {
                    this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ErrorAnswer", null, (Answer)answer.getMessage());
                } else {
                    this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage", null, (Answer)answer.getMessage());
                }
            } else {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage", (Request)request.getMessage(), null);
            }
        }

        public void doProfileUpdateAnswerEvent(ClientShSession appSession, org.jdiameter.api.sh.events.ProfileUpdateRequest request, org.jdiameter.api.sh.events.ProfileUpdateAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            logger.info((Object)("doProfileUpdateAnswerEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + answer + "]"));
            DiameterActivityHandle handle = new DiameterActivityHandle(((Session)appSession.getSessions().get(0)).getSessionId());
            if (answer.getMessage().isError()) {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ErrorAnswer", null, (Answer)answer.getMessage());
            } else {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.sh.ProfileUpdateAnswer", null, (Answer)answer.getMessage());
            }
        }

        public void doPushNotificationRequestEvent(ClientShSession appSession, PushNotificationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            logger.info((Object)("doPushNotificationRequestEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + null + "]"));
            DiameterActivityHandle handle = new DiameterActivityHandle(((Session)appSession.getSessions().get(0)).getSessionId());
            this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.sh.PushNotificationRequest", (Request)request.getMessage(), null);
        }

        public void doSubscribeNotificationsAnswerEvent(ClientShSession appSession, SubscribeNotificationsRequest request, SubscribeNotificationsAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            logger.info((Object)("doSubscribeNotificationsAnswerEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + answer + "]"));
            DiameterActivityHandle handle = new DiameterActivityHandle(((Session)appSession.getSessions().get(0)).getSessionId());
            if (answer.getMessage().isError()) {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ErrorAnswer", null, (Answer)answer.getMessage());
            } else {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.sh.SubscribeNotificationsAnswer", null, (Answer)answer.getMessage());
            }
        }

        public void doUserDataAnswerEvent(ClientShSession appSession, org.jdiameter.api.sh.events.UserDataRequest request, UserDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            logger.info((Object)("doUserDataAnswerEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + answer + "]"));
            DiameterActivityHandle handle = new DiameterActivityHandle(((Session)appSession.getSessions().get(0)).getSessionId());
            if (answer.getMessage().isError()) {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ErrorAnswer", null, (Answer)answer.getMessage());
            } else {
                this.ra.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.sh.UserDataAnswer", null, (Answer)answer.getMessage());
            }
        }

        public void stateChanged(Enum oldState, Enum newState) {
            logger.info((Object)("Diameter Sh ClientSessionFactory :: stateChanged :: oldState[" + oldState + "], newState[" + newState + "]"));
        }

        public AppAnswerEvent createProfileUpdateAnswer(Answer answer) {
            return new AppAnswerEventImpl((Message)answer);
        }

        public AppRequestEvent createProfileUpdateRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public AppAnswerEvent createPushNotificationAnswer(Answer answer) {
            return new AppAnswerEventImpl((Message)answer);
        }

        public AppRequestEvent createPushNotificationRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public AppAnswerEvent createSubscribeNotificationsAnswer(Answer answer) {
            return new AppAnswerEventImpl((Message)answer);
        }

        public AppRequestEvent createSubscribeNotificationsRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public AppAnswerEvent createUserDataAnswer(Answer answer) {
            return new AppAnswerEventImpl((Message)answer);
        }

        public AppRequestEvent createUserDataRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public long getApplicationId() {
            return 0x1000001L;
        }

        public long getMessageTimeout() {
            return this.ra.messageTimeout;
        }
    }
}

