/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import javax.slee.ActivityContextInterface;
import javax.slee.UnrecognizedActivityException;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.diameter.sh.client.ShClientActivity;
import net.java.slee.resource.diameter.sh.client.ShClientActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;

public class ShClientActivityContextInterfaceFactoryImpl
implements ShClientActivityContextInterfaceFactory {
    private static Logger logger = Logger.getLogger(ShClientActivityContextInterfaceFactoryImpl.class);
    private SleeContainer serviceContainer = null;
    private String jndiName = null;
    private ActivityContextFactory factory = null;
    private String raEntityName = null;

    public ShClientActivityContextInterfaceFactoryImpl(SleeContainer serviceContainer, String jndiName) {
        logger.info((Object)("Diameter ShClient RA :: ShClientActivityContextInterfaceFactory :: serviceContainer[" + serviceContainer + "], jndiName[" + jndiName + "]."));
        this.serviceContainer = serviceContainer;
        this.jndiName = "java:slee/resources/" + jndiName + "/diameter-shclient-ra-acif";
        this.factory = serviceContainer.getActivityContextFactory();
        this.raEntityName = jndiName;
    }

    public ActivityContextInterface getActivityContextInterface(ShClientActivity activity) throws UnrecognizedActivityException {
        logger.info((Object)("Diameter ShClient RA :: getActivityContextInterface :: activity[" + activity + "]."));
        if (activity == null) {
            throw new NullPointerException("Received null in ACIF");
        }
        return new ActivityContextInterfaceImpl(this.serviceContainer, this.factory.getActivityContext((Object)new SleeActivityHandle(this.raEntityName, (ActivityHandle)((DiameterActivityImpl)activity).getActivityHandle(), this.serviceContainer)).getActivityContextId());
    }

    public ActivityContextInterface getActivityContextInterface(ShClientSubscriptionActivity activity) throws UnrecognizedActivityException {
        logger.info((Object)("Diameter ShClient RA :: getActivityContextInterface :: activity[" + activity + "]."));
        if (activity == null) {
            throw new NullPointerException("Received null in ACIF");
        }
        return new ActivityContextInterfaceImpl(this.serviceContainer, this.factory.getActivityContext((Object)new SleeActivityHandle(this.raEntityName, (ActivityHandle)((DiameterActivityImpl)activity).getActivityHandle(), this.serviceContainer)).getActivityContextId());
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

