/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import java.io.IOException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivity;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.server.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.common.api.app.sh.ShSessionState;
import org.jdiameter.common.impl.app.sh.ProfileUpdateRequestImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsRequestImpl;
import org.jdiameter.common.impl.app.sh.UserDataRequestImpl;
import org.jdiameter.common.impl.validation.JAvpNotAllowedException;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.handlers.ShClientSessionListener;

public class ShClientActivityImpl
extends DiameterActivityImpl
implements ShClientActivity,
StateChangeListener {
    protected ClientShSession clientSession = null;
    protected net.java.slee.resource.diameter.sh.client.ShSessionState state = net.java.slee.resource.diameter.sh.client.ShSessionState.NOTSUBSCRIBED;
    protected ShClientSessionListener listener = null;
    protected DiameterShAvpFactory shAvpFactory = null;
    protected ShClientMessageFactory messageFactory = null;

    public ShClientActivityImpl(DiameterMessageFactoryImpl messageFactory, ShClientMessageFactory shClientMessageFactory, DiameterAvpFactoryImpl avpFactory, DiameterShAvpFactory diameterShAvpFactory, ClientShSession session, long timeout, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, SleeEndpoint endpoint) {
        super(messageFactory, avpFactory, null, (EventListener)session, timeout, destinationHost, destinationRealm, endpoint);
        this.clientSession = session;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
        super.setCurrentWorkingSession((Session)this.clientSession.getSessions().get(0));
        this.shAvpFactory = diameterShAvpFactory;
        this.messageFactory = shClientMessageFactory;
    }

    public void sendProfileUpdateRequest(ProfileUpdateRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendProfileUpdateRequest((org.jdiameter.api.sh.events.ProfileUpdateRequest)new ProfileUpdateRequestImpl((Request)msg.getGenericData()));
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendSubscribeNotificationsRequest(SubscribeNotificationsRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendSubscribeNotificationsRequest((org.jdiameter.api.sh.events.SubscribeNotificationsRequest)new SubscribeNotificationsRequestImpl((Request)msg.getGenericData()));
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendUserDataRequest(net.java.slee.resource.diameter.sh.server.events.UserDataRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendUserDataRequest((UserDataRequest)new UserDataRequestImpl((Request)msg.getGenericData()));
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public Object getSessionListener() {
        return this.listener;
    }

    public void setSessionListener(Object ra) {
        this.listener = (ShClientSessionListener)ra;
    }

    public void endActivity() {
        this.clientSession.release();
    }

    public Object getDiameterAvpFactory() {
        return this.shAvpFactory;
    }

    public Object getDiameterMessageFactory() {
        return this.messageFactory;
    }

    public String getSessionId() {
        return super.getSessionId();
    }

    public void sendMessage(DiameterMessage message) throws IOException {
        super.sendMessage(message);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ShSessionState _state = (ShSessionState)newState;
        switch (_state) {
            case NOTSUBSCRIBED: {
                break;
            }
            case SUBSCRIBED: {
                break;
            }
            case TERMINATED: {
                this.state = net.java.slee.resource.diameter.sh.client.ShSessionState.TERMINATED;
                this.clientSession.removeStateChangeNotification((StateChangeListener)this);
                this.listener.sessionDestroyed(this.getSessionId(), this.clientSession);
            }
        }
    }

    ClientShSession getClientSession() {
        return this.clientSession;
    }
}

