/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.NoSuchAvpException;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.client.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.client.events.avp.SubsReqType;
import net.java.slee.resource.diameter.sh.client.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer;
import net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.server.events.UserDataRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.client.impl.helpers.UIDGenerator;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.ProfileUpdateRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.PushNotificationAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.UserDataRequestImpl;

public class ShClientMessageFactoryImpl
implements ShClientMessageFactory {
    protected Session session;
    protected Stack stack;
    protected DiameterMessageFactoryImpl baseFactory = null;
    protected DiameterAvpFactory baseAvpFactory = null;
    private static Logger logger = Logger.getLogger(ShClientMessageFactoryImpl.class);
    protected static UIDGenerator uid = new UIDGenerator();

    public ShClientMessageFactoryImpl(Session session, Stack stack) {
        this.session = session;
        this.stack = stack;
        this.baseFactory = new DiameterMessageFactoryImpl(this.session, this.stack, new DiameterIdentity[0]);
        this.baseAvpFactory = new DiameterAvpFactoryImpl();
    }

    public ShClientMessageFactoryImpl(Stack stack) {
        this.stack = stack;
        this.baseFactory = new DiameterMessageFactoryImpl(this.stack);
        this.baseAvpFactory = new DiameterAvpFactoryImpl();
    }

    public ProfileUpdateRequest createProfileUpdateRequest(UserIdentityAvp userIdentity, DataReferenceType reference, byte[] userData) {
        ProfileUpdateRequest pur = this.createProfileUpdateRequest();
        pur.setUserIdentity(userIdentity);
        pur.setDataReference(reference);
        pur.setUserData(new String(userData));
        return pur;
    }

    public ProfileUpdateRequest createProfileUpdateRequest() {
        DiameterAvp[] avps = new DiameterAvp[]{};
        if (this.session != null) {
            try {
                DiameterAvp sessionIdAvp = null;
                sessionIdAvp = this.baseAvpFactory.createAvp(0, 263, this.session.getSessionId());
                avps = new DiameterAvp[]{sessionIdAvp};
            }
            catch (NoSuchAvpException e) {
                logger.error((Object)"Unexpected failure trying to create Session-Id AVP.", (Throwable)e);
            }
        }
        Message msg = this.createShMessage(null, avps, 307);
        ProfileUpdateRequestImpl pur = new ProfileUpdateRequestImpl(msg);
        this.addOrigin((DiameterMessage)pur);
        return pur;
    }

    public PushNotificationAnswer createPushNotificationAnswer(PushNotificationRequest request, long resultCode, boolean isExperimentalResultCode) {
        PushNotificationAnswer pna = this.createPushNotificationAnswer(request);
        if (isExperimentalResultCode) {
            pna.setExperimentalResult(this.baseAvpFactory.createExperimentalResult(0L, resultCode));
        } else {
            pna.setResultCode(resultCode);
        }
        return pna;
    }

    public PushNotificationAnswer createPushNotificationAnswer(PushNotificationRequest request) {
        DiameterAvp[] avps = new DiameterAvp[]{};
        try {
            DiameterAvp sessionIdAvp = null;
            sessionIdAvp = this.baseAvpFactory.createAvp(0, 263, request.getSessionId());
            avps = new DiameterAvp[]{sessionIdAvp};
        }
        catch (NoSuchAvpException e) {
            logger.error((Object)"Unexpected failure trying to create Session-Id AVP.", (Throwable)e);
        }
        Message msg = this.createShMessage(request.getHeader(), avps, 309);
        PushNotificationAnswerImpl pna = new PushNotificationAnswerImpl(msg);
        return pna;
    }

    public SubscribeNotificationsRequest createSubscribeNotificationsRequest(UserIdentityAvp userIdentity, DataReferenceType reference, SubsReqType subscriptionType) {
        SubscribeNotificationsRequest snr = this.createSubscribeNotificationsRequest();
        snr.setUserIdentity(userIdentity);
        snr.setDataReference(reference);
        snr.setSubsReqType(subscriptionType);
        return snr;
    }

    public SubscribeNotificationsRequest createSubscribeNotificationsRequest() {
        DiameterAvp[] avps = new DiameterAvp[]{};
        if (this.session != null) {
            try {
                DiameterAvp sessionIdAvp = null;
                sessionIdAvp = this.baseAvpFactory.createAvp(0, 263, this.session.getSessionId());
                avps = new DiameterAvp[]{sessionIdAvp};
            }
            catch (NoSuchAvpException e) {
                logger.error((Object)"Unexpected failure trying to create Session-Id AVP.", (Throwable)e);
            }
        }
        Message msg = this.createShMessage(null, avps, 308);
        SubscribeNotificationsRequestImpl snr = new SubscribeNotificationsRequestImpl(msg);
        this.addOrigin((DiameterMessage)snr);
        return snr;
    }

    public UserDataRequest createUserDataRequest(UserIdentityAvp userIdentity, DataReferenceType reference) {
        UserDataRequest udr = this.createUserDataRequest();
        udr.setUserIdentity(userIdentity);
        udr.setDataReference(reference);
        return udr;
    }

    public UserDataRequest createUserDataRequest() {
        DiameterAvp[] avps = new DiameterAvp[]{};
        if (this.session != null) {
            try {
                DiameterAvp sessionIdAvp = null;
                sessionIdAvp = this.baseAvpFactory.createAvp(0, 263, this.session.getSessionId());
                avps = new DiameterAvp[]{sessionIdAvp};
            }
            catch (NoSuchAvpException e) {
                logger.error((Object)"Unexpected failure trying to create Session-Id AVP.", (Throwable)e);
            }
        }
        Message msg = this.createShMessage(null, avps, 306);
        UserDataRequestImpl udr = new UserDataRequestImpl(msg);
        this.addOrigin((DiameterMessage)udr);
        return udr;
    }

    private Message createShMessage(DiameterHeader diameterHeader, DiameterAvp[] avps, int _commandCode) throws IllegalArgumentException {
        boolean isRequest = diameterHeader == null;
        Message msg = null;
        if (!isRequest) {
            Message raw = this.createMessage(diameterHeader, avps, 0);
            raw.setProxiable(true);
            raw.setRequest(false);
            msg = raw;
        } else {
            Message raw = this.createMessage(null, avps, _commandCode);
            raw.setProxiable(true);
            raw.setRequest(true);
            msg = raw;
        }
        return msg;
    }

    protected Message createMessage(DiameterHeader header, DiameterAvp[] avps, int commandCode) throws AvpNotAllowedException {
        try {
            Message msg = this.createRawMessage(header, commandCode);
            AvpSet set = msg.getAvps();
            for (DiameterAvp avp : avps) {
                this.addAvp(avp, set);
            }
            if (msg.getAvps().getAvp(260) == null) {
                DiameterAvp avpVendorId = this.baseAvpFactory.createAvp(266, 10415);
                DiameterAvp avpAcctApplicationId = this.baseAvpFactory.createAvp(259, 0x1000001);
                DiameterAvp vendorSpecific = this.baseAvpFactory.createAvp(260, new DiameterAvp[]{avpVendorId, avpAcctApplicationId});
                msg.getAvps().addAvp(vendorSpecific.getCode(), vendorSpecific.byteArrayValue());
            }
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Message createRawMessage(DiameterHeader header, int _commandCode) {
        int commandCode = 0;
        long endToEndId = 0L;
        long hopByHopId = 0L;
        ApplicationId aid = null;
        if (header != null) {
            commandCode = header.getCommandCode();
            endToEndId = header.getEndToEndId();
            hopByHopId = header.getHopByHopId();
            aid = ApplicationId.createByAuthAppId((long)header.getApplicationId());
        } else {
            commandCode = _commandCode;
            endToEndId = (long)(Math.random() * 1000000.0);
            hopByHopId = (long)(Math.random() * 1000000.0) + 1L;
            aid = ApplicationId.createByAuthAppId((long)10415L, (long)0x1000001L);
        }
        try {
            Message msg = this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, aid, hopByHopId, endToEndId, new Avp[0]);
            return msg;
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (IllegalDiameterStateException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void addAvp(DiameterAvp avp, AvpSet set) {
        if (avp instanceof GroupedAvp) {
            DiameterAvp[] groupedAVPs;
            AvpSet avpSet = set.addGroupedAvp(avp.getCode(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
            for (DiameterAvp avpFromGroup : groupedAVPs = ((GroupedAvp)avp).getExtensionAvps()) {
                this.addAvp(avpFromGroup, avpSet);
            }
        } else if (avp != null) {
            set.addAvp(avp.getCode(), avp.byteArrayValue(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
        }
    }

    private void addOrigin(DiameterMessage msg) {
        if (!msg.hasOriginHost()) {
            msg.setOriginHost(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getUri().getFQDN().toString()));
        }
        if (!msg.hasOriginRealm()) {
            msg.setOriginRealm(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getRealmName()));
        }
    }
}

