/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import java.io.IOException;
import java.util.ArrayList;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AuthSessionStateType;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.client.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.client.events.avp.SubsReqType;
import net.java.slee.resource.diameter.sh.client.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.common.api.app.sh.ShSessionState;
import org.jdiameter.common.impl.app.sh.ProfileUpdateRequestImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationAnswerImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsRequestImpl;
import org.jdiameter.common.impl.app.sh.UserDataRequestImpl;
import org.jdiameter.common.impl.validation.JAvpNotAllowedException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.DiameterShMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.avp.UserIdentityAvpImpl;
import org.mobicents.slee.resource.diameter.sh.client.handlers.ShClientSessionListener;

public class ShClientSubscriptionActivityImpl
extends DiameterActivityImpl
implements ShClientSubscriptionActivity,
StateChangeListener {
    protected ClientShSession clientSession = null;
    protected net.java.slee.resource.diameter.sh.client.ShSessionState state = net.java.slee.resource.diameter.sh.client.ShSessionState.NOTSUBSCRIBED;
    protected ShClientSessionListener listener = null;
    protected DiameterShAvpFactory shAvpFactory = null;
    protected ShClientMessageFactory messageFactory = null;
    protected UserIdentityAvp userIdentity;
    protected DataReferenceType[] dataReferenceType;
    protected AuthSessionStateType authSessionState;
    protected DiameterIdentity remoteRealm;
    protected ArrayList<DiameterMessageImpl> stateMessages = new ArrayList();

    public ShClientSubscriptionActivityImpl(DiameterMessageFactoryImpl messageFactory, ShClientMessageFactory shClientMessageFactory, DiameterAvpFactoryImpl avpFactory, DiameterShAvpFactory diameterShAvpFactory, ClientShSession session, long timeout, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, SleeEndpoint endpoint) {
        super(messageFactory, avpFactory, null, (EventListener)session, timeout, destinationHost, destinationRealm, endpoint);
        this.clientSession = session;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
        super.setCurrentWorkingSession((Session)this.clientSession.getSessions().get(0));
        this.shAvpFactory = diameterShAvpFactory;
        this.messageFactory = shClientMessageFactory;
    }

    public UserIdentityAvp getSubscribedUserIdendity() {
        return this.userIdentity;
    }

    public net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer createPushNotificationAnswer() {
        net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 307) continue;
            PushNotificationRequest msg = (PushNotificationRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createPushNotificationAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            if (answer.getDestinationRealm() == null && this.remoteRealm != null) {
                answer.setDestinationRealm(this.remoteRealm);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer createPushNotificationAnswer(long resultCode, boolean isExperimaental) {
        net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 307) continue;
            PushNotificationRequest msg = (PushNotificationRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createPushNotificationAnswer(msg, resultCode, isExperimaental);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            if (answer.getDestinationRealm() == null && this.remoteRealm != null) {
                answer.setDestinationRealm(this.remoteRealm);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public void sendUserDataRequest(net.java.slee.resource.diameter.sh.server.events.UserDataRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendUserDataRequest((UserDataRequest)new UserDataRequestImpl((Request)msg.getGenericData()));
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendProfileUpdateRequest(ProfileUpdateRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendProfileUpdateRequest((org.jdiameter.api.sh.events.ProfileUpdateRequest)new ProfileUpdateRequestImpl((Request)msg.getGenericData()));
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendPushNotificationAnswer(net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer answer) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)answer;
            this.clientSession.sendPushNotificationAnswer((PushNotificationAnswer)new PushNotificationAnswerImpl((Answer)msg.getGenericData()));
            this.clean((DiameterShMessageImpl)answer);
            this.fetchSessionData((DiameterMessage)answer, false);
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendPushNotificationAnswer(long resultCode, boolean isExperimentalResultCode) throws IOException {
        net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer answer = this.createPushNotificationAnswer(resultCode, isExperimentalResultCode);
        if (answer == null) {
            throw new IOException("Could not create PNA, there is no PNR?");
        }
        this.sendPushNotificationAnswer(answer);
    }

    public void sendSubscriptionNotificationRequest(SubscribeNotificationsRequest request) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)request;
            this.clientSession.sendSubscribeNotificationsRequest((org.jdiameter.api.sh.events.SubscribeNotificationsRequest)new SubscribeNotificationsRequestImpl((Request)msg.getGenericData()));
            this.fetchSessionData((DiameterMessage)msg, false);
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendUnsubscribeRequest() throws IOException {
        try {
            SubscribeNotificationsRequest snr = this.messageFactory.createSubscribeNotificationsRequest(this.getSubscribedUserIdendity(), DataReferenceType.REPOSITORY_DATA, SubsReqType.UNSUBSCRIBE);
            snr.setDataReferences(this.dataReferenceType);
            snr.setDestinationRealm(this.remoteRealm);
            snr.setAuthSessionState(this.authSessionState);
            DiameterMessageImpl msg = (DiameterMessageImpl)snr;
            this.clientSession.sendSubscribeNotificationsRequest((org.jdiameter.api.sh.events.SubscribeNotificationsRequest)new SubscribeNotificationsRequestImpl((Request)msg.getGenericData()));
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    private void clean(DiameterShMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ShSessionState shNewState = (ShSessionState)newState;
        switch (shNewState) {
            case NOTSUBSCRIBED: {
                break;
            }
            case SUBSCRIBED: {
                this.state = net.java.slee.resource.diameter.sh.client.ShSessionState.SUBSCRIBED;
                break;
            }
            case TERMINATED: {
                this.state = net.java.slee.resource.diameter.sh.client.ShSessionState.TERMINATED;
                this.listener.sessionDestroyed(this.getSessionId(), this.clientSession);
                this.clientSession.removeStateChangeNotification((StateChangeListener)this);
            }
        }
    }

    public Object getSessionListener() {
        return this.listener;
    }

    public void setSessionListener(Object ra) {
        this.listener = (ShClientSessionListener)ra;
    }

    public void endActivity() {
        this.clientSession.release();
    }

    public Object getDiameterAvpFactory() {
        return this.shAvpFactory;
    }

    public Object getDiameterMessageFactory() {
        return this.messageFactory;
    }

    ClientShSession getClientSession() {
        return this.clientSession;
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest()) {
            if (incoming) {
                if (this.userIdentity == null) {
                    try {
                        AvpRepresentation rep = AvpDictionary.INSTANCE.getAvp(700, 10415L);
                        this.userIdentity = new UserIdentityAvpImpl(700, 10415L, rep.getRuleMandatoryAsInt(), rep.getRuleProtectedAsInt(), AvpUtilities.getAvpAsGrouped((int)700, (long)10415L, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.authSessionState == null) {
                    try {
                        this.authSessionState = AuthSessionStateType.fromInt((int)AvpUtilities.getAvpAsInteger32((int)277, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.stateMessages.add((DiameterMessageImpl)msg);
            } else {
                if (this.destinationRealm == null) {
                    this.remoteRealm = msg.getDestinationRealm();
                }
                if (msg instanceof SubscribeNotificationsRequest) {
                    SubscribeNotificationsRequest snr = (SubscribeNotificationsRequest)msg;
                    if (this.dataReferenceType == null && snr.hasDataReferenceType()) {
                        this.dataReferenceType = snr.getDataReferences();
                    }
                    if (this.authSessionState == null && snr.hasAuthSessionState()) {
                        this.authSessionState = snr.getAuthSessionState();
                    }
                    if (this.userIdentity == null && snr.hasUserIdentity()) {
                        this.userIdentity = snr.getUserIdentity();
                    }
                }
            }
        }
    }
}

