/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import java.io.IOException;
import java.util.ArrayList;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AuthSessionStateType;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.events.PushNotificationAnswer;
import net.java.slee.resource.diameter.sh.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.events.avp.SubsReqType;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.impl.app.sh.PushNotificationAnswerImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsRequestImpl;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.events.DiameterShMessageImpl;
import org.mobicents.slee.resource.diameter.sh.events.avp.UserIdentityAvpImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShClientSubscriptionActivityImpl
extends DiameterActivityImpl
implements ShClientSubscriptionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = -6702340517032186782L;
    protected transient ClientShSession clientSession = null;
    protected transient DiameterShAvpFactory shAvpFactory = null;
    protected transient ShClientMessageFactory messageFactory = null;
    protected UserIdentityAvp userIdentity;
    protected DataReferenceType[] dataReferenceType;
    protected AuthSessionStateType authSessionState;
    protected DiameterIdentity remoteRealm;
    protected transient ArrayList<DiameterMessageImpl> stateMessages = new ArrayList();

    public ShClientSubscriptionActivityImpl(ShClientMessageFactory shClientMessageFactory, DiameterShAvpFactory shAvpFactory, ClientShSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(shClientMessageFactory.getBaseMessageFactory(), shAvpFactory.getBaseFactory(), null, (EventListener)session, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)this.clientSession.getSessions().get(0));
        this.shAvpFactory = shAvpFactory;
        this.messageFactory = shClientMessageFactory;
    }

    public void setSession(ClientShSession session) {
        this.clientSession = session;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
    }

    public ShClientMessageFactory getClientMessageFactory() {
        return this.messageFactory;
    }

    public DiameterShAvpFactory getClientAvpFactory() {
        return this.shAvpFactory;
    }

    public void setClientMessageFactory(ShClientMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setClientAvpFactory(DiameterShAvpFactory shAvpFactory) {
        this.shAvpFactory = shAvpFactory;
    }

    public UserIdentityAvp getSubscribedUserIdentity() {
        return this.userIdentity;
    }

    public PushNotificationAnswer createPushNotificationAnswer() {
        PushNotificationAnswer pna = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 309) continue;
            PushNotificationRequest msg = (PushNotificationRequest)this.stateMessages.get(index);
            pna = this.messageFactory.createPushNotificationAnswer(msg);
            if (pna.getAuthSessionState() == null && this.authSessionState != null) {
                pna.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)pna).setData((Object)msg);
            break;
        }
        return pna;
    }

    public PushNotificationAnswer createPushNotificationAnswer(long resultCode, boolean isExperimental) {
        PushNotificationAnswer pna = this.createPushNotificationAnswer();
        if (isExperimental) {
            pna.setExperimentalResult(this.shAvpFactory.getBaseFactory().createExperimentalResult(0x1000001L, resultCode));
        } else {
            pna.setResultCode(resultCode);
        }
        return pna;
    }

    public void sendPushNotificationAnswer(PushNotificationAnswer answer) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)answer;
            this.clientSession.sendPushNotificationAnswer((org.jdiameter.api.sh.events.PushNotificationAnswer)new PushNotificationAnswerImpl((Answer)msg.getGenericData()));
            this.clean((DiameterShMessageImpl)answer);
            this.fetchSessionData((DiameterMessage)answer, false);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getLocalizedMessage());
        }
    }

    public void sendPushNotificationAnswer(long resultCode, boolean isExperimentalResultCode) throws IOException {
        PushNotificationAnswer answer = this.createPushNotificationAnswer(resultCode, isExperimentalResultCode);
        if (answer == null) {
            throw new IOException("Could not create PNA, there is no PNR?");
        }
        this.sendPushNotificationAnswer(answer);
    }

    public void sendSubscribeNotificationsRequest(SubscribeNotificationsRequest request) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)request;
            this.clientSession.sendSubscribeNotificationsRequest((org.jdiameter.api.sh.events.SubscribeNotificationsRequest)new SubscribeNotificationsRequestImpl((Request)msg.getGenericData()));
            this.fetchSessionData((DiameterMessage)msg, false);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getLocalizedMessage());
        }
    }

    public void sendUnsubscribeRequest() throws IOException {
        try {
            SubscribeNotificationsRequest snr = this.messageFactory.createSubscribeNotificationsRequest(this.getSubscribedUserIdentity(), this.dataReferenceType[0], SubsReqType.UNSUBSCRIBE);
            snr.setDataReferences(this.dataReferenceType);
            snr.setDestinationRealm(this.remoteRealm);
            snr.setAuthSessionState(this.authSessionState);
            DiameterMessageImpl msg = (DiameterMessageImpl)snr;
            this.clientSession.sendSubscribeNotificationsRequest((org.jdiameter.api.sh.events.SubscribeNotificationsRequest)new SubscribeNotificationsRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getLocalizedMessage());
        }
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
    }

    ClientShSession getClientSession() {
        return this.clientSession;
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest()) {
            if (incoming) {
                if (this.userIdentity == null) {
                    AvpRepresentation rep = AvpDictionary.INSTANCE.getAvp(700, 10415L);
                    this.userIdentity = new UserIdentityAvpImpl(700, 10415L, rep.getRuleMandatoryAsInt(), rep.getRuleProtectedAsInt(), AvpUtilities.getAvpAsGrouped((int)700, (long)10415L, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
                }
                if (this.authSessionState == null) {
                    this.authSessionState = AuthSessionStateType.fromInt((int)AvpUtilities.getAvpAsInteger32((int)277, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
                }
                this.stateMessages.add((DiameterMessageImpl)msg);
            } else {
                if (this.destinationRealm == null) {
                    this.remoteRealm = msg.getDestinationRealm();
                }
                if (msg instanceof SubscribeNotificationsRequest) {
                    SubscribeNotificationsRequest snr = (SubscribeNotificationsRequest)msg;
                    if (this.dataReferenceType == null || this.dataReferenceType.length == 0) {
                        this.dataReferenceType = snr.getDataReferences();
                    }
                    if (this.authSessionState == null && snr.hasAuthSessionState()) {
                        this.authSessionState = snr.getAuthSessionState();
                    }
                    if (this.userIdentity == null && snr.hasUserIdentity()) {
                        this.userIdentity = snr.getUserIdentity();
                    }
                }
            }
        }
    }

    public void endActivity() {
        this.clientSession.release();
        this.clientSession.removeStateChangeNotification((StateChangeListener)this);
        this.baseListener.endActivity(this.getActivityHandle());
    }

    private void clean(DiameterShMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }
}

