/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import java.io.IOException;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivity;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.UserDataRequest;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.impl.app.sh.ProfileUpdateRequestImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsRequestImpl;
import org.jdiameter.common.impl.app.sh.UserDataRequestImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShClientActivityImpl
extends DiameterActivityImpl
implements ShClientActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = -1182214629020823688L;
    protected transient ClientShSession clientSession = null;
    protected transient DiameterShAvpFactory shAvpFactory = null;
    protected transient ShClientMessageFactory messageFactory = null;

    public ShClientActivityImpl(ShClientMessageFactory shClientMessageFactory, DiameterShAvpFactory shAvpFactory, ClientShSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(shClientMessageFactory.getBaseMessageFactory(), shAvpFactory.getBaseFactory(), null, (EventListener)session, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)this.clientSession.getSessions().get(0));
        this.shAvpFactory = shAvpFactory;
        this.messageFactory = shClientMessageFactory;
    }

    public void setSession(ClientShSession session) {
        this.clientSession = session;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
    }

    public void sendProfileUpdateRequest(ProfileUpdateRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendProfileUpdateRequest((org.jdiameter.api.sh.events.ProfileUpdateRequest)new ProfileUpdateRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e.getLocalizedMessage());
        }
    }

    public void sendSubscribeNotificationsRequest(SubscribeNotificationsRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendSubscribeNotificationsRequest((org.jdiameter.api.sh.events.SubscribeNotificationsRequest)new SubscribeNotificationsRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendUserDataRequest(UserDataRequest message) throws IOException {
        try {
            DiameterMessageImpl msg = (DiameterMessageImpl)message;
            this.clientSession.sendUserDataRequest((org.jdiameter.api.sh.events.UserDataRequest)new UserDataRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public ShClientMessageFactory getClientMessageFactory() {
        return this.messageFactory;
    }

    public DiameterShAvpFactory getClientAvpFactory() {
        return this.shAvpFactory;
    }

    public void setClientMessageFactory(ShClientMessageFactory v) {
        this.messageFactory = v;
    }

    public void setClientAvpFactory(DiameterShAvpFactory v) {
        this.shAvpFactory = v;
    }

    public String getSessionId() {
        return super.getSessionId();
    }

    public void sendMessage(DiameterMessage message) throws IOException {
        super.sendMessage(message);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
    }

    ClientShSession getClientSession() {
        return this.clientSession;
    }

    public void endActivity() {
        this.clientSession.release();
        this.clientSession.removeStateChangeNotification((StateChangeListener)this);
        super.endActivity();
    }
}

