/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.Validator;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivity;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientProvider;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.UserDataRequest;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.sh.ShClientSessionImpl;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.sh.ShSessionFactoryImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.AbstractClusteredDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.ValidatorImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.sh.DiameterShAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.EventIDCache;
import org.mobicents.slee.resource.diameter.sh.client.ShClientActivityImpl;
import org.mobicents.slee.resource.diameter.sh.client.ShClientMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.ShClientSubscriptionActivityImpl;
import org.mobicents.slee.resource.diameter.sh.events.ProfileUpdateAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.ProfileUpdateRequestImpl;
import org.mobicents.slee.resource.diameter.sh.events.PushNotificationAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.PushNotificationRequestImpl;
import org.mobicents.slee.resource.diameter.sh.events.SubscribeNotificationsAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.SubscribeNotificationsRequestImpl;
import org.mobicents.slee.resource.diameter.sh.events.UserDataAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.UserDataRequestImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiameterShClientResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface,
FaultTolerantResourceAdaptor<String, DiameterActivity> {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private List<ApplicationId> authApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private FaultTolerantResourceAdaptorContext<String, DiameterActivity> ftRAContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    private DiameterBaseMarshaler marshaler = new DiameterBaseMarshaler();
    private Stack stack;
    private SessionFactory sessionFactory = null;
    private long messageTimeout = 5000L;
    private long activityRemoveDelay = 30000L;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private DiameterAvpFactory baseAvpFactory = null;
    private DiameterShAvpFactory shAvpFactory = null;
    private ShClientMessageFactory shClientMessageFactory = null;
    private transient EventLookupFacility eventLookup = null;
    private transient DiameterActivityManagement activities = null;
    private transient ShClientProviderImpl raProvider = null;
    private static final int EVENT_FLAGS = DiameterShClientResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = ActivityFlags.setRequestSleeActivityGCCallback((int)2);
    private static final int MARSHALABLE_ACTIVITY_FLAGS = ActivityFlags.setSleeMayMarshal((int)DEFAULT_ACTIVITY_FLAGS);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterShClientResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
        this.raProvider = new ShClientProviderImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
        this.raProvider = null;
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<String, DiameterActivity> ctx) {
        this.ftRAContext = ctx;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRAContext = null;
    }

    public void dataRemoved(String arg0) {
        this.activities.remove(this.getActivityHandle(arg0));
    }

    public void failOver(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter ShClient RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", EMPTY_OBJECT_ARRAY, EMPTY_STRING_ARRAY);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.shAvpFactory = new DiameterShAvpFactoryImpl(this.baseAvpFactory);
            this.shClientMessageFactory = new ShClientMessageFactoryImpl(this.stack);
            ApplicationId firstAppId = this.authApplicationIds.get(0);
            ((ShClientMessageFactoryImpl)this.shClientMessageFactory).setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
            this.sessionFactory = this.stack.getSessionFactory();
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientShSession.class, (IAppSessionFactory)new ShClientSessionFactory(this, this.sessionFactory));
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter ShClient RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister ShClient RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: entityDeactivating completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: entityDeactivated.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: INACTIVE completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                appIds.add(ApplicationId.createByAuthAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
            this.authApplicationIds = appIds;
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        DiameterActivityImpl activity;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: queryLiveness :: handle[" + handle + "].");
        }
        if ((activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle)) != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: getActivity :: handle[" + handle + "].");
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAfterEventDelivery(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        DiameterActivityImpl activity = (DiameterActivityImpl)this.getActivity(handle);
        if (activity != null) {
            DiameterActivityImpl diameterActivityImpl = activity;
            synchronized (diameterActivityImpl) {
                if (activity.isTerminateAfterProcessing()) {
                    activity.endActivity();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        this.tracer.info("Diameter ShClient RA :: activityEnded :: handle[" + handle + ".");
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (handle instanceof DiameterActivityHandle) {
            this.endActivity((DiameterActivityHandle)handle);
        }
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    public void endActivity(DiameterActivityHandle handle) {
        this.sleeEndpoint.endActivity((ActivityHandle)handle);
    }

    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        this.activities.startActivityRemoveTimer(handle);
    }

    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        this.activities.stopActivityRemoveTimer(handle);
    }

    public void update(DiameterActivityHandle handle, DiameterActivity activity) {
        this.activities.update(handle, activity);
    }

    public ApplicationId[] getSupportedApplications() {
        return null;
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 309: {
                return isRequest ? new PushNotificationRequestImpl(message) : new PushNotificationAnswerImpl(message);
            }
            case 307: {
                return isRequest ? new ProfileUpdateRequestImpl(message) : new ProfileUpdateAnswerImpl(message);
            }
            case 308: {
                return isRequest ? new SubscribeNotificationsRequestImpl(message) : new SubscribeNotificationsAnswerImpl(message);
            }
            case 306: {
                return isRequest ? new UserDataRequestImpl(message) : new UserDataAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    public void sessionDestroyed(String sessionId, ClientShSession session) {
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            this.tracer.severe("Failed to end activity with handle[" + this.getActivityHandle(sessionId));
        }
    }

    private void activityCreated(DiameterActivity ac, boolean suspended) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            if (suspended) {
                this.sleeEndpoint.startActivitySuspended((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            }
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating/starting activity.", (Throwable)e);
        }
    }

    public ResourceAdaptorContext getRaContext() {
        return this.raContext;
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.authApplicationIds.toArray(new ApplicationId[this.authApplicationIds.size()]));
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        final DiameterShClientResourceAdaptor lst = this;
        if (this.ftRAContext.isLocal()) {
            this.tracer.info(this.raContext.getEntityName() + " -- running in local mode.");
            this.activities = new LocalDiameterActivityManagement(this.raContext, this.activityRemoveDelay);
        } else {
            this.tracer.info(this.raContext.getEntityName() + " -- running in cluster mode.");
            ReplicatedData clusteredData = this.ftRAContext.getReplicateData(true);
            this.activities = new AbstractClusteredDiameterActivityManagement(this.ftRAContext, this.activityRemoveDelay, this.raContext.getTracer(""), this.stack, this.raContext.getSleeTransactionManager(), clusteredData){

                protected void performBeforeReturn(DiameterActivityImpl activity) {
                    block5: {
                        try {
                            Session session = null;
                            if (activity.getClass().equals(DiameterActivityImpl.class)) {
                                session = this.diameterStack.getSessionFactory().getNewSession(activity.getSessionId());
                                this.performBeforeReturnOnBase(activity, session);
                                return;
                            }
                            if (activity instanceof ShClientActivity) {
                                ShClientActivityImpl sh = (ShClientActivityImpl)activity;
                                ClientShSession appSession = (ClientShSession)this.diameterStack.getSession(activity.getSessionId(), ClientShSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnSh(sh, session);
                                sh.setSession(appSession);
                                break block5;
                            }
                            if (activity instanceof ShClientSubscriptionActivity) {
                                ShClientSubscriptionActivityImpl sh = (ShClientSubscriptionActivityImpl)activity;
                                ClientShSession appSession = (ClientShSession)this.diameterStack.getSession(activity.getSessionId(), ClientShSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnSh(sh, session);
                                sh.setSession(appSession);
                                break block5;
                            }
                            throw new IllegalArgumentException("Got wrong activity: " + activity);
                        }
                        catch (Exception e) {
                            throw new DiameterException((Throwable)e);
                        }
                    }
                }

                private void performBeforeReturnSh(ShClientSubscriptionActivityImpl sh, Session session) {
                    ShClientMessageFactoryImpl messageFactory = new ShClientMessageFactoryImpl(session, DiameterShClientResourceAdaptor.this.stack);
                    ApplicationId firstAppId = (ApplicationId)DiameterShClientResourceAdaptor.this.authApplicationIds.get(0);
                    messageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
                    sh.setClientMessageFactory(messageFactory);
                    sh.setClientAvpFactory(DiameterShClientResourceAdaptor.this.shAvpFactory);
                }

                private void performBeforeReturnSh(ShClientActivityImpl sh, Session session) {
                    ShClientMessageFactoryImpl messageFactory = new ShClientMessageFactoryImpl(session, DiameterShClientResourceAdaptor.this.stack);
                    ApplicationId firstAppId = (ApplicationId)DiameterShClientResourceAdaptor.this.authApplicationIds.get(0);
                    messageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAuthAppId());
                    sh.setClientMessageFactory(messageFactory);
                    sh.setClientAvpFactory(DiameterShClientResourceAdaptor.this.shAvpFactory);
                }

                private void performBeforeReturnOnBase(DiameterActivityImpl ac, Session session) {
                    DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, DiameterShClientResourceAdaptor.this.stack, new DiameterIdentity[0]);
                    ac.setAvpFactory(DiameterShClientResourceAdaptor.this.baseAvpFactory);
                    ac.setMessageFactory((DiameterMessageFactory)msgFactory);
                    ac.setCurrentWorkingSession(session);
                    ac.setSessionListener((Object)lst);
                }

                public DiameterActivity get(DiameterActivityHandle handle) {
                    DiameterActivity da = super.get(handle);
                    return da;
                }

                public void put(DiameterActivityHandle handle, DiameterActivity activity) {
                    super.put(handle, activity);
                }

                public DiameterActivity remove(DiameterActivityHandle handle) {
                    return super.remove(handle);
                }
            };
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        try {
            this.raProvider.createActivity((Message)request);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request req, Answer ans) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShClient RA :: receivedSuccessMessage :: Request[" + req + "], Answer[" + ans + "].");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + ans.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request req) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShClient RA :: timeoutExpired :: Request[" + req + "].");
        }
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(req.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    private class ShClientProviderImpl
    implements ShClientProvider {
        protected DiameterShClientResourceAdaptor ra = null;
        protected Validator validator = new ValidatorImpl();

        public ShClientProviderImpl(DiameterShClientResourceAdaptor ra) {
            this.ra = ra;
        }

        DiameterActivity createActivity(Message message) throws CreateActivityException {
            DiameterActivity activity = DiameterShClientResourceAdaptor.this.activities.get(DiameterShClientResourceAdaptor.this.getActivityHandle(message.getSessionId()));
            if (activity == null) {
                if (message.getCommandCode() != 309) {
                    throw new CreateActivityException("Cant create activity for unexpected message:\r\n" + message);
                }
                return (ShClientSubscriptionActivityImpl)this.createShClientSubscriptionActivity((net.java.slee.resource.diameter.sh.events.PushNotificationRequest)new PushNotificationRequestImpl(message));
            }
            return activity;
        }

        private ShClientSubscriptionActivity createShClientSubscriptionActivity(net.java.slee.resource.diameter.sh.events.PushNotificationRequest pushNotificationRequest) {
            ClientShSession session = null;
            try {
                session = (ClientShSession)((ISessionFactory)DiameterShClientResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, null, ClientShSession.class, new Object[]{((DiameterMessageImpl)pushNotificationRequest).getGenericData()});
                if (session == null) {
                    DiameterShClientResourceAdaptor.this.tracer.severe("Failure creating Sh-Client Subscription Session (null).");
                    return null;
                }
            }
            catch (Exception e) {
                DiameterShClientResourceAdaptor.this.tracer.severe("Failure creating Sh-Client Subscription Session.", (Throwable)e);
                return null;
            }
            ShClientSubscriptionActivityImpl activity = new ShClientSubscriptionActivityImpl(this.getSessionShMessageFactory((AppSession)session), DiameterShClientResourceAdaptor.this.shAvpFactory, session, null, null);
            activity.fetchSessionData((DiameterMessage)pushNotificationRequest, true);
            activity.setSessionListener(this.ra);
            DiameterShClientResourceAdaptor.this.activityCreated((DiameterActivity)activity, false);
            ((ShClientSessionImpl)session).processRequest((Request)((DiameterMessageImpl)pushNotificationRequest).getGenericData());
            return activity;
        }

        public ShClientActivity createShClientActivity() throws CreateActivityException {
            ClientShSession session = null;
            try {
                session = (ClientShSession)((ISessionFactory)DiameterShClientResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, null, ClientShSession.class, EMPTY_OBJECT_ARRAY);
                if (session == null) {
                    DiameterShClientResourceAdaptor.this.tracer.severe("Failure creating Sh-Client Session (null).");
                    return null;
                }
            }
            catch (Exception e) {
                DiameterShClientResourceAdaptor.this.tracer.severe("Failure creating Sh-Client Session.", (Throwable)e);
                return null;
            }
            ShClientActivityImpl activity = new ShClientActivityImpl(this.getSessionShMessageFactory((AppSession)session), DiameterShClientResourceAdaptor.this.shAvpFactory, session, null, null);
            activity.setSessionListener(this.ra);
            DiameterShClientResourceAdaptor.this.activityCreated((DiameterActivity)activity, false);
            return activity;
        }

        public ShClientMessageFactory getClientMessageFactory() {
            return DiameterShClientResourceAdaptor.this.shClientMessageFactory;
        }

        public net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer profileUpdateRequest(ProfileUpdateRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShClientResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new ProfileUpdateAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to send due to: " + e.getLocalizedMessage());
            }
        }

        public net.java.slee.resource.diameter.sh.events.SubscribeNotificationsAnswer subscribeNotificationsRequest(SubscribeNotificationsRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShClientResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new SubscribeNotificationsAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to send due to: " + e);
            }
        }

        public net.java.slee.resource.diameter.sh.events.UserDataAnswer userDataRequest(UserDataRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShClientResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new UserDataAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to send due to: " + e.getLocalizedMessage());
            }
        }

        public ShClientSubscriptionActivity createShClientSubscriptionActivity() throws CreateActivityException {
            ClientShSession session = null;
            try {
                session = (ClientShSession)((ISessionFactory)DiameterShClientResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, null, ClientShSession.class, EMPTY_OBJECT_ARRAY);
                if (session == null) {
                    DiameterShClientResourceAdaptor.this.tracer.severe("Failure creating Sh-Client Subscription Session (null).");
                    return null;
                }
            }
            catch (Exception e) {
                DiameterShClientResourceAdaptor.this.tracer.severe("Failure creating Sh-Client Subscription Session.", (Throwable)e);
                return null;
            }
            ShClientSubscriptionActivityImpl activity = new ShClientSubscriptionActivityImpl(this.getSessionShMessageFactory((AppSession)session), DiameterShClientResourceAdaptor.this.shAvpFactory, session, null, null);
            activity.setSessionListener(this.ra);
            DiameterShClientResourceAdaptor.this.activityCreated((DiameterActivity)activity, false);
            return activity;
        }

        public DiameterShAvpFactory getClientAvpFactory() {
            return DiameterShClientResourceAdaptor.this.shAvpFactory;
        }

        private ShClientMessageFactory getSessionShMessageFactory(AppSession session) {
            return new ShClientMessageFactoryImpl((Session)session.getSessions().get(0), DiameterShClientResourceAdaptor.this.stack);
        }

        public DiameterIdentity[] getConnectedPeers() {
            if (this.ra.stack != null) {
                try {
                    List peers = ((PeerTable)DiameterShClientResourceAdaptor.this.stack.unwrap(PeerTable.class)).getPeerTable();
                    DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                    int i = 0;
                    for (Peer peer : peers) {
                        DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                        result[i++] = identity;
                    }
                    return result;
                }
                catch (Exception e) {
                    DiameterShClientResourceAdaptor.this.tracer.severe("Failure getting peer list.", (Throwable)e);
                }
            }
            return null;
        }

        public int getPeerCount() {
            return this.getConnectedPeers().length;
        }

        public Validator getValidator() {
            return this.validator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShClientSessionFactory
    extends ShSessionFactoryImpl {
        DiameterShClientResourceAdaptor ra;

        public ShClientSessionFactory(DiameterShClientResourceAdaptor ra, SessionFactory sf) {
            super(sf);
            this.ra = null;
            this.ra = ra;
        }

        public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
            try {
                if (aClass == ClientShSession.class) {
                    ShClientSessionImpl clientSession = (ShClientSessionImpl)super.getNewSession(sessionId, aClass, applicationId, args);
                    return clientSession;
                }
                throw new IllegalArgumentException("Wrong session class!![" + aClass + "]. Supported[" + ClientShSession.class + "]");
            }
            catch (Exception e) {
                DiameterShClientResourceAdaptor.this.tracer.severe("Failure to obtain new Accounting Session.", (Throwable)e);
                return null;
            }
        }

        public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            if (DiameterShClientResourceAdaptor.this.tracer.isFineEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.fine("Diameter ShClient RA :: doOtherEvent :: appSession[" + appSession + "], Request[" + request + "], Answer[" + answer + "]");
            }
            this.ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), answer != null ? answer.getMessage() : request.getMessage());
        }

        public void doProfileUpdateAnswerEvent(ClientShSession appSession, org.jdiameter.api.sh.events.ProfileUpdateRequest request, ProfileUpdateAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            if (DiameterShClientResourceAdaptor.this.tracer.isFineEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.fine("doProfileUpdateAnswerEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + answer + "]");
            }
            this.ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), answer.getMessage());
        }

        public void doPushNotificationRequestEvent(ClientShSession appSession, PushNotificationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            if (DiameterShClientResourceAdaptor.this.tracer.isFineEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.fine("doPushNotificationRequestEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + null + "]");
            }
            this.ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), request.getMessage());
        }

        public void doSubscribeNotificationsAnswerEvent(ClientShSession appSession, org.jdiameter.api.sh.events.SubscribeNotificationsRequest request, SubscribeNotificationsAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            if (DiameterShClientResourceAdaptor.this.tracer.isFineEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.fine("doSubscribeNotificationsAnswerEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + answer + "]");
            }
            this.ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), answer.getMessage());
        }

        public void doUserDataAnswerEvent(ClientShSession appSession, org.jdiameter.api.sh.events.UserDataRequest request, UserDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
            if (DiameterShClientResourceAdaptor.this.tracer.isFineEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.fine("doUserDataAnswerEvent :: appSession[" + appSession + "], request[" + request + "], answer[" + answer + "]");
            }
            this.ra.fireEvent(((Session)appSession.getSessions().get(0)).getSessionId(), answer.getMessage());
        }

        public void stateChanged(Enum oldState, Enum newState) {
            if (DiameterShClientResourceAdaptor.this.tracer.isInfoEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.info("Diameter Sh ClientSessionFactory :: stateChanged :: oldState[" + oldState + "], newState[" + newState + "]");
            }
        }

        public void stateChanged(AppSession source, Enum oldState, Enum newState) {
            if (DiameterShClientResourceAdaptor.this.tracer.isInfoEnabled()) {
                DiameterShClientResourceAdaptor.this.tracer.info("Diameter Sh ClientSessionFactory :: stateChanged :: source[" + source + "] :: oldState[" + oldState + "], newState[" + newState + "]");
            }
        }

        public AppAnswerEvent createProfileUpdateAnswer(Answer answer) {
            return new AppAnswerEventImpl(answer);
        }

        public AppRequestEvent createProfileUpdateRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public AppAnswerEvent createPushNotificationAnswer(Answer answer) {
            return new AppAnswerEventImpl(answer);
        }

        public AppRequestEvent createPushNotificationRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public AppAnswerEvent createSubscribeNotificationsAnswer(Answer answer) {
            return new AppAnswerEventImpl(answer);
        }

        public AppRequestEvent createSubscribeNotificationsRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public AppAnswerEvent createUserDataAnswer(Answer answer) {
            return new AppAnswerEventImpl(answer);
        }

        public AppRequestEvent createUserDataRequest(Request request) {
            return new AppRequestEventImpl((Message)request);
        }

        public long getApplicationId() {
            return ((ApplicationId)DiameterShClientResourceAdaptor.this.authApplicationIds.get(0)).getAuthAppId();
        }

        public long getMessageTimeout() {
            return this.ra.messageTimeout;
        }
    }
}

