/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.VendorSpecificApplicationIdAvp;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.events.avp.SupportedApplicationsAvp;
import net.java.slee.resource.diameter.sh.events.avp.SupportedFeaturesAvp;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.diameter.sh.events.avp.SupportedApplicationsAvpImpl;
import org.mobicents.slee.resource.diameter.sh.events.avp.SupportedFeaturesAvpImpl;
import org.mobicents.slee.resource.diameter.sh.events.avp.UserIdentityAvpImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DiameterShAvpFactoryImpl
implements DiameterShAvpFactory {
    protected DiameterAvpFactory baseAvpFactory = null;
    private DocumentBuilder docBuilder = null;
    protected final transient Logger logger = Logger.getLogger(this.getClass());

    public DiameterShAvpFactoryImpl(DiameterAvpFactory baseAvpFactory) {
        this.baseAvpFactory = baseAvpFactory;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(DiameterShAvpFactoryImpl.class.getClassLoader().getResource("ShDataType.xsd"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setSchema(schema);
            this.docBuilder = factory.newDocumentBuilder();
            this.docBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to initialize Sh-Data schema validator. No validation will be available.", (Throwable)e);
        }
    }

    public SupportedApplicationsAvp createSupportedApplications(long authApplicationId, long acctApplicationId, VendorSpecificApplicationIdAvp vendorSpecificApplicationId) {
        SupportedApplicationsAvp avp = this.createSupportedApplications();
        avp.setAuthApplicationId(authApplicationId);
        avp.setAcctApplicationId(acctApplicationId);
        avp.setVendorSpecificApplicationId(vendorSpecificApplicationId);
        return avp;
    }

    public SupportedApplicationsAvp createSupportedApplications() {
        return (SupportedApplicationsAvp)AvpUtilities.createAvp((int)631, (long)10415L, null, SupportedApplicationsAvpImpl.class);
    }

    public SupportedFeaturesAvp createSupportedFeatures(long vendorId, long featureListId, long featureList) {
        SupportedFeaturesAvp avp = this.createSupportedFeatures();
        avp.setVendorId(vendorId);
        avp.setFeatureListId(featureListId);
        avp.setFeatureList(featureList);
        return avp;
    }

    public SupportedFeaturesAvp createSupportedFeatures() {
        return (SupportedFeaturesAvp)AvpUtilities.createAvp((int)628, (long)10415L, null, SupportedFeaturesAvpImpl.class);
    }

    public UserIdentityAvp createUserIdentity() {
        return (UserIdentityAvp)AvpUtilities.createAvp((int)700, (long)10415L, null, UserIdentityAvpImpl.class);
    }

    public DiameterAvpFactory getBaseFactory() {
        return this.baseAvpFactory;
    }

    public boolean validateUserData(byte[] userData) {
        if (this.docBuilder != null && userData != null) {
            try {
                this.docBuilder.parse(new ByteArrayInputStream(userData));
                return true;
            }
            catch (Throwable e) {
                this.logger.error((Object)"Failure while validating User-Data:", e);
            }
        }
        return false;
    }
}

