/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.FireableEventType;
import org.jdiameter.api.Message;

public class EventIDCache {
    private static final String BASE_PACKAGE_PREFIX = "net.java.slee.resource.diameter.base.events.";
    private static final String SH_PACKAGE_PREFIX = "net.java.slee.resource.diameter.sh.events.";
    public static Map<Integer, String> eventNames = new ConcurrentHashMap<Integer, String>();
    public static final String ERROR_ANSWER = "net.java.slee.resource.diameter.base.events.ErrorAnswer";
    public static final String EXTENSION_DIAMETER_MESSAGE = "net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage";
    private static final String VENDOR = "java.net";
    private static final String VERSION = "0.8";
    private ConcurrentHashMap<String, FireableEventType> eventIds = new ConcurrentHashMap();

    public FireableEventType getEventId(EventLookupFacility eventLookupFacility, Message message) {
        FireableEventType eventID = null;
        if (message.isError()) {
            eventID = this.getEventId(eventLookupFacility, ERROR_ANSWER);
        } else {
            int commandCode = message.getCommandCode();
            boolean isRequest = message.isRequest();
            String eventName = eventNames.get(commandCode);
            eventID = eventName != null ? this.getEventId(eventLookupFacility, eventName + (isRequest ? "Request" : "Answer")) : this.getEventId(eventLookupFacility, EXTENSION_DIAMETER_MESSAGE);
        }
        return eventID;
    }

    private FireableEventType getEventId(EventLookupFacility eventLookupFacility, String eventName) {
        FireableEventType eventType = this.eventIds.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, VENDOR, VERSION));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (eventType != null) {
                this.eventIds.put(eventName, eventType);
            }
        }
        return eventType;
    }

    static {
        HashMap<Integer, String> eventsTemp = new HashMap<Integer, String>();
        eventsTemp.put(307, "net.java.slee.resource.diameter.sh.events.ProfileUpdate");
        eventsTemp.put(309, "net.java.slee.resource.diameter.sh.events.PushNotification");
        eventsTemp.put(308, "net.java.slee.resource.diameter.sh.events.SubscribeNotifications");
        eventsTemp.put(306, "net.java.slee.resource.diameter.sh.events.UserData");
        eventsTemp.put(274, "net.java.slee.resource.diameter.base.events.AbortSession");
        eventsTemp.put(271, "net.java.slee.resource.diameter.base.events.Accounting");
        eventsTemp.put(257, "net.java.slee.resource.diameter.base.events.CapabilitiesExchange");
        eventsTemp.put(280, "net.java.slee.resource.diameter.base.events.DeviceWatchdog");
        eventsTemp.put(282, "net.java.slee.resource.diameter.base.events.DisconnectPeer");
        eventsTemp.put(258, "net.java.slee.resource.diameter.base.events.ReAuth");
        eventsTemp.put(275, "net.java.slee.resource.diameter.base.events.SessionTermination");
        eventNames = Collections.unmodifiableMap(eventsTemp);
    }
}

