/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.NoSuchAvpException;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer;
import net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.client.events.UserDataAnswer;
import net.java.slee.resource.diameter.sh.client.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.ShServerMessageFactory;
import net.java.slee.resource.diameter.sh.server.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.server.events.UserDataRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.DiameterShAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.ProfileUpdateAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.PushNotificationRequestImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.UserDataAnswerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShServerMessageFactoryImpl
implements ShServerMessageFactory {
    protected Session session;
    protected Stack stack;
    protected DiameterMessageFactoryImpl baseFactory = null;
    protected DiameterShAvpFactoryImpl localFactory = null;
    private static Logger logger = Logger.getLogger(ShServerMessageFactoryImpl.class);
    protected ArrayList<DiameterAvp> avpList = new ArrayList();

    public ShServerMessageFactoryImpl(Session session, Stack stack) {
        this.session = session;
        this.stack = stack;
        this.baseFactory = new DiameterMessageFactoryImpl(this.session, this.stack, new DiameterIdentity[0]);
    }

    public ShServerMessageFactoryImpl(Stack stack) {
        this.stack = stack;
        this.baseFactory = new DiameterMessageFactoryImpl(this.stack);
    }

    public ShServerMessageFactoryImpl(DiameterMessageFactoryImpl baseMsgFactory, Session session, Stack stack, DiameterShAvpFactory localFactory) {
        this.session = session;
        this.stack = stack;
        this.baseFactory = baseMsgFactory;
        this.localFactory = (DiameterShAvpFactoryImpl)localFactory;
    }

    public ProfileUpdateAnswer createProfileUpdateAnswer(ProfileUpdateRequest request, long resultCode, boolean isExperimentalResult) {
        ProfileUpdateAnswer pua = this.createProfileUpdateAnswer(request);
        if (isExperimentalResult) {
            pua.setExperimentalResult(this.localFactory.getBaseFactory().createExperimentalResult(0L, resultCode));
        } else {
            pua.setResultCode(resultCode);
        }
        return pua;
    }

    public ProfileUpdateAnswer createProfileUpdateAnswer(ProfileUpdateRequest request) {
        ArrayList<Object> avps = new ArrayList<Object>();
        DiameterAvp sessionIdAvp = null;
        try {
            sessionIdAvp = this.localFactory.getBaseFactory().createAvp(0, 263, request.getSessionId());
            avps.add(sessionIdAvp);
        }
        catch (NoSuchAvpException e1) {
            e1.printStackTrace();
        }
        if (request.getUserIdentity() != null) {
            avps.add(request.getUserIdentity());
        }
        Message msg = this.createShMessage(request.getHeader(), avps.toArray(new DiameterAvp[avps.size()]));
        ProfileUpdateAnswerImpl answer = new ProfileUpdateAnswerImpl(msg);
        if (request.hasRouteRecords()) {
            answer.setRouteRecords(request.getRouteRecords());
        }
        this.addOrigin((DiameterMessage)answer);
        return answer;
    }

    public PushNotificationRequest createPushNotificationRequest(UserIdentityAvp userIdentity, byte[] userData) {
        PushNotificationRequest pnr = this.createPushNotificationRequest();
        pnr.setUserIdentity(userIdentity);
        pnr.setUserData(new String(userData));
        return pnr;
    }

    public PushNotificationRequest createPushNotificationRequest() {
        ArrayList<DiameterAvp> avps = new ArrayList<DiameterAvp>();
        if (this.session != null) {
            try {
                DiameterAvp sessionIdAvp = null;
                sessionIdAvp = this.localFactory.getBaseFactory().createAvp(0, 263, this.session.getSessionId());
                avps.add(sessionIdAvp);
            }
            catch (NoSuchAvpException e1) {
                e1.printStackTrace();
            }
        }
        Message msg = this.createShMessage(null, avps.toArray(new DiameterAvp[avps.size()]));
        PushNotificationRequestImpl request = new PushNotificationRequestImpl(msg);
        this.addOrigin((DiameterMessage)request);
        return request;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer(SubscribeNotificationsRequest request, long resultCode, boolean isExperimentalResult) {
        SubscribeNotificationsAnswer sna = this.createSubscribeNotificationsAnswer(request);
        if (isExperimentalResult) {
            sna.setExperimentalResult(this.localFactory.getBaseFactory().createExperimentalResult(0L, resultCode));
        } else {
            sna.setResultCode(resultCode);
        }
        return sna;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer(SubscribeNotificationsRequest request) {
        ArrayList<Object> avps = new ArrayList<Object>();
        DiameterAvp sessionIdAvp = null;
        try {
            sessionIdAvp = this.localFactory.getBaseFactory().createAvp(0, 263, request.getSessionId());
            avps.add(sessionIdAvp);
        }
        catch (NoSuchAvpException e1) {
            e1.printStackTrace();
        }
        if (request.getUserIdentity() != null) {
            avps.add(request.getUserIdentity());
        }
        Message msg = this.createShMessage(request.getHeader(), avps.toArray(new DiameterAvp[avps.size()]));
        SubscribeNotificationsAnswerImpl answer = new SubscribeNotificationsAnswerImpl(msg);
        if (request.hasRouteRecords()) {
            answer.setRouteRecords(request.getRouteRecords());
        }
        this.addOrigin((DiameterMessage)answer);
        return answer;
    }

    public UserDataAnswer createUserDataAnswer(UserDataRequest request, byte[] userData) {
        UserDataAnswer uda = this.createUserDataAnswer(request);
        uda.setUserData(new String(userData));
        return uda;
    }

    public UserDataAnswer createUserDataAnswer(UserDataRequest request, long resultCode, boolean isExperimentalResult) {
        UserDataAnswer uda = this.createUserDataAnswer(request);
        if (isExperimentalResult) {
            uda.setExperimentalResult(this.localFactory.getBaseFactory().createExperimentalResult(0L, resultCode));
        } else {
            uda.setResultCode(resultCode);
        }
        return uda;
    }

    public UserDataAnswer createUserDataAnswer(UserDataRequest request) {
        ArrayList<Object> avps = new ArrayList<Object>();
        DiameterAvp sessionIdAvp = null;
        try {
            sessionIdAvp = this.localFactory.getBaseFactory().createAvp(0, 263, request.getSessionId());
            avps.add(sessionIdAvp);
        }
        catch (NoSuchAvpException e1) {
            e1.printStackTrace();
        }
        if (request.getUserIdentity() != null) {
            avps.add(request.getUserIdentity());
        }
        Message msg = this.createShMessage(request.getHeader(), avps.toArray(new DiameterAvp[avps.size()]));
        UserDataAnswerImpl answer = new UserDataAnswerImpl(msg);
        if (request.hasRouteRecords()) {
            answer.setRouteRecords(request.getRouteRecords());
        }
        this.addOrigin((DiameterMessage)answer);
        return answer;
    }

    public DiameterMessageFactory getBaseMessageFactory() {
        return this.baseFactory;
    }

    public List<DiameterAvp> getInnerAvps() {
        return this.avpList;
    }

    public void addAvpToInnerList(DiameterAvp avp) {
        this.removeAvpFromInnerList(avp.getCode());
        this.avpList.add(avp);
    }

    public void removeAvpFromInnerList(int code) {
        Iterator<DiameterAvp> it = this.avpList.iterator();
        while (it.hasNext()) {
            if (it.next().getCode() != code) continue;
            it.remove();
        }
    }

    private Message createShMessage(DiameterHeader diameterHeader, DiameterAvp[] avps) throws IllegalArgumentException {
        boolean isRequest = diameterHeader == null;
        Message msg = null;
        if (!isRequest) {
            Message raw = this.createMessage(diameterHeader, avps);
            raw.setProxiable(true);
            raw.setRequest(false);
            msg = raw;
        } else {
            Message raw = this.createMessage(null, avps);
            raw.setProxiable(true);
            raw.setRequest(true);
            msg = raw;
        }
        return msg;
    }

    protected Message createMessage(DiameterHeader header, DiameterAvp[] avps) throws AvpNotAllowedException {
        try {
            Message msg = this.createRawMessage(header);
            AvpSet set = msg.getAvps();
            for (DiameterAvp avp : avps) {
                this.addAvp(avp, set);
            }
            if (msg.getAvps().getAvp(260) == null) {
                DiameterAvp avpVendorId = this.localFactory.getBaseFactory().createAvp(266, 10415);
                DiameterAvp avpAcctApplicationId = this.localFactory.getBaseFactory().createAvp(259, 0x1000001);
                DiameterAvp vendorSpecific = this.localFactory.getBaseFactory().createAvp(260, new DiameterAvp[]{avpVendorId, avpAcctApplicationId});
                msg.getAvps().addAvp(vendorSpecific.getCode(), vendorSpecific.byteArrayValue());
            }
            return msg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Message createRawMessage(DiameterHeader header) {
        int commandCode = 0;
        long endToEndId = 0L;
        long hopByHopId = 0L;
        ApplicationId aid = null;
        if (header != null) {
            commandCode = header.getCommandCode();
            endToEndId = header.getEndToEndId();
            hopByHopId = header.getHopByHopId();
            aid = ApplicationId.createByAuthAppId((long)header.getApplicationId());
        } else {
            commandCode = 309;
            endToEndId = (long)(Math.random() * 1000000.0);
            hopByHopId = (long)(Math.random() * 1000000.0) + 1L;
            aid = ApplicationId.createByAuthAppId((long)10415L, (long)0x1000001L);
        }
        try {
            Message msg = this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, aid, hopByHopId, endToEndId, new Avp[0]);
            return msg;
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (IllegalDiameterStateException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void addAvp(DiameterAvp avp, AvpSet set) {
        if (avp instanceof GroupedAvp) {
            DiameterAvp[] groupedAVPs;
            AvpSet avpSet = set.addGroupedAvp(avp.getCode(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
            for (DiameterAvp avpFromGroup : groupedAVPs = ((GroupedAvp)avp).getExtensionAvps()) {
                this.addAvp(avpFromGroup, avpSet);
            }
        } else if (avp != null) {
            set.addAvp(avp.getCode(), avp.byteArrayValue(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
        }
    }

    public void clean() {
        this.session = null;
        if (this.baseFactory != null) {
            this.baseFactory.clean();
        }
    }

    private void addOrigin(DiameterMessage msg) {
        if (!msg.hasOriginHost()) {
            msg.setOriginHost(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getUri().getFQDN().toString()));
        }
        if (!msg.hasOriginRealm()) {
            msg.setOriginRealm(new DiameterIdentity(this.stack.getMetaData().getLocalPeer().getRealmName()));
        }
    }
}

