/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.server.ShServerActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.sh.server.ShServerMessageFactory;
import net.java.slee.resource.diameter.sh.server.ShServerProvider;
import net.java.slee.resource.diameter.sh.server.events.PushNotificationAnswer;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.server.impl.app.sh.ShServerSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.DiameterShAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.ProfileUpdateAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.PushNotificationRequestImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.UserDataAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerActivityImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerSubscriptionActivityImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.ProfileUpdateRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.PushNotificationAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.events.UserDataRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.handlers.ShServerSessionFactory;
import org.mobicents.slee.resource.diameter.sh.server.handlers.ShServerSessionListener;

public class DiameterShServerResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
ShServerSessionListener {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger(DiameterShServerResourceAdaptor.class);
    private Stack stack;
    private SessionFactory sessionFactory = null;
    private long messageTimeout = 5000L;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private ResourceAdaptorState state;
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    public static final Map<Integer, String> events;
    private transient ShServerProviderImpl serverProvider = null;
    private transient ConcurrentHashMap<ActivityHandle, DiameterActivity> activities = null;
    private transient ShServerActivityContextInterfaceFactory acif = null;
    private DiameterAvpFactoryImpl diameterAvpFactory = new DiameterAvpFactoryImpl();
    private DiameterShAvpFactory localFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter ShServer RA :: activityEnded :: handle[" + handle + "."));
        }
        if (this.activities != null) {
            ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
            synchronized (concurrentHashMap) {
                this.activities.remove(handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter ShServer RA :: activityUnreferenced :: handle[" + handle + "]."));
        }
        this.activityEnded(handle);
    }

    public void entityActivated() throws ResourceException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Diameter ShServer RA :: entityActivated.");
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Activating Diameter ShServer RA Entity");
            }
            this.initializeNamingContext();
            this.activities = new ConcurrentHashMap();
            this.state = ResourceAdaptorState.CONFIGURED;
        }
        catch (Exception e) {
            logger.error((Object)"Error Configuring Diameter ShServer RA Entity", (Throwable)e);
        }
        try {
            ObjectName diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            String operation = "getMultiplexerMBean";
            Object object = SleeContainer.lookupFromJndi().getMBeanServer().invoke(diameterMultiplexerObjectName, operation, params, signature);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.state = ResourceAdaptorState.ACTIVE;
            this.sessionFactory = this.stack.getSessionFactory();
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerShSession.class, (IAppSessionFactory)new ShServerSessionFactory(this.sessionFactory, this, this.messageTimeout));
        }
        catch (Exception e) {
            logger.error((Object)"Error Activating Diameter ShServer RA Entity", (Throwable)e);
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.info((Object)("Diameter ShServer RA :: entityCreated :: bootstrapContext[" + bootstrapContext + "]."));
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityDeactivated() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Diameter ShServer RA :: entityDeactivated.");
            logger.info((Object)"Diameter ShServer RA :: Cleaning RA Activities.");
        }
        ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            this.activities.clear();
        }
        this.activities = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Diameter ShServer RA :: Cleaning naming context.");
        }
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Diameter ShServer RA :: Cannot unbind naming context.");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Diameter ShServer RA :: RA Stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityDeactivating() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Diameter ShServer RA :: entityDeactivating.");
        }
        this.state = ResourceAdaptorState.STOPPING;
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to unregister Sh-Server RA from Diameter Mux", (Throwable)e);
        }
        ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            for (ActivityHandle activityHandle : this.activities.keySet()) {
                try {
                    logger.info((Object)("Ending activity [" + activityHandle + "]"));
                    this.activities.get(activityHandle).endActivity();
                }
                catch (Exception e) {
                    logger.error((Object)"Error Deactivating Activity", (Throwable)e);
                }
            }
        }
        logger.info((Object)"Diameter ShServer RA :: entityDeactivating completed.");
    }

    public void entityRemoved() {
        this.acif = null;
        this.activities = null;
        this.bootstrapContext = null;
        this.eventLookup = null;
        this.sleeEndpoint = null;
        this.stack = null;
        logger.info((Object)"Diameter ShServer RA :: entityRemoved.");
    }

    private void initializeNamingContext() throws NamingException {
        ResourceAdaptorEntity resourceAdaptorEntity;
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        try {
            resourceAdaptorEntity = container.getResourceAdaptorEntity(entityName);
        }
        catch (UnrecognizedResourceAdaptorEntityException uraee) {
            throw new NamingException("Failure setting up Naming Context. RA Entity not found.");
        }
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new ShServerActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.info((Object)("Diameter ShServer RA :: Registering in JNDI :: Prefix[" + prefix + "], Name[" + name + "]."));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
                logger.info((Object)"Diameter ShServer RA :: Registered in JNDI successfully.");
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.info((Object)"Failure initializing name context.", (Throwable)iobe);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.info((Object)("Diameter ShServer RA :: Unregistering from JNDI :: Name[" + javaJNDIName + "]."));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.info((Object)"Diameter ShServer RA :: Unregistered from JNDI successfully.");
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.error((Object)"Failure cleaning name context.", (Throwable)iobe);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, new ApplicationId[]{ApplicationId.createByAuthAppId((long)10415L, (long)0x1000001L)});
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        this.serverProvider = new ShServerProviderImpl(this);
        this.localFactory = new DiameterShAvpFactoryImpl((DiameterAvpFactory)this.diameterAvpFactory);
        logger.info((Object)"Diameter ShServer RA :: Successfully initialized stack.");
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int eventID, Address address, int flags, FailureReason reason) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter ShServer RA :: eventProcessingFailed :: handle[" + handle + "], event[" + event + "], eventID[" + eventID + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "]."));
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int eventID, Address address, int flags) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter ShServer RA :: eventProcessingSuccessful :: handle[" + handle + "], event[" + event + "], eventID[" + eventID + "], address[" + address + "], flags[" + flags + "]."));
        }
    }

    public Object getActivity(ActivityHandle handle) {
        return this.activities.get(handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter ShServer RA :: getActivityHandle :: activity[" + activity + "]."));
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivity inActivity = (DiameterActivity)activity;
        for (Map.Entry<ActivityHandle, DiameterActivity> activityInfo : this.activities.entrySet()) {
            DiameterActivity curActivity = activityInfo.getValue();
            if (!curActivity.equals(inActivity)) continue;
            return activityInfo.getKey();
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String className) {
        return this.serverProvider;
    }

    public Answer processRequest(Request request) {
        try {
            this.serverProvider.createActivity(request);
        }
        catch (CreateActivityException e) {
            logger.error((Object)"Failed to create activity", (Throwable)e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request req, Answer ans) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter ShServer RA :: receivedSuccessMessage :: Request[" + req + "], Answer[" + ans + "]."));
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Received Message Result-Code: " + ans.getResultCode().getUnsigned32()));
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request req) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Diameter Base RA :: timeoutExpired :: Request[" + req + "]."));
        }
        DiameterActivityHandle ah = new DiameterActivityHandle(req.getSessionId());
        try {
            this.activities.get(ah).endActivity();
        }
        catch (Exception e) {
            logger.error((Object)"Failure processing timeout message.", (Throwable)e);
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                logger.error((Object)"Failure getting peer list.", (Throwable)e);
            }
        }
        return null;
    }

    public void fireEvent(ActivityHandle handle, String name, Request request, Answer answer) {
        try {
            int eventID = this.eventLookup.getEventID(name, "java.net", "0.8");
            DiameterMessage event = this.createEvent(request, answer);
            Object activity = this.getActivity(handle);
            if (activity instanceof ShServerActivityImpl) {
                ((ShServerActivityImpl)((Object)activity)).fetchSessionData(event, true);
            } else if (activity instanceof ShServerSubscriptionActivityImpl) {
                ((ShServerSubscriptionActivityImpl)((Object)activity)).fetchSessionData(event, true);
            }
            this.sleeEndpoint.fireEvent(handle, (Object)event, eventID, null);
        }
        catch (Exception e) {
            logger.warn((Object)"Can not send event", (Throwable)e);
        }
    }

    public DiameterMessage createEvent(Request request, Answer answer) throws OperationNotSupportedException {
        int commandCode;
        if (request == null && answer == null) {
            return null;
        }
        int n = commandCode = request != null ? request.getCommandCode() : answer.getCommandCode();
        if (answer != null && answer.isError()) {
            return new ErrorAnswerImpl((Message)answer);
        }
        switch (commandCode) {
            case 309: {
                return request != null ? new PushNotificationRequestImpl((Message)request) : new PushNotificationAnswerImpl((Message)answer);
            }
            case 307: {
                return request != null ? new ProfileUpdateRequestImpl((Message)request) : new ProfileUpdateAnswerImpl((Message)answer);
            }
            case 308: {
                return request != null ? new SubscribeNotificationsRequestImpl((Message)request) : new SubscribeNotificationsAnswerImpl((Message)answer);
            }
            case 306: {
                return request != null ? new UserDataRequestImpl((Message)request) : new UserDataAnswerImpl((Message)answer);
            }
        }
        return new ExtensionDiameterMessageImpl((Message)(request != null ? request : answer));
    }

    private void activityCreated(DiameterActivity ac) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            this.sleeEndpoint.activityStarted((ActivityHandle)activity.getActivityHandle());
            this.activities.put((ActivityHandle)activity.getActivityHandle(), (DiameterActivity)activity);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Activity started [" + activity.getActivityHandle() + "]"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error creating activity", (Throwable)e);
        }
    }

    public void queryLiveness(ActivityHandle handle) {
    }

    public void serviceActivated(String serviceKey) {
    }

    public void serviceDeactivated(String serviceKey) {
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] resourceOptions) {
    }

    public void serviceUninstalled(String serviceKey) {
    }

    public void sessionDestroyed(String sessionId, ClientShSession session) {
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to end activity with handle[" + this.getActivityHandle(sessionId)));
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public void sessionCreated(ServerShSession session, boolean isSubscription) {
        if (this.getActivity((ActivityHandle)this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId())) != null) {
            logger.warn((Object)"Activity found for created Credit-Control Server Session. Shouldn't exist. Aborting.");
            return;
        }
        DiameterMessageFactoryImpl baseMsgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        ShServerMessageFactoryImpl shServerMsgFactory = new ShServerMessageFactoryImpl(baseMsgFactory, (Session)session.getSessions().get(0), this.stack, this.localFactory);
        DiameterActivityImpl activity = null;
        if (isSubscription) {
            ShServerSubscriptionActivityImpl _activity = new ShServerSubscriptionActivityImpl(shServerMsgFactory, this.localFactory, session, this.messageTimeout, null, null, this.sleeEndpoint);
            _activity.setSessionListener(this);
            activity = _activity;
        } else {
            ShServerActivityImpl _activity = new ShServerActivityImpl(shServerMsgFactory, this.localFactory, session, this.messageTimeout, null, null, this.sleeEndpoint);
            _activity.setSessionListener(this);
            activity = _activity;
        }
        this.activityCreated((DiameterActivity)activity);
    }

    public void sessionDestroyed(String sessionId, ServerShSession session) {
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            logger.error((Object)("Failure Ending Activity with Session-Id[" + sessionId + "]"), (Throwable)e);
        }
    }

    public boolean sessionExists(String sessionId) {
        return this.activities.containsKey(new DiameterActivityHandle(sessionId));
    }

    public void sessionDestroyed(String sessionId, Object appSession) {
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            logger.error((Object)("Failure Ending Activity with Session-Id[" + sessionId + "]"), (Throwable)e);
        }
    }

    public void fireEvent(String sessionId, String name, Request request, Answer answer) {
        this.fireEvent((ActivityHandle)this.getActivityHandle(sessionId), name, request, answer);
    }

    static {
        HashMap<Integer, String> eventsTemp = new HashMap<Integer, String>();
        eventsTemp.put(307, "ProfileUpdate");
        eventsTemp.put(309, "PushNotification");
        eventsTemp.put(306, "UserData");
        eventsTemp.put(308, "SubscribeNotifications");
        events = Collections.unmodifiableMap(eventsTemp);
    }

    class ShServerProviderImpl
    implements ShServerProvider {
        private DiameterShServerResourceAdaptor ra = null;

        public ShServerProviderImpl(DiameterShServerResourceAdaptor diameterShServerResourceAdaptor2) {
            this.ra = diameterShServerResourceAdaptor2;
        }

        public DiameterActivity createActivity(Request request) throws CreateActivityException {
            int commandCode = request.getCommandCode();
            String sessionId = request.getSessionId();
            ApplicationId appId = ApplicationId.createByAuthAppId((long)10415L, (long)0x1000001L);
            if (!events.keySet().contains(commandCode)) {
                throw new CreateActivityException("Cant create activity for unknown command code: " + commandCode);
            }
            try {
                ShServerSessionImpl session = (ShServerSessionImpl)((ISessionFactory)DiameterShServerResourceAdaptor.this.sessionFactory).getNewAppSession(sessionId, appId, ServerShSession.class, new Object[]{request});
                session.processRequest(request);
            }
            catch (Exception e) {
                throw new CreateActivityException((Throwable)e);
            }
            return (DiameterActivity)DiameterShServerResourceAdaptor.this.getActivity((ActivityHandle)DiameterShServerResourceAdaptor.this.getActivityHandle(sessionId));
        }

        public ShServerMessageFactory getServerMessageFactory() {
            DiameterMessageFactoryImpl baseMsgFactory = new DiameterMessageFactoryImpl(null, DiameterShServerResourceAdaptor.this.stack, new DiameterIdentity[0]);
            ShServerMessageFactoryImpl shServerMsgFactory = new ShServerMessageFactoryImpl(baseMsgFactory, null, DiameterShServerResourceAdaptor.this.stack, DiameterShServerResourceAdaptor.this.localFactory);
            return shServerMsgFactory;
        }

        public DiameterShAvpFactory getAvpFactory() {
            return DiameterShServerResourceAdaptor.this.localFactory;
        }

        public PushNotificationAnswer pushNotificationRequest(PushNotificationRequest message) throws IOException {
            if (message == null) {
                throw new IOException("Cant send null message");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new IllegalArgumentException("Session Id must not be null.");
                }
                Session session = DiameterShServerResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                return new PushNotificationAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Failed to send due to: " + e);
            }
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }
    }
}

