/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server;

import java.io.IOException;
import java.util.ArrayList;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AuthSessionStateType;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.client.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.client.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.ShServerActivity;
import net.java.slee.resource.diameter.sh.server.ShServerMessageFactory;
import net.java.slee.resource.diameter.sh.server.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.server.events.UserDataRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.common.api.app.sh.ShSessionState;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.jdiameter.common.impl.validation.JAvpNotAllowedException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.DiameterShMessageImpl;
import org.mobicents.slee.resource.diameter.sh.client.events.avp.UserIdentityAvpImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.server.handlers.ShServerSessionListener;

public class ShServerActivityImpl
extends DiameterActivityImpl
implements ShServerActivity,
StateChangeListener {
    protected ServerShSession serverSession = null;
    protected net.java.slee.resource.diameter.sh.client.ShSessionState state = net.java.slee.resource.diameter.sh.client.ShSessionState.NOTSUBSCRIBED;
    protected ShServerSessionListener listener = null;
    protected DiameterShAvpFactory shAvpFactory = null;
    protected ShServerMessageFactoryImpl messageFactory = null;
    protected UserIdentityAvp userIdentity;
    protected DataReferenceType[] dataReferenceType;
    protected AuthSessionStateType authSessionState;
    protected DiameterIdentity remoteRealm;
    protected DiameterIdentity remoteHost;
    protected ArrayList<DiameterMessageImpl> stateMessages = new ArrayList();

    public ShServerActivityImpl(ShServerMessageFactory shServerMessageFactory, DiameterShAvpFactory diameterShAvpFactory, ServerShSession session, long timeout, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, SleeEndpoint endpoint) {
        super(null, null, null, (EventListener)session, timeout, destinationHost, destinationRealm, endpoint);
        this.serverSession = session;
        this.serverSession.addStateChangeNotification((StateChangeListener)this);
        super.setCurrentWorkingSession((Session)this.serverSession.getSessions().get(0));
        this.shAvpFactory = diameterShAvpFactory;
        this.messageFactory = (ShServerMessageFactoryImpl)shServerMessageFactory;
    }

    public net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer createProfileUpdateAnswer(long resultCode, boolean isExperimentalResult) {
        net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 307) continue;
            ProfileUpdateRequest msg = (ProfileUpdateRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createProfileUpdateAnswer(msg, resultCode, isExperimentalResult);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer createProfileUpdateAnswer() {
        net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 307) continue;
            ProfileUpdateRequest msg = (ProfileUpdateRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createProfileUpdateAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.client.events.UserDataAnswer createUserDataAnswer(byte[] userData) {
        net.java.slee.resource.diameter.sh.client.events.UserDataAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 306) continue;
            UserDataRequest msg = (UserDataRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createUserDataAnswer(msg, userData);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.client.events.UserDataAnswer createUserDataAnswer(long resultCode, boolean isExperimentalResult) {
        net.java.slee.resource.diameter.sh.client.events.UserDataAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 306) continue;
            UserDataRequest msg = (UserDataRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createUserDataAnswer(msg, resultCode, isExperimentalResult);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.client.events.UserDataAnswer createUserDataAnswer() {
        net.java.slee.resource.diameter.sh.client.events.UserDataAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 306) continue;
            UserDataRequest msg = (UserDataRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createUserDataAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer(long resultCode, boolean isExperimentalResult) {
        SubscribeNotificationsAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 308) continue;
            SubscribeNotificationsRequest msg = (SubscribeNotificationsRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createSubscribeNotificationsAnswer(msg, resultCode, isExperimentalResult);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer() {
        SubscribeNotificationsAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 308) continue;
            SubscribeNotificationsRequest msg = (SubscribeNotificationsRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createSubscribeNotificationsAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public void sendSubscribeNotificationsAnswer(SubscribeNotificationsAnswer message) throws IOException {
        DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
        this.fetchSessionData((DiameterMessage)msg, false);
        try {
            this.serverSession.sendSubscribeNotificationsAnswer((org.jdiameter.api.sh.events.SubscribeNotificationsAnswer)new SubscribeNotificationsAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendUserDataAnswer(net.java.slee.resource.diameter.sh.client.events.UserDataAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.serverSession.sendUserDataAnswer((UserDataAnswer)new UserDataAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public void sendProfileUpdateAnswer(net.java.slee.resource.diameter.sh.client.events.ProfileUpdateAnswer message) throws IOException {
        DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
        this.fetchSessionData((DiameterMessage)msg, false);
        try {
            this.serverSession.sendProfileUpdateAnswer((ProfileUpdateAnswer)new ProfileUpdateAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (JAvpNotAllowedException e) {
            AvpNotAllowedException anae = new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            throw anae;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException ioe = new IOException("Failed to send message, due to: " + e);
            throw ioe;
        }
    }

    public Object getDiameterAvpFactory() {
        return this.avpFactory;
    }

    public Object getDiameterMessageFactory() {
        return this.messageFactory;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ShSessionState _state = (ShSessionState)newState;
        switch (_state) {
            case NOTSUBSCRIBED: {
                break;
            }
            case SUBSCRIBED: {
                break;
            }
            case TERMINATED: {
                this.state = net.java.slee.resource.diameter.sh.client.ShSessionState.TERMINATED;
                this.listener.sessionDestroyed(this.getSessionId(), this.serverSession);
                this.serverSession.removeStateChangeNotification((StateChangeListener)this);
                this.messageFactory.clean();
                this.messageFactory = null;
                this.serverSession = null;
                this.session = null;
                this.shAvpFactory = null;
                this.stateMessages.clear();
                this.listener = null;
                super.clean();
            }
        }
    }

    public Object getSessionListener() {
        return this.listener;
    }

    public void setSessionListener(Object ra) {
        this.listener = (ShServerSessionListener)ra;
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest() && incoming) {
            if (this.remoteRealm == null) {
                this.remoteRealm = msg.getOriginRealm();
            }
            if (this.remoteHost == null) {
                this.remoteHost = msg.getOriginHost();
            }
            if (this.userIdentity == null) {
                try {
                    AvpRepresentation rep = AvpDictionary.INSTANCE.getAvp(700, 10415L);
                    this.userIdentity = new UserIdentityAvpImpl(700, 10415L, rep.getRuleMandatoryAsInt(), rep.getRuleProtectedAsInt(), AvpUtilities.getAvpAsGrouped((int)700, (long)10415L, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.authSessionState == null) {
                try {
                    this.authSessionState = AuthSessionStateType.fromInt((int)AvpUtilities.getAvpAsInteger32((int)277, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.stateMessages.add((DiameterMessageImpl)msg);
        }
    }

    private void clean(DiameterShMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }
}

