/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server.handlers;

import javax.slee.resource.ActivityHandle;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.ServerShSessionListener;
import org.jdiameter.api.sh.events.ProfileUpdateRequest;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.ProfileUpdateRequestImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationAnswerImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationRequestImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsRequestImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataRequestImpl;
import org.jdiameter.server.impl.app.sh.ShServerSessionImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.sh.server.DiameterShServerResourceAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShServerSessionFactory
implements IAppSessionFactory,
ServerShSessionListener,
StateChangeListener,
IShMessageFactory {
    protected SessionFactory sessionFactory = null;
    protected DiameterShServerResourceAdaptor resourceAdaptor = null;
    protected static final Logger logger = Logger.getLogger(ShServerSessionFactory.class);
    protected long messageTimeout = 5000L;

    public ShServerSessionFactory(SessionFactory sessionFactory, DiameterShServerResourceAdaptor diameterShServerResourceAdaptor, long messageTimeout) {
        this.sessionFactory = sessionFactory;
        this.resourceAdaptor = diameterShServerResourceAdaptor;
        this.messageTimeout = messageTimeout;
    }

    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        if (aClass == ServerShSession.class) {
            ShServerSessionImpl serverSession = null;
            if (args == null || args.length <= 0 || !(args[0] instanceof Request)) {
                throw new IllegalArgumentException("Can't create Sh-Server Session: Unknown request type.");
            }
            Request request = (Request)args[0];
            serverSession = new ShServerSessionImpl(sessionId, (IShMessageFactory)this, this.sessionFactory, (ServerShSessionListener)this);
            serverSession.addStateChangeNotification((StateChangeListener)this);
            this.resourceAdaptor.sessionCreated((ServerShSession)serverSession, request.getCommandCode() == 308);
            return serverSession;
        }
        throw new IllegalArgumentException("Wrong session class. Class[" + aClass + "]. Supported[" + ServerShSession.class + "]");
    }

    private void doMessage(String name, AppSession appSession, AppEvent message, boolean isRequest) throws InternalException {
        DiameterActivityHandle handle = new DiameterActivityHandle(((Session)appSession.getSessions().get(0)).getSessionId());
        if (isRequest) {
            this.resourceAdaptor.fireEvent((ActivityHandle)handle, name, (Request)message.getMessage(), null);
        } else {
            this.resourceAdaptor.fireEvent((ActivityHandle)handle, name, null, (Answer)message.getMessage());
        }
    }

    public void doOtherEvent(AppSession session, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        DiameterActivityHandle handle = new DiameterActivityHandle(((Session)session.getSessions().get(0)).getSessionId());
        logger.info((Object)("Diameter ShServer RA :: doOtherEvent :: appSession[" + session + "], Request[" + request + "], Answer[" + answer + "]"));
        if (answer != null) {
            if (answer.getMessage().isError()) {
                this.resourceAdaptor.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ErrorAnswer", null, (Answer)answer.getMessage());
            } else {
                this.resourceAdaptor.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage", null, (Answer)answer.getMessage());
            }
        } else {
            this.resourceAdaptor.fireEvent((ActivityHandle)handle, "net.java.slee.resource.diameter.base.events.ExtensionDiameterMessage", (Request)request.getMessage(), null);
        }
    }

    public void doProfileUpdateRequestEvent(ServerShSession session, ProfileUpdateRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.doMessage("net.java.slee.resource.diameter.sh.ProfileUpdateRequest", (AppSession)session, (AppEvent)request, true);
    }

    public void doPushNotificationAnswerEvent(ServerShSession session, PushNotificationRequest request, PushNotificationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        if (answer.getMessage().isError()) {
            this.doMessage("net.java.slee.resource.diameter.base.events.ErrorAnswer", (AppSession)session, (AppEvent)answer, false);
        } else {
            this.doMessage("net.java.slee.resource.diameter.sh.PushNotificationAnswer", (AppSession)session, (AppEvent)answer, false);
        }
    }

    public void doSubscribeNotificationsRequestEvent(ServerShSession session, SubscribeNotificationsRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.doMessage("net.java.slee.resource.diameter.sh.SubscribeNotificationsRequest", (AppSession)session, (AppEvent)request, true);
    }

    public void doUserDataRequestEvent(ServerShSession session, UserDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.doMessage("net.java.slee.resource.diameter.sh.UserDataRequest", (AppSession)session, (AppEvent)request, true);
    }

    public void stateChanged(Enum oldState, Enum newState) {
    }

    public AppAnswerEvent createProfileUpdateAnswer(Answer answer) {
        return new ProfileUpdateAnswerImpl(answer);
    }

    public AppRequestEvent createProfileUpdateRequest(Request request) {
        return new ProfileUpdateRequestImpl(request);
    }

    public AppAnswerEvent createPushNotificationAnswer(Answer answer) {
        return new PushNotificationAnswerImpl(answer);
    }

    public AppRequestEvent createPushNotificationRequest(Request request) {
        return new PushNotificationRequestImpl(request);
    }

    public AppAnswerEvent createSubscribeNotificationsAnswer(Answer answer) {
        return new SubscribeNotificationsAnswerImpl(answer);
    }

    public AppRequestEvent createSubscribeNotificationsRequest(Request request) {
        return new SubscribeNotificationsRequestImpl(request);
    }

    public AppAnswerEvent createUserDataAnswer(Answer answer) {
        return new UserDataAnswerImpl(answer);
    }

    public AppRequestEvent createUserDataRequest(Request request) {
        return new UserDataRequestImpl(request);
    }

    public long getApplicationId() {
        return 0x1000001L;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }
}

