/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.events.PushNotificationAnswer;
import net.java.slee.resource.diameter.sh.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.server.ShServerActivity;
import net.java.slee.resource.diameter.sh.server.ShServerMessageFactory;
import net.java.slee.resource.diameter.sh.server.ShServerProvider;
import net.java.slee.resource.diameter.sh.server.ShServerSubscriptionActivity;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.server.impl.app.sh.ShServerSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.AbstractClusteredDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.sh.DiameterShAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.EventIDCache;
import org.mobicents.slee.resource.diameter.sh.events.ProfileUpdateAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.ProfileUpdateRequestImpl;
import org.mobicents.slee.resource.diameter.sh.events.PushNotificationAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.PushNotificationRequestImpl;
import org.mobicents.slee.resource.diameter.sh.events.SubscribeNotificationsAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.SubscribeNotificationsRequestImpl;
import org.mobicents.slee.resource.diameter.sh.events.UserDataAnswerImpl;
import org.mobicents.slee.resource.diameter.sh.events.UserDataRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerActivityImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerSubscriptionActivityImpl;
import org.mobicents.slee.resource.diameter.sh.server.handlers.ShServerSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiameterShServerResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface,
FaultTolerantResourceAdaptor<String, DiameterActivity> {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private List<ApplicationId> authApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private FaultTolerantResourceAdaptorContext<String, DiameterActivity> ftRAContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    private DiameterBaseMarshaler marshaler = new DiameterBaseMarshaler();
    private Stack stack;
    private SessionFactory sessionFactory = null;
    private long messageTimeout = 5000L;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private DiameterAvpFactory baseAvpFactory = null;
    private DiameterShAvpFactory shAvpFactory = null;
    private transient EventLookupFacility eventLookup = null;
    private transient DiameterActivityManagement activities = null;
    private transient ShServerProviderImpl raProvider = null;
    private static final int EVENT_FLAGS = DiameterShServerResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = ActivityFlags.setRequestSleeActivityGCCallback((int)2);
    private static final int MARSHALABLE_ACTIVITY_FLAGS = ActivityFlags.setSleeMayMarshal((int)DEFAULT_ACTIVITY_FLAGS);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterShServerResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<String, DiameterActivity> ctx) {
        this.ftRAContext = ctx;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRAContext = null;
    }

    public void dataRemoved(String arg0) {
        this.activities.remove(this.getActivityHandle(arg0));
    }

    public void failOver(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter ShServer RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", EMPTY_OBJECT_ARRAY, EMPTY_STRING_ARRAY);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.raProvider = new ShServerProviderImpl(this);
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.shAvpFactory = new DiameterShAvpFactoryImpl(this.baseAvpFactory);
            this.sessionFactory = this.stack.getSessionFactory();
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerShSession.class, (IAppSessionFactory)new ShServerSessionFactory(this.sessionFactory, this));
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter ShServer RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister ShServer RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShServer RA :: entityDeactivating completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: entityDeactivated.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShServer RA :: INACTIVE completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                appIds.add(ApplicationId.createByAuthAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
            this.authApplicationIds = appIds;
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        this.tracer.info("Diameter ShServer RA :: queryLiveness :: handle[" + handle + "].");
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: getActivity :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return null;
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShServer RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShServer RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        this.tracer.info("Diameter ShServer RA :: activityEnded :: handle[" + handle + ".");
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (handle instanceof DiameterActivityHandle) {
            this.endActivity((DiameterActivityHandle)handle);
        }
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                DiameterActivity activity = (DiameterActivity)this.getActivity(handle);
                if (activity instanceof ShServerActivityImpl) {
                    ((ShServerActivityImpl)activity).fetchSessionData((DiameterMessage)event, true);
                } else if (activity instanceof ShServerSubscriptionActivityImpl) {
                    ((ShServerSubscriptionActivityImpl)activity).fetchSessionData((DiameterMessage)event, true);
                }
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    public void endActivity(DiameterActivityHandle arg0) {
        this.sleeEndpoint.endActivity((ActivityHandle)arg0);
    }

    public void update(DiameterActivityHandle arg0, DiameterActivity arg1) {
        this.activities.update(arg0, arg1);
    }

    public ApplicationId[] getSupportedApplications() {
        return null;
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 309: {
                return isRequest ? new PushNotificationRequestImpl(message) : new PushNotificationAnswerImpl(message);
            }
            case 307: {
                return isRequest ? new ProfileUpdateRequestImpl(message) : new ProfileUpdateAnswerImpl(message);
            }
            case 308: {
                return isRequest ? new SubscribeNotificationsRequestImpl(message) : new SubscribeNotificationsAnswerImpl(message);
            }
            case 306: {
                return isRequest ? new UserDataRequestImpl(message) : new UserDataAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    public void sessionCreated(ServerShSession session, boolean isSubscription) {
        if (this.getActivity((ActivityHandle)this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId())) != null) {
            this.tracer.warning("Activity found for created Credit-Control Server Session. Shouldn't exist. Aborting.");
            return;
        }
        DiameterMessageFactoryImpl baseMsgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        ShServerMessageFactoryImpl shServerMsgFactory = new ShServerMessageFactoryImpl(baseMsgFactory, (Session)session.getSessions().get(0), this.stack, this.shAvpFactory);
        DiameterActivityImpl activity = null;
        if (isSubscription) {
            ShServerSubscriptionActivityImpl _activity = new ShServerSubscriptionActivityImpl(shServerMsgFactory, this.shAvpFactory, session, null, null);
            _activity.setSessionListener(this);
            activity = _activity;
        } else {
            ShServerActivityImpl _activity = new ShServerActivityImpl(shServerMsgFactory, this.shAvpFactory, session, null, null);
            _activity.setSessionListener(this);
            activity = _activity;
        }
        this.activityCreated((DiameterActivity)activity);
    }

    public void sessionDestroyed(String sessionId, ServerShSession session) {
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            this.tracer.severe("Failed to end activity with handle[" + this.getActivityHandle(sessionId));
        }
    }

    private void activityCreated(DiameterActivity ac) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating/starting activity.", (Throwable)e);
        }
    }

    public ResourceAdaptorContext getRaContext() {
        return this.raContext;
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.authApplicationIds.toArray(new ApplicationId[this.authApplicationIds.size()]));
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        this.raProvider = new ShServerProviderImpl(this);
        this.shAvpFactory = new DiameterShAvpFactoryImpl(this.baseAvpFactory);
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShServer RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        final DiameterShServerResourceAdaptor lst = this;
        if (this.ftRAContext.isLocal()) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in LOCAL mode.");
            }
            this.activities = new LocalDiameterActivityManagement();
        } else {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in CLUSTER mode.");
            }
            ReplicatedData clusteredData = this.ftRAContext.getReplicateData(true);
            this.activities = new AbstractClusteredDiameterActivityManagement(this.raContext.getTracer(""), this.stack, this.raContext.getSleeTransactionManager(), clusteredData){

                protected void performBeforeReturn(DiameterActivityImpl activity) {
                    block5: {
                        try {
                            Session session = null;
                            if (activity.getClass().equals(DiameterActivityImpl.class)) {
                                session = this.diameterStack.getSessionFactory().getNewSession(activity.getSessionId());
                                this.performBeforeReturnOnBase(activity, session);
                                return;
                            }
                            if (activity instanceof ShServerActivity) {
                                ShServerActivityImpl sh = (ShServerActivityImpl)activity;
                                ServerShSession appSession = (ServerShSession)this.diameterStack.getSession(activity.getSessionId(), ServerShSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnSh(sh, session);
                                sh.setSession(appSession);
                                break block5;
                            }
                            if (activity instanceof ShServerSubscriptionActivity) {
                                ShServerSubscriptionActivityImpl sh = (ShServerSubscriptionActivityImpl)activity;
                                ServerShSession appSession = (ServerShSession)this.diameterStack.getSession(activity.getSessionId(), ServerShSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnSh(sh, session);
                                sh.setSession(appSession);
                                break block5;
                            }
                            throw new IllegalArgumentException("Unknown activity type: " + activity);
                        }
                        catch (Exception e) {
                            throw new DiameterException((Throwable)e);
                        }
                    }
                }

                private void performBeforeReturnSh(ShServerSubscriptionActivityImpl sh, Session session) {
                    ShServerMessageFactoryImpl messageFactory = new ShServerMessageFactoryImpl(session, DiameterShServerResourceAdaptor.this.stack);
                    sh.setServerMessageFactory(messageFactory);
                    sh.setServerAvpFactory(DiameterShServerResourceAdaptor.this.shAvpFactory);
                }

                private void performBeforeReturnSh(ShServerActivityImpl sh, Session session) {
                    ShServerMessageFactoryImpl messageFactory = new ShServerMessageFactoryImpl(session, DiameterShServerResourceAdaptor.this.stack);
                    sh.setServerMessageFactory(messageFactory);
                    sh.setServerAvpFactory(DiameterShServerResourceAdaptor.this.shAvpFactory);
                }

                private void performBeforeReturnOnBase(DiameterActivityImpl ac, Session session) {
                    DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, DiameterShServerResourceAdaptor.this.stack, new DiameterIdentity[0]);
                    ac.setAvpFactory(DiameterShServerResourceAdaptor.this.baseAvpFactory);
                    ac.setMessageFactory((DiameterMessageFactory)msgFactory);
                    ac.setCurrentWorkingSession(session);
                    ac.setSessionListener((Object)lst);
                }

                public DiameterActivity get(DiameterActivityHandle handle) {
                    return super.get(handle);
                }

                public void put(DiameterActivityHandle handle, DiameterActivity activity) {
                    super.put(handle, activity);
                }

                public DiameterActivity remove(DiameterActivityHandle handle) {
                    return super.remove(handle);
                }
            };
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        try {
            this.raProvider.createActivity(request);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request req, Answer ans) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter ShServer RA :: receivedSuccessMessage :: Request[" + req + "], Answer[" + ans + "].");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + ans.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request req) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter ShServer RA :: timeoutExpired :: Request[" + req + "].");
        }
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(req.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                this.tracer.severe("Failure getting peer list.", (Throwable)e);
            }
        }
        return null;
    }

    public int getPeerCount() {
        return this.getConnectedPeers().length;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    class ShServerProviderImpl
    implements ShServerProvider {
        private DiameterShServerResourceAdaptor ra = null;
        private ArrayList<Integer> requestCodes = new ArrayList();

        public ShServerProviderImpl(DiameterShServerResourceAdaptor diameterShServerResourceAdaptor2) {
            this.ra = diameterShServerResourceAdaptor2;
            this.requestCodes.add(308);
            this.requestCodes.add(306);
            this.requestCodes.add(307);
        }

        public DiameterActivity createActivity(Request request) throws CreateActivityException {
            if (!this.requestCodes.contains(request.getCommandCode())) {
                throw new CreateActivityException("Cant create activity for unknown command code: " + request.getCommandCode());
            }
            String sessionId = request.getSessionId();
            ApplicationId appId = ApplicationId.createByAuthAppId((long)10415L, (long)0x1000001L);
            try {
                ShServerSessionImpl session = (ShServerSessionImpl)((ISessionFactory)DiameterShServerResourceAdaptor.this.sessionFactory).getNewAppSession(sessionId, appId, ServerShSession.class, new Object[]{request});
                DiameterShServerResourceAdaptor.this.sessionCreated((ServerShSession)session, request.getCommandCode() == 308);
                session.processRequest(request);
            }
            catch (Exception e) {
                throw new CreateActivityException((Throwable)e);
            }
            return (DiameterActivity)DiameterShServerResourceAdaptor.this.getActivity((ActivityHandle)DiameterShServerResourceAdaptor.this.getActivityHandle(sessionId));
        }

        public ShServerMessageFactory getServerMessageFactory() {
            return new ShServerMessageFactoryImpl(DiameterShServerResourceAdaptor.this.stack);
        }

        public DiameterShAvpFactory getServerAvpFactory() {
            return DiameterShServerResourceAdaptor.this.shAvpFactory;
        }

        public PushNotificationAnswer pushNotificationRequest(PushNotificationRequest message) throws IOException {
            if (message == null) {
                throw new NullPointerException("Message argument cannot be null.");
            }
            try {
                String sessionID = message.getSessionId();
                if (sessionID == null) {
                    throw new NullPointerException("Session-Id for message is null, cannot proceed.");
                }
                Session session = DiameterShServerResourceAdaptor.this.stack.getSessionFactory().getNewSession(sessionID);
                Future f = session.send(((DiameterMessageImpl)message).getGenericData());
                session.release();
                return new PushNotificationAnswerImpl((Message)f.get());
            }
            catch (AvpNotAllowedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to send due to: " + e);
            }
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }
    }
}

