/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server;

import java.io.IOException;
import java.util.ArrayList;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AuthSessionStateType;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.UserDataRequest;
import net.java.slee.resource.diameter.sh.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.ShServerMessageFactory;
import net.java.slee.resource.diameter.sh.server.ShServerSubscriptionActivity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationRequestImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.events.DiameterShMessageImpl;
import org.mobicents.slee.resource.diameter.sh.events.SubscribeNotificationsRequestImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerMessageFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShServerSubscriptionActivityImpl
extends DiameterActivityImpl
implements ShServerSubscriptionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 1245108589521694221L;
    protected transient ServerShSession serverSession = null;
    protected transient DiameterShAvpFactory shAvpFactory = null;
    protected transient ShServerMessageFactoryImpl messageFactory = null;
    protected UserIdentityAvp userIdentity;
    protected DataReferenceType[] dataReferenceType;
    protected AuthSessionStateType authSessionState;
    protected DiameterIdentity remoteRealm;
    protected DiameterIdentity remoteHost;
    protected ArrayList<DiameterMessageImpl> stateMessages = new ArrayList();

    public ShServerSubscriptionActivityImpl(ShServerMessageFactory shServerMessageFactory, DiameterShAvpFactory diameterShAvpFactory, ServerShSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(null, null, null, (EventListener)session, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)this.serverSession.getSessions().get(0));
        this.shAvpFactory = diameterShAvpFactory;
        this.messageFactory = (ShServerMessageFactoryImpl)shServerMessageFactory;
    }

    public PushNotificationRequest createPushNotificationRequest() {
        PushNotificationRequest request = this.messageFactory.createPushNotificationRequest();
        if (!request.hasDestinationHost() && this.remoteHost != null) {
            request.setDestinationHost(this.remoteHost);
        }
        if (!request.hasDestinationRealm() && this.remoteRealm != null) {
            request.setDestinationRealm(this.remoteRealm);
        }
        if (!request.hasUserIdentity() && this.userIdentity != null) {
            request.setExtensionAvps(new DiameterAvp[]{this.userIdentity});
        }
        if (!request.hasAuthSessionState() && this.authSessionState != null) {
            request.setAuthSessionState(this.authSessionState);
        }
        return request;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer(long resultCode, boolean isExperimentalResult) {
        SubscribeNotificationsAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 308) continue;
            SubscribeNotificationsRequest msg = (SubscribeNotificationsRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createSubscribeNotificationsAnswer(msg, resultCode, isExperimentalResult);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer() {
        SubscribeNotificationsAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 308) continue;
            SubscribeNotificationsRequest msg = (SubscribeNotificationsRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createSubscribeNotificationsAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer createProfileUpdateAnswer(long resultCode, boolean isExperimentalResult) {
        net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 307) continue;
            ProfileUpdateRequest msg = (ProfileUpdateRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createProfileUpdateAnswer(msg, resultCode, isExperimentalResult);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.UserDataAnswer createUserDataAnswer(byte[] userData) {
        net.java.slee.resource.diameter.sh.events.UserDataAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 306) continue;
            UserDataRequest msg = (UserDataRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createUserDataAnswer(msg, userData);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.UserDataAnswer createUserDataAnswer(long resultCode, boolean isExperimentalResult) {
        net.java.slee.resource.diameter.sh.events.UserDataAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 306) continue;
            UserDataRequest msg = (UserDataRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createUserDataAnswer(msg, resultCode, isExperimentalResult);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.UserDataAnswer createUserDataAnswer() {
        net.java.slee.resource.diameter.sh.events.UserDataAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 306) continue;
            UserDataRequest msg = (UserDataRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createUserDataAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer createProfileUpdateAnswer() {
        net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 307) continue;
            ProfileUpdateRequest msg = (ProfileUpdateRequest)this.stateMessages.get(index);
            answer = this.messageFactory.createProfileUpdateAnswer(msg);
            if (answer.getAuthSessionState() == null && this.authSessionState != null) {
                answer.setAuthSessionState(this.authSessionState);
            }
            ((DiameterShMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public void sendPushNotificationRequest(PushNotificationRequest message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.fetchSessionData((DiameterMessage)msg, false);
            this.serverSession.sendPushNotificationRequest((org.jdiameter.api.sh.events.PushNotificationRequest)new PushNotificationRequestImpl((Request)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendUserDataAnswer(net.java.slee.resource.diameter.sh.events.UserDataAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.serverSession.sendUserDataAnswer((UserDataAnswer)new UserDataAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendProfileUpdateAnswer(net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.fetchSessionData((DiameterMessage)msg, false);
            this.serverSession.sendProfileUpdateAnswer((ProfileUpdateAnswer)new ProfileUpdateAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendSubscribeNotificationsAnswer(SubscribeNotificationsAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.fetchSessionData((DiameterMessage)msg, false);
            this.serverSession.sendSubscribeNotificationsAnswer((org.jdiameter.api.sh.events.SubscribeNotificationsAnswer)new SubscribeNotificationsAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession arg0, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest() && incoming) {
            if (this.remoteRealm == null) {
                this.remoteRealm = msg.getOriginRealm();
            }
            if (this.remoteHost == null) {
                this.remoteHost = msg.getOriginHost();
            }
            if (msg instanceof SubscribeNotificationsRequest) {
                SubscribeNotificationsRequestImpl msgImpl = (SubscribeNotificationsRequestImpl)msg;
                if (this.authSessionState == null && msgImpl.hasAuthSessionState()) {
                    this.authSessionState = msgImpl.getAuthSessionState();
                }
                if (this.dataReferenceType == null || this.dataReferenceType.length == 0) {
                    this.dataReferenceType = msgImpl.getDataReferences();
                }
            }
            this.stateMessages.add((DiameterMessageImpl)msg);
        }
    }

    private void clean(DiameterShMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }

    public void endActivity() {
        this.serverSession.release();
        this.baseListener.endActivity(this.getActivityHandle());
        this.serverSession.removeStateChangeNotification((StateChangeListener)this);
    }

    public void setSession(ServerShSession session) {
        this.serverSession = session;
        this.serverSession.addStateChangeNotification((StateChangeListener)this);
    }

    public DiameterShAvpFactory getServerAvpFactory() {
        return this.shAvpFactory;
    }

    public ShServerMessageFactory getServerMessageFactory() {
        return this.messageFactory;
    }

    public void setServerAvpFactory(DiameterShAvpFactory shAvpFactory) {
        this.shAvpFactory = shAvpFactory;
    }

    public void setServerMessageFactory(ShServerMessageFactory messageFactory) {
        this.messageFactory = (ShServerMessageFactoryImpl)messageFactory;
    }
}

