/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.sh.server;

import java.io.IOException;
import java.util.ArrayList;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AuthSessionStateType;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.events.DiameterShMessage;
import net.java.slee.resource.diameter.sh.events.ProfileUpdateRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.UserDataRequest;
import net.java.slee.resource.diameter.sh.events.avp.DataReferenceType;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.ShServerActivity;
import net.java.slee.resource.diameter.sh.server.ShServerMessageFactory;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.sh.events.DiameterShMessageImpl;
import org.mobicents.slee.resource.diameter.sh.events.avp.UserIdentityAvpImpl;
import org.mobicents.slee.resource.diameter.sh.server.ShServerMessageFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShServerActivityImpl
extends DiameterActivityImpl
implements ShServerActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = -5297270149541413224L;
    protected transient ServerShSession serverSession = null;
    protected transient DiameterShAvpFactory shAvpFactory = null;
    protected transient ShServerMessageFactoryImpl messageFactory = null;
    protected UserIdentityAvp userIdentity;
    protected DataReferenceType[] dataReferenceType;
    protected AuthSessionStateType authSessionState;
    protected DiameterIdentity remoteRealm;
    protected DiameterIdentity remoteHost;
    protected transient ArrayList<DiameterMessage> stateMessages = new ArrayList();

    public ShServerActivityImpl(ShServerMessageFactory shServerMessageFactory, DiameterShAvpFactory diameterShAvpFactory, ServerShSession session, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(null, null, null, (EventListener)session, destinationHost, destinationRealm);
        this.setSession(session);
        super.setCurrentWorkingSession((Session)this.serverSession.getSessions().get(0));
        this.shAvpFactory = diameterShAvpFactory;
        this.messageFactory = (ShServerMessageFactoryImpl)shServerMessageFactory;
    }

    public net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer createProfileUpdateAnswer(long resultCode, boolean isExperimentalResult) {
        ProfileUpdateRequest req = (ProfileUpdateRequest)this.getSessionMessage(307);
        net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createProfileUpdateAnswer(req, resultCode, isExperimentalResult);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer createProfileUpdateAnswer() {
        ProfileUpdateRequest req = (ProfileUpdateRequest)this.getSessionMessage(307);
        net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createProfileUpdateAnswer(req);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.UserDataAnswer createUserDataAnswer(byte[] userData) {
        UserDataRequest req = (UserDataRequest)this.getSessionMessage(306);
        net.java.slee.resource.diameter.sh.events.UserDataAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createUserDataAnswer(req, userData);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.UserDataAnswer createUserDataAnswer(long resultCode, boolean isExperimentalResult) {
        UserDataRequest req = (UserDataRequest)this.getSessionMessage(306);
        net.java.slee.resource.diameter.sh.events.UserDataAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createUserDataAnswer(req, resultCode, isExperimentalResult);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public net.java.slee.resource.diameter.sh.events.UserDataAnswer createUserDataAnswer() {
        UserDataRequest req = (UserDataRequest)this.getSessionMessage(306);
        net.java.slee.resource.diameter.sh.events.UserDataAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createUserDataAnswer(req);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer(long resultCode, boolean isExperimentalResult) {
        SubscribeNotificationsRequest req = (SubscribeNotificationsRequest)this.getSessionMessage(308);
        SubscribeNotificationsAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createSubscribeNotificationsAnswer(req, resultCode, isExperimentalResult);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public SubscribeNotificationsAnswer createSubscribeNotificationsAnswer() {
        SubscribeNotificationsRequest req = (SubscribeNotificationsRequest)this.getSessionMessage(308);
        SubscribeNotificationsAnswer answer = null;
        if (req != null) {
            answer = this.messageFactory.createSubscribeNotificationsAnswer(req);
            this.addSessionData((DiameterShMessage)answer);
        }
        return answer;
    }

    public void sendSubscribeNotificationsAnswer(SubscribeNotificationsAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.fetchSessionData((DiameterMessage)msg, false);
            this.serverSession.sendSubscribeNotificationsAnswer((org.jdiameter.api.sh.events.SubscribeNotificationsAnswer)new SubscribeNotificationsAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendUserDataAnswer(net.java.slee.resource.diameter.sh.events.UserDataAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.fetchSessionData((DiameterMessage)msg, false);
            this.serverSession.sendUserDataAnswer((UserDataAnswer)new UserDataAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message.", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void sendProfileUpdateAnswer(net.java.slee.resource.diameter.sh.events.ProfileUpdateAnswer message) throws IOException {
        try {
            DiameterShMessageImpl msg = (DiameterShMessageImpl)message;
            this.fetchSessionData((DiameterMessage)msg, false);
            this.serverSession.sendProfileUpdateAnswer((ProfileUpdateAnswer)new ProfileUpdateAnswerImpl((Answer)msg.getGenericData()));
            this.clean(msg);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession arg0, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest() && incoming) {
            boolean changed = false;
            if (this.remoteRealm == null) {
                this.remoteRealm = msg.getOriginRealm();
                changed = true;
            }
            if (this.remoteHost == null) {
                changed = true;
                this.remoteHost = msg.getOriginHost();
            }
            if (this.userIdentity == null) {
                changed = true;
                AvpRepresentation rep = AvpDictionary.INSTANCE.getAvp(700, 10415L);
                this.userIdentity = new UserIdentityAvpImpl(700, 10415L, rep.getRuleMandatoryAsInt(), rep.getRuleProtectedAsInt(), AvpUtilities.getAvpAsGrouped((int)700, (long)10415L, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
            }
            if (this.authSessionState == null) {
                changed = true;
                this.authSessionState = AuthSessionStateType.fromInt((int)AvpUtilities.getAvpAsInteger32((int)277, (AvpSet)((DiameterMessageImpl)msg).getGenericData().getAvps()));
            }
            this.stateMessages.add((DiameterMessage)((DiameterMessageImpl)msg));
            if (changed) {
                this.baseListener.update(this.getActivityHandle(), (DiameterActivity)this);
            }
        }
    }

    public void endActivity() {
        this.serverSession.release();
        this.serverSession.removeStateChangeNotification((StateChangeListener)this);
        super.endActivity();
    }

    private void clean(DiameterShMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }

    private DiameterMessage getSessionMessage(int code) {
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            DiameterMessage msg = this.stateMessages.get(index);
            if (msg.getCommand().getCode() != code) continue;
            return msg;
        }
        return null;
    }

    private void addSessionData(DiameterShMessage shMessage) {
        if (shMessage.getAuthSessionState() == null && this.authSessionState != null) {
            shMessage.setAuthSessionState(this.authSessionState);
        }
    }

    public void setSession(ServerShSession session) {
        this.stateMessages = new ArrayList();
        this.serverSession = session;
        this.serverSession.addStateChangeNotification((StateChangeListener)this);
    }

    public DiameterShAvpFactory getServerAvpFactory() {
        return this.shAvpFactory;
    }

    public ShServerMessageFactory getServerMessageFactory() {
        return this.messageFactory;
    }

    public void setServerAvpFactory(DiameterShAvpFactory shAvpFactory) {
        this.shAvpFactory = shAvpFactory;
    }

    public void setServerMessageFactory(ShServerMessageFactory messageFactory) {
        this.messageFactory = (ShServerMessageFactoryImpl)messageFactory;
    }
}

