/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.DeploymentMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.ServiceComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceSbbDiscoveryComponent
implements ResourceDiscoveryComponent<ServiceComponent> {
    private final Log log = LogFactory.getLog(ServiceSbbDiscoveryComponent.class);
    private ServiceID serviceId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"discoverResources() called");
        }
        MBeanServerUtils mbeanUtils = ((ServiceComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName depMBeanObj = new ObjectName("javax.slee.management:name=Deployment");
            HashSet<DiscoveredResourceDetails> discoveredSBBs = new HashSet<DiscoveredResourceDetails>();
            DeploymentMBean depMBean = MBeanServerInvocationHandler.newProxyInstance(connection, depMBeanObj, DeploymentMBean.class, false);
            if (this.serviceId == null) {
                this.serviceId = ((ServiceComponent)context.getParentResourceComponent()).getServiceID();
            }
            SbbID[] sbbIds = depMBean.getSbbs(this.serviceId);
            this.addSbb(sbbIds, discoveredSBBs, context.getResourceType());
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Discovered " + discoveredSBBs.size() + " JAIN SLEE SBB Components for " + this.serviceId + "."));
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredSBBs;
            return hashSet;
        }
        finally {
            block10: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    private void addSbb(SbbID[] sbbIds, Set<DiscoveredResourceDetails> discoveredSbbs, ResourceType resourceType) {
        for (SbbID sbbId : sbbIds) {
            String key = sbbId.toString() + "@" + this.serviceId;
            String description = sbbId.toString();
            DiscoveredResourceDetails discoveredSbb = new DiscoveredResourceDetails(resourceType, key, sbbId.getName(), sbbId.getVersion(), description, null, null);
            discoveredSbb.getPluginConfiguration().put((Property)new PropertySimple("name", (Object)sbbId.getName()));
            discoveredSbb.getPluginConfiguration().put((Property)new PropertySimple("version", (Object)sbbId.getVersion()));
            discoveredSbb.getPluginConfiguration().put((Property)new PropertySimple("vendor", (Object)sbbId.getVendor()));
            discoveredSbbs.add(discoveredSbb);
        }
    }
}

