/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee.jbossas5.helper;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.plugins.jslee.jbossas5.helper.JBossProductType;

public class JBossInstallationInfo {
    private static final String ANY_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST_ADDRESS = "127.0.0.1";
    private static final String SOA_IMPL_VERSION_PREFIX = "SOA-";
    private static final String EAP_IMPL_VERSION_PREFIX = "EAP-";
    private static final ComparableVersion VERSION_4_2 = new ComparableVersion("4.2");
    private final JBossProductType productType;
    private final String version;
    private final String defaultBindAddress;
    private final boolean isEap;
    private final String majorVersion;

    public JBossInstallationInfo(File installationDir) throws IOException {
        File binDir = new File(installationDir, "bin");
        File runJar = new File(binDir, "run.jar");
        Attributes jarManifestAttributes = JBossInstallationInfo.loadManifestAttributesFromJar(runJar);
        this.productType = JBossProductType.determineJBossProductType(jarManifestAttributes);
        this.version = JBossInstallationInfo.getVersion(jarManifestAttributes);
        this.defaultBindAddress = JBossInstallationInfo.getDefaultServerName(this.version);
        this.isEap = JBossInstallationInfo.determineEap(jarManifestAttributes);
        this.majorVersion = this.version.substring(0, this.version.indexOf(46));
    }

    public JBossProductType getProductType() {
        return this.productType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefaultBindAddress() {
        return this.defaultBindAddress;
    }

    public boolean isEap() {
        return this.isEap;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    private static Attributes loadManifestAttributesFromJar(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Attributes mainAttributes = jar.getManifest().getMainAttributes();
        jar.close();
        return mainAttributes;
    }

    private static String getVersion(Attributes jarManifestAttributes) {
        int spaceIndex;
        String implementationVersion = jarManifestAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String version = implementationVersion.substring(0, spaceIndex = JBossInstallationInfo.validateImplementationVersion(implementationVersion));
        if (version.startsWith(SOA_IMPL_VERSION_PREFIX)) {
            version = version.substring(SOA_IMPL_VERSION_PREFIX.length());
        }
        if (version.startsWith(EAP_IMPL_VERSION_PREFIX)) {
            version = version.substring(EAP_IMPL_VERSION_PREFIX.length());
        }
        return version;
    }

    private static boolean determineEap(Attributes jarManifestAttributes) {
        String implementationTitle = jarManifestAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        return implementationTitle.contains("[EAP]");
    }

    private static int validateImplementationVersion(String implementationVersion) {
        if (implementationVersion == null) {
            throw new IllegalStateException("'" + Attributes.Name.IMPLEMENTATION_VERSION + "' MANIFEST.MF attribute not found.");
        }
        int spaceIndex = implementationVersion.indexOf(32);
        if (spaceIndex == -1) {
            throw new IllegalStateException("'" + Attributes.Name.IMPLEMENTATION_VERSION + "' MANIFEST.MF attribute has an invalid value: " + implementationVersion);
        }
        return spaceIndex;
    }

    private static String getDefaultServerName(String serverVersion) {
        ComparableVersion comparableVersion = new ComparableVersion(serverVersion);
        return comparableVersion.compareTo((Object)VERSION_4_2) >= 0 ? ANY_ADDRESS : LOCALHOST_ADDRESS;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[productType=" + (Object)((Object)this.productType) + ", version=" + this.version + ", defaultBindAddress=" + this.defaultBindAddress + "]";
    }
}

